package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorGroupSpecBuilder extends OperatorGroupSpecFluentImpl<OperatorGroupSpecBuilder> implements VisitableBuilder<OperatorGroupSpec,OperatorGroupSpecBuilder>{

    OperatorGroupSpecFluent<?> fluent;
    Boolean validationEnabled;

    public OperatorGroupSpecBuilder(){
            this(true);
    }
    public OperatorGroupSpecBuilder(Boolean validationEnabled){
            this(new OperatorGroupSpec(), validationEnabled);
    }
    public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent){
            this(fluent, true);
    }
    public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OperatorGroupSpec(), validationEnabled);
    }
    public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent,OperatorGroupSpec instance){
            this(fluent, instance, true);
    }
    public OperatorGroupSpecBuilder(OperatorGroupSpecFluent<?> fluent,OperatorGroupSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSelector(instance.getSelector()); 
            fluent.withServiceAccountName(instance.getServiceAccountName()); 
            fluent.withStaticProvidedAPIs(instance.getStaticProvidedAPIs()); 
            fluent.withTargetNamespaces(instance.getTargetNamespaces()); 
            this.validationEnabled = validationEnabled; 
    }
    public OperatorGroupSpecBuilder(OperatorGroupSpec instance){
            this(instance,true);
    }
    public OperatorGroupSpecBuilder(OperatorGroupSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSelector(instance.getSelector()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withStaticProvidedAPIs(instance.getStaticProvidedAPIs()); 
            this.withTargetNamespaces(instance.getTargetNamespaces()); 
            this.validationEnabled = validationEnabled; 
    }

    public OperatorGroupSpec build(){
            OperatorGroupSpec buildable = new OperatorGroupSpec(fluent.getSelector(),fluent.getServiceAccountName(),fluent.isStaticProvidedAPIs(),fluent.getTargetNamespaces());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OperatorGroupSpecBuilder that = (OperatorGroupSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
