package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface OperatorGroupFluent<A extends OperatorGroupFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public OperatorGroupFluent.MetadataNested<A> withNewMetadata();
    public OperatorGroupFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public OperatorGroupFluent.MetadataNested<A> editMetadata();
    public OperatorGroupFluent.MetadataNested<A> editOrNewMetadata();
    public OperatorGroupFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public OperatorGroupSpec getSpec();
    public OperatorGroupSpec buildSpec();
    public A withSpec(OperatorGroupSpec spec);
    public Boolean hasSpec();
    public OperatorGroupFluent.SpecNested<A> withNewSpec();
    public OperatorGroupFluent.SpecNested<A> withNewSpecLike(OperatorGroupSpec item);
    public OperatorGroupFluent.SpecNested<A> editSpec();
    public OperatorGroupFluent.SpecNested<A> editOrNewSpec();
    public OperatorGroupFluent.SpecNested<A> editOrNewSpecLike(OperatorGroupSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public OperatorGroupStatus getStatus();
    public OperatorGroupStatus buildStatus();
    public A withStatus(OperatorGroupStatus status);
    public Boolean hasStatus();
    public OperatorGroupFluent.StatusNested<A> withNewStatus();
    public OperatorGroupFluent.StatusNested<A> withNewStatusLike(OperatorGroupStatus item);
    public OperatorGroupFluent.StatusNested<A> editStatus();
    public OperatorGroupFluent.StatusNested<A> editOrNewStatus();
    public OperatorGroupFluent.StatusNested<A> editOrNewStatusLike(OperatorGroupStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<OperatorGroupFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorGroupSpecFluent<OperatorGroupFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorGroupStatusFluent<OperatorGroupFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
