/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.manifests;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannel;
import io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelBuilder;
import io.fabric8.openshift.api.model.operatorhub.manifests.PackageChannelFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifest;
import io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifestFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PackageManifestFluentImpl<A extends PackageManifestFluent<A>>
extends BaseFluent<A>
implements PackageManifestFluent<A> {
    private List<PackageChannelBuilder> channels = new ArrayList<PackageChannelBuilder>();
    private String defaultChannel;
    private String packageName;

    public PackageManifestFluentImpl() {
    }

    public PackageManifestFluentImpl(PackageManifest instance) {
        this.withChannels(instance.getChannels());
        this.withDefaultChannel(instance.getDefaultChannel());
        this.withPackageName(instance.getPackageName());
    }

    @Override
    public A addToChannels(int index, PackageChannel item) {
        if (this.channels == null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
        }
        PackageChannelBuilder builder = new PackageChannelBuilder(item);
        this._visitables.get((Object)"channels").add(index >= 0 ? index : this._visitables.get((Object)"channels").size(), builder);
        this.channels.add(index >= 0 ? index : this.channels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToChannels(int index, PackageChannel item) {
        if (this.channels == null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
        }
        PackageChannelBuilder builder = new PackageChannelBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"channels").size()) {
            this._visitables.get((Object)"channels").add(builder);
        } else {
            this._visitables.get((Object)"channels").set(index, builder);
        }
        if (index < 0 || index >= this.channels.size()) {
            this.channels.add(builder);
        } else {
            this.channels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToChannels(PackageChannel ... items) {
        if (this.channels == null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
        }
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get((Object)"channels").add(builder);
            this.channels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToChannels(Collection<PackageChannel> items) {
        if (this.channels == null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
        }
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get((Object)"channels").add(builder);
            this.channels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromChannels(PackageChannel ... items) {
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get((Object)"channels").remove(builder);
            if (this.channels == null) continue;
            this.channels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromChannels(Collection<PackageChannel> items) {
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get((Object)"channels").remove(builder);
            if (this.channels == null) continue;
            this.channels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromChannels(Predicate<PackageChannelBuilder> predicate) {
        if (this.channels == null) {
            return (A)this;
        }
        Iterator<PackageChannelBuilder> each = this.channels.iterator();
        List visitables = this._visitables.get((Object)"channels");
        while (each.hasNext()) {
            PackageChannelBuilder builder = each.next();
            if (!predicate.apply((Object)builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PackageChannel> getChannels() {
        return PackageManifestFluentImpl.build(this.channels);
    }

    @Override
    public List<PackageChannel> buildChannels() {
        return PackageManifestFluentImpl.build(this.channels);
    }

    @Override
    public PackageChannel buildChannel(int index) {
        return this.channels.get(index).build();
    }

    @Override
    public PackageChannel buildFirstChannel() {
        return this.channels.get(0).build();
    }

    @Override
    public PackageChannel buildLastChannel() {
        return this.channels.get(this.channels.size() - 1).build();
    }

    @Override
    public PackageChannel buildMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        for (PackageChannelBuilder item : this.channels) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        for (PackageChannelBuilder item : this.channels) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withChannels(List<PackageChannel> channels) {
        if (this.channels != null) {
            this._visitables.get((Object)"channels").removeAll(this.channels);
        }
        if (channels != null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
            for (PackageChannel item : channels) {
                this.addToChannels(item);
            }
        } else {
            this.channels = null;
        }
        return (A)this;
    }

    @Override
    public A withChannels(PackageChannel ... channels) {
        if (this.channels != null) {
            this.channels.clear();
        }
        if (channels != null) {
            for (PackageChannel item : channels) {
                this.addToChannels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasChannels() {
        return this.channels != null && !this.channels.isEmpty();
    }

    @Override
    public A addNewChannel(String currentCSV, String name) {
        return this.addToChannels(new PackageChannel(currentCSV, name));
    }

    @Override
    public PackageManifestFluent.ChannelsNested<A> addNewChannel() {
        return new ChannelsNestedImpl();
    }

    @Override
    public PackageManifestFluent.ChannelsNested<A> addNewChannelLike(PackageChannel item) {
        return new ChannelsNestedImpl(-1, item);
    }

    @Override
    public PackageManifestFluent.ChannelsNested<A> setNewChannelLike(int index, PackageChannel item) {
        return new ChannelsNestedImpl(index, item);
    }

    @Override
    public PackageManifestFluent.ChannelsNested<A> editChannel(int index) {
        if (this.channels.size() <= index) {
            throw new RuntimeException("Can't edit channels. Index exceeds size.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    @Override
    public PackageManifestFluent.ChannelsNested<A> editFirstChannel() {
        if (this.channels.size() == 0) {
            throw new RuntimeException("Can't edit first channels. The list is empty.");
        }
        return this.setNewChannelLike(0, this.buildChannel(0));
    }

    @Override
    public PackageManifestFluent.ChannelsNested<A> editLastChannel() {
        int index = this.channels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last channels. The list is empty.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    @Override
    public PackageManifestFluent.ChannelsNested<A> editMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.channels.size(); ++i) {
            if (!predicate.apply((Object)this.channels.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching channels. No match found.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    @Override
    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    @Override
    public A withDefaultChannel(String defaultChannel) {
        this.defaultChannel = defaultChannel;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultChannel() {
        return this.defaultChannel != null;
    }

    @Override
    public A withNewDefaultChannel(String arg1) {
        return this.withDefaultChannel(new String(arg1));
    }

    @Override
    public A withNewDefaultChannel(StringBuilder arg1) {
        return this.withDefaultChannel(new String(arg1));
    }

    @Override
    public A withNewDefaultChannel(StringBuffer arg1) {
        return this.withDefaultChannel(new String(arg1));
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public A withPackageName(String packageName) {
        this.packageName = packageName;
        return (A)this;
    }

    @Override
    public Boolean hasPackageName() {
        return this.packageName != null;
    }

    @Override
    public A withNewPackageName(String arg1) {
        return this.withPackageName(new String(arg1));
    }

    @Override
    public A withNewPackageName(StringBuilder arg1) {
        return this.withPackageName(new String(arg1));
    }

    @Override
    public A withNewPackageName(StringBuffer arg1) {
        return this.withPackageName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageManifestFluentImpl that = (PackageManifestFluentImpl)o;
        if (this.channels != null ? !this.channels.equals(that.channels) : that.channels != null) {
            return false;
        }
        if (this.defaultChannel != null ? !this.defaultChannel.equals(that.defaultChannel) : that.defaultChannel != null) {
            return false;
        }
        return !(this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null);
    }

    public class ChannelsNestedImpl<N>
    extends PackageChannelFluentImpl<PackageManifestFluent.ChannelsNested<N>>
    implements PackageManifestFluent.ChannelsNested<N>,
    Nested<N> {
        private final PackageChannelBuilder builder;
        private final int index;

        ChannelsNestedImpl(int index, PackageChannel item) {
            this.index = index;
            this.builder = new PackageChannelBuilder(this, item);
        }

        ChannelsNestedImpl() {
            this.index = -1;
            this.builder = new PackageChannelBuilder(this);
        }

        @Override
        public N and() {
            return (N)PackageManifestFluentImpl.this.setToChannels(this.index, this.builder.build());
        }

        @Override
        public N endChannel() {
            return this.and();
        }
    }
}

