package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorGroupBuilder extends OperatorGroupFluentImpl<OperatorGroupBuilder> implements VisitableBuilder<OperatorGroup,OperatorGroupBuilder>{

    OperatorGroupFluent<?> fluent;
    Boolean validationEnabled;

    public OperatorGroupBuilder(){
            this(true);
    }
    public OperatorGroupBuilder(Boolean validationEnabled){
            this(new OperatorGroup(), validationEnabled);
    }
    public OperatorGroupBuilder(OperatorGroupFluent<?> fluent){
            this(fluent, true);
    }
    public OperatorGroupBuilder(OperatorGroupFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new OperatorGroup(), validationEnabled);
    }
    public OperatorGroupBuilder(OperatorGroupFluent<?> fluent,OperatorGroup instance){
            this(fluent, instance, true);
    }
    public OperatorGroupBuilder(OperatorGroupFluent<?> fluent,OperatorGroup instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public OperatorGroupBuilder(OperatorGroup instance){
            this(instance,true);
    }
    public OperatorGroupBuilder(OperatorGroup instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public OperatorGroup build(){
            OperatorGroup buildable = new OperatorGroup(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            OperatorGroupBuilder that = (OperatorGroupBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
