package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.String;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionCatalogHealthFluentImpl<A extends SubscriptionCatalogHealthFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubscriptionCatalogHealthFluent<A>{

    private ObjectReferenceBuilder catalogSourceRef;
    private Boolean healthy;
    private String lastUpdated;

    public SubscriptionCatalogHealthFluentImpl(){
    }
    public SubscriptionCatalogHealthFluentImpl(SubscriptionCatalogHealth instance){
            this.withCatalogSourceRef(instance.getCatalogSourceRef()); 
            this.withHealthy(instance.getHealthy()); 
            this.withLastUpdated(instance.getLastUpdated()); 
    }

    
/**
 * This method has been deprecated, please use method buildCatalogSourceRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getCatalogSourceRef(){
            return this.catalogSourceRef!=null?this.catalogSourceRef.build():null;
    }

    public ObjectReference buildCatalogSourceRef(){
            return this.catalogSourceRef!=null?this.catalogSourceRef.build():null;
    }

    public A withCatalogSourceRef(ObjectReference catalogSourceRef){
            _visitables.get("catalogSourceRef").remove(this.catalogSourceRef);
            if (catalogSourceRef!=null){ this.catalogSourceRef= new ObjectReferenceBuilder(catalogSourceRef); _visitables.get("catalogSourceRef").add(this.catalogSourceRef);} return (A) this;
    }

    public Boolean hasCatalogSourceRef(){
            return this.catalogSourceRef != null;
    }

    public SubscriptionCatalogHealthFluent.CatalogSourceRefNested<A> withNewCatalogSourceRef(){
            return new CatalogSourceRefNestedImpl();
    }

    public SubscriptionCatalogHealthFluent.CatalogSourceRefNested<A> withNewCatalogSourceRefLike(ObjectReference item){
            return new CatalogSourceRefNestedImpl(item);
    }

    public SubscriptionCatalogHealthFluent.CatalogSourceRefNested<A> editCatalogSourceRef(){
            return withNewCatalogSourceRefLike(getCatalogSourceRef());
    }

    public SubscriptionCatalogHealthFluent.CatalogSourceRefNested<A> editOrNewCatalogSourceRef(){
            return withNewCatalogSourceRefLike(getCatalogSourceRef() != null ? getCatalogSourceRef(): new ObjectReferenceBuilder().build());
    }

    public SubscriptionCatalogHealthFluent.CatalogSourceRefNested<A> editOrNewCatalogSourceRefLike(ObjectReference item){
            return withNewCatalogSourceRefLike(getCatalogSourceRef() != null ? getCatalogSourceRef(): item);
    }

    public Boolean isHealthy(){
            return this.healthy;
    }

    public A withHealthy(Boolean healthy){
            this.healthy=healthy; return (A) this;
    }

    public Boolean hasHealthy(){
            return this.healthy != null;
    }

    public A withNewHealthy(String arg1){
            return (A)withHealthy(new Boolean(arg1));
    }

    public A withNewHealthy(boolean arg1){
            return (A)withHealthy(new Boolean(arg1));
    }

    public String getLastUpdated(){
            return this.lastUpdated;
    }

    public A withLastUpdated(String lastUpdated){
            this.lastUpdated=lastUpdated; return (A) this;
    }

    public Boolean hasLastUpdated(){
            return this.lastUpdated != null;
    }

    public A withNewLastUpdated(String arg1){
            return (A)withLastUpdated(new String(arg1));
    }

    public A withNewLastUpdated(StringBuilder arg1){
            return (A)withLastUpdated(new String(arg1));
    }

    public A withNewLastUpdated(StringBuffer arg1){
            return (A)withLastUpdated(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SubscriptionCatalogHealthFluentImpl that = (SubscriptionCatalogHealthFluentImpl) o;
            if (catalogSourceRef != null ? !catalogSourceRef.equals(that.catalogSourceRef) :that.catalogSourceRef != null) return false;
            if (healthy != null ? !healthy.equals(that.healthy) :that.healthy != null) return false;
            if (lastUpdated != null ? !lastUpdated.equals(that.lastUpdated) :that.lastUpdated != null) return false;
            return true;
    }


    public class CatalogSourceRefNestedImpl<N> extends ObjectReferenceFluentImpl<SubscriptionCatalogHealthFluent.CatalogSourceRefNested<N>> implements SubscriptionCatalogHealthFluent.CatalogSourceRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            CatalogSourceRefNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            CatalogSourceRefNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) SubscriptionCatalogHealthFluentImpl.this.withCatalogSourceRef(builder.build());
    }
    public N endCatalogSourceRef(){
            return and();
    }

}


}
