package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionBuilder extends SubscriptionFluentImpl<SubscriptionBuilder> implements VisitableBuilder<Subscription,SubscriptionBuilder>{

    SubscriptionFluent<?> fluent;
    Boolean validationEnabled;

    public SubscriptionBuilder(){
            this(true);
    }
    public SubscriptionBuilder(Boolean validationEnabled){
            this(new Subscription(), validationEnabled);
    }
    public SubscriptionBuilder(SubscriptionFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriptionBuilder(SubscriptionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Subscription(), validationEnabled);
    }
    public SubscriptionBuilder(SubscriptionFluent<?> fluent,Subscription instance){
            this(fluent, instance, true);
    }
    public SubscriptionBuilder(SubscriptionFluent<?> fluent,Subscription instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionBuilder(Subscription instance){
            this(instance,true);
    }
    public SubscriptionBuilder(Subscription instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public Subscription build(){
            Subscription buildable = new Subscription(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriptionBuilder that = (SubscriptionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
