package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class InstallPlanReferenceFluentImpl<A extends InstallPlanReferenceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InstallPlanReferenceFluent<A>{

    private String apiVersion;
    private String kind;
    private String name;
    private String uuid;

    public InstallPlanReferenceFluentImpl(){
    }
    public InstallPlanReferenceFluentImpl(InstallPlanReference instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withUuid(instance.getUuid()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getUuid(){
            return this.uuid;
    }

    public A withUuid(String uuid){
            this.uuid=uuid; return (A) this;
    }

    public Boolean hasUuid(){
            return this.uuid != null;
    }

    public A withNewUuid(String arg1){
            return (A)withUuid(new String(arg1));
    }

    public A withNewUuid(StringBuilder arg1){
            return (A)withUuid(new String(arg1));
    }

    public A withNewUuid(StringBuffer arg1){
            return (A)withUuid(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            InstallPlanReferenceFluentImpl that = (InstallPlanReferenceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (uuid != null ? !uuid.equals(that.uuid) :that.uuid != null) return false;
            return true;
    }




}
