package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GRPCConnectionStateBuilder extends GRPCConnectionStateFluentImpl<GRPCConnectionStateBuilder> implements VisitableBuilder<GRPCConnectionState,GRPCConnectionStateBuilder>{

    GRPCConnectionStateFluent<?> fluent;
    Boolean validationEnabled;

    public GRPCConnectionStateBuilder(){
            this(true);
    }
    public GRPCConnectionStateBuilder(Boolean validationEnabled){
            this(new GRPCConnectionState(), validationEnabled);
    }
    public GRPCConnectionStateBuilder(GRPCConnectionStateFluent<?> fluent){
            this(fluent, true);
    }
    public GRPCConnectionStateBuilder(GRPCConnectionStateFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GRPCConnectionState(), validationEnabled);
    }
    public GRPCConnectionStateBuilder(GRPCConnectionStateFluent<?> fluent,GRPCConnectionState instance){
            this(fluent, instance, true);
    }
    public GRPCConnectionStateBuilder(GRPCConnectionStateFluent<?> fluent,GRPCConnectionState instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress()); 
            fluent.withLastConnect(instance.getLastConnect()); 
            fluent.withLastObservedState(instance.getLastObservedState()); 
            this.validationEnabled = validationEnabled; 
    }
    public GRPCConnectionStateBuilder(GRPCConnectionState instance){
            this(instance,true);
    }
    public GRPCConnectionStateBuilder(GRPCConnectionState instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress()); 
            this.withLastConnect(instance.getLastConnect()); 
            this.withLastObservedState(instance.getLastObservedState()); 
            this.validationEnabled = validationEnabled; 
    }

    public GRPCConnectionState build(){
            GRPCConnectionState buildable = new GRPCConnectionState(fluent.getAddress(),fluent.getLastConnect(),fluent.getLastObservedState());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GRPCConnectionStateBuilder that = (GRPCConnectionStateBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
