package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class ClusterServiceVersionStatusFluentImpl<A extends ClusterServiceVersionStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterServiceVersionStatusFluent<A>{

    private String certsLastUpdated;
    private String certsRotateAt;
    private List<ClusterServiceVersionConditionBuilder> conditions =  new ArrayList<ClusterServiceVersionConditionBuilder>();
    private String lastTransitionTime;
    private String lastUpdateTime;
    private String message;
    private String phase;
    private String reason;
    private List<RequirementStatusBuilder> requirementStatus =  new ArrayList<RequirementStatusBuilder>();

    public ClusterServiceVersionStatusFluentImpl(){
    }
    public ClusterServiceVersionStatusFluentImpl(ClusterServiceVersionStatus instance){
            this.withCertsLastUpdated(instance.getCertsLastUpdated()); 
            this.withCertsRotateAt(instance.getCertsRotateAt()); 
            this.withConditions(instance.getConditions()); 
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withLastUpdateTime(instance.getLastUpdateTime()); 
            this.withMessage(instance.getMessage()); 
            this.withPhase(instance.getPhase()); 
            this.withReason(instance.getReason()); 
            this.withRequirementStatus(instance.getRequirementStatus()); 
    }

    public String getCertsLastUpdated(){
            return this.certsLastUpdated;
    }

    public A withCertsLastUpdated(String certsLastUpdated){
            this.certsLastUpdated=certsLastUpdated; return (A) this;
    }

    public Boolean hasCertsLastUpdated(){
            return this.certsLastUpdated != null;
    }

    public A withNewCertsLastUpdated(String arg1){
            return (A)withCertsLastUpdated(new String(arg1));
    }

    public A withNewCertsLastUpdated(StringBuilder arg1){
            return (A)withCertsLastUpdated(new String(arg1));
    }

    public A withNewCertsLastUpdated(StringBuffer arg1){
            return (A)withCertsLastUpdated(new String(arg1));
    }

    public String getCertsRotateAt(){
            return this.certsRotateAt;
    }

    public A withCertsRotateAt(String certsRotateAt){
            this.certsRotateAt=certsRotateAt; return (A) this;
    }

    public Boolean hasCertsRotateAt(){
            return this.certsRotateAt != null;
    }

    public A withNewCertsRotateAt(String arg1){
            return (A)withCertsRotateAt(new String(arg1));
    }

    public A withNewCertsRotateAt(StringBuilder arg1){
            return (A)withCertsRotateAt(new String(arg1));
    }

    public A withNewCertsRotateAt(StringBuffer arg1){
            return (A)withCertsRotateAt(new String(arg1));
    }

    public A addToConditions(int index,ClusterServiceVersionCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ClusterServiceVersionConditionBuilder>();}
            ClusterServiceVersionConditionBuilder builder = new ClusterServiceVersionConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,ClusterServiceVersionCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<ClusterServiceVersionConditionBuilder>();}
            ClusterServiceVersionConditionBuilder builder = new ClusterServiceVersionConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(ClusterServiceVersionCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<ClusterServiceVersionConditionBuilder>();}
            for (ClusterServiceVersionCondition item : items) {ClusterServiceVersionConditionBuilder builder = new ClusterServiceVersionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<ClusterServiceVersionCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<ClusterServiceVersionConditionBuilder>();}
            for (ClusterServiceVersionCondition item : items) {ClusterServiceVersionConditionBuilder builder = new ClusterServiceVersionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(ClusterServiceVersionCondition... items){
            for (ClusterServiceVersionCondition item : items) {ClusterServiceVersionConditionBuilder builder = new ClusterServiceVersionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<ClusterServiceVersionCondition> items){
            for (ClusterServiceVersionCondition item : items) {ClusterServiceVersionConditionBuilder builder = new ClusterServiceVersionConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(io.fabric8.kubernetes.api.builder.Predicate<ClusterServiceVersionConditionBuilder> predicate){
            if (conditions == null) return (A) this;
            final Iterator<ClusterServiceVersionConditionBuilder> each = conditions.iterator();
            final List visitables = _visitables.get("conditions");
            while (each.hasNext()) {
              ClusterServiceVersionConditionBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterServiceVersionCondition> getConditions(){
            return build(conditions);
    }

    public List<ClusterServiceVersionCondition> buildConditions(){
            return build(conditions);
    }

    public ClusterServiceVersionCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public ClusterServiceVersionCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public ClusterServiceVersionCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public ClusterServiceVersionCondition buildMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ClusterServiceVersionConditionBuilder> predicate){
            for (ClusterServiceVersionConditionBuilder item: conditions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ClusterServiceVersionConditionBuilder> predicate){
            for (ClusterServiceVersionConditionBuilder item: conditions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withConditions(List<ClusterServiceVersionCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<ClusterServiceVersionConditionBuilder>(); for (ClusterServiceVersionCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(ClusterServiceVersionCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (ClusterServiceVersionCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String lastUpdateTime,String message,String phase,String reason){
            return (A)addToConditions(new ClusterServiceVersionCondition(lastTransitionTime, lastUpdateTime, message, phase, reason));
    }

    public ClusterServiceVersionStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public ClusterServiceVersionStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterServiceVersionCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public ClusterServiceVersionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterServiceVersionCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public ClusterServiceVersionStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ClusterServiceVersionStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public ClusterServiceVersionStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public ClusterServiceVersionStatusFluent.ConditionsNested<A> editMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<ClusterServiceVersionConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public String getLastTransitionTime(){
            return this.lastTransitionTime;
    }

    public A withLastTransitionTime(String lastTransitionTime){
            this.lastTransitionTime=lastTransitionTime; return (A) this;
    }

    public Boolean hasLastTransitionTime(){
            return this.lastTransitionTime != null;
    }

    public A withNewLastTransitionTime(String arg1){
            return (A)withLastTransitionTime(new String(arg1));
    }

    public A withNewLastTransitionTime(StringBuilder arg1){
            return (A)withLastTransitionTime(new String(arg1));
    }

    public A withNewLastTransitionTime(StringBuffer arg1){
            return (A)withLastTransitionTime(new String(arg1));
    }

    public String getLastUpdateTime(){
            return this.lastUpdateTime;
    }

    public A withLastUpdateTime(String lastUpdateTime){
            this.lastUpdateTime=lastUpdateTime; return (A) this;
    }

    public Boolean hasLastUpdateTime(){
            return this.lastUpdateTime != null;
    }

    public A withNewLastUpdateTime(String arg1){
            return (A)withLastUpdateTime(new String(arg1));
    }

    public A withNewLastUpdateTime(StringBuilder arg1){
            return (A)withLastUpdateTime(new String(arg1));
    }

    public A withNewLastUpdateTime(StringBuffer arg1){
            return (A)withLastUpdateTime(new String(arg1));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getPhase(){
            return this.phase;
    }

    public A withPhase(String phase){
            this.phase=phase; return (A) this;
    }

    public Boolean hasPhase(){
            return this.phase != null;
    }

    public A withNewPhase(String arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1){
            return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1){
            return (A)withPhase(new String(arg1));
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason != null;
    }

    public A withNewReason(String arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1){
            return (A)withReason(new String(arg1));
    }

    public A addToRequirementStatus(int index,RequirementStatus item){
            if (this.requirementStatus == null) {this.requirementStatus = new ArrayList<RequirementStatusBuilder>();}
            RequirementStatusBuilder builder = new RequirementStatusBuilder(item);_visitables.get("requirementStatus").add(index >= 0 ? index : _visitables.get("requirementStatus").size(), builder);this.requirementStatus.add(index >= 0 ? index : requirementStatus.size(), builder); return (A)this;
    }

    public A setToRequirementStatus(int index,RequirementStatus item){
            if (this.requirementStatus == null) {this.requirementStatus = new ArrayList<RequirementStatusBuilder>();}
            RequirementStatusBuilder builder = new RequirementStatusBuilder(item);
            if (index < 0 || index >= _visitables.get("requirementStatus").size()) { _visitables.get("requirementStatus").add(builder); } else { _visitables.get("requirementStatus").set(index, builder);}
            if (index < 0 || index >= requirementStatus.size()) { requirementStatus.add(builder); } else { requirementStatus.set(index, builder);}
             return (A)this;
    }

    public A addToRequirementStatus(RequirementStatus... items){
            if (this.requirementStatus == null) {this.requirementStatus = new ArrayList<RequirementStatusBuilder>();}
            for (RequirementStatus item : items) {RequirementStatusBuilder builder = new RequirementStatusBuilder(item);_visitables.get("requirementStatus").add(builder);this.requirementStatus.add(builder);} return (A)this;
    }

    public A addAllToRequirementStatus(Collection<RequirementStatus> items){
            if (this.requirementStatus == null) {this.requirementStatus = new ArrayList<RequirementStatusBuilder>();}
            for (RequirementStatus item : items) {RequirementStatusBuilder builder = new RequirementStatusBuilder(item);_visitables.get("requirementStatus").add(builder);this.requirementStatus.add(builder);} return (A)this;
    }

    public A removeFromRequirementStatus(RequirementStatus... items){
            for (RequirementStatus item : items) {RequirementStatusBuilder builder = new RequirementStatusBuilder(item);_visitables.get("requirementStatus").remove(builder);if (this.requirementStatus != null) {this.requirementStatus.remove(builder);}} return (A)this;
    }

    public A removeAllFromRequirementStatus(Collection<RequirementStatus> items){
            for (RequirementStatus item : items) {RequirementStatusBuilder builder = new RequirementStatusBuilder(item);_visitables.get("requirementStatus").remove(builder);if (this.requirementStatus != null) {this.requirementStatus.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRequirementStatus(io.fabric8.kubernetes.api.builder.Predicate<RequirementStatusBuilder> predicate){
            if (requirementStatus == null) return (A) this;
            final Iterator<RequirementStatusBuilder> each = requirementStatus.iterator();
            final List visitables = _visitables.get("requirementStatus");
            while (each.hasNext()) {
              RequirementStatusBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRequirementStatus instead.
 * @return The buildable object.
 */
@Deprecated public List<RequirementStatus> getRequirementStatus(){
            return build(requirementStatus);
    }

    public List<RequirementStatus> buildRequirementStatus(){
            return build(requirementStatus);
    }

    public RequirementStatus buildRequirementStatus(int index){
            return this.requirementStatus.get(index).build();
    }

    public RequirementStatus buildFirstRequirementStatus(){
            return this.requirementStatus.get(0).build();
    }

    public RequirementStatus buildLastRequirementStatus(){
            return this.requirementStatus.get(requirementStatus.size() - 1).build();
    }

    public RequirementStatus buildMatchingRequirementStatus(io.fabric8.kubernetes.api.builder.Predicate<RequirementStatusBuilder> predicate){
            for (RequirementStatusBuilder item: requirementStatus) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRequirementStatus(io.fabric8.kubernetes.api.builder.Predicate<RequirementStatusBuilder> predicate){
            for (RequirementStatusBuilder item: requirementStatus) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRequirementStatus(List<RequirementStatus> requirementStatus){
            if (this.requirementStatus != null) { _visitables.get("requirementStatus").removeAll(this.requirementStatus);}
            if (requirementStatus != null) {this.requirementStatus = new ArrayList<RequirementStatusBuilder>(); for (RequirementStatus item : requirementStatus){this.addToRequirementStatus(item);}} else { this.requirementStatus = null;} return (A) this;
    }

    public A withRequirementStatus(RequirementStatus... requirementStatus){
            if (this.requirementStatus != null) {this.requirementStatus.clear();}
            if (requirementStatus != null) {for (RequirementStatus item :requirementStatus){ this.addToRequirementStatus(item);}} return (A) this;
    }

    public Boolean hasRequirementStatus(){
            return requirementStatus != null && !requirementStatus.isEmpty();
    }

    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> addNewRequirementStatus(){
            return new RequirementStatusNestedImpl();
    }

    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> addNewRequirementStatusLike(RequirementStatus item){
            return new RequirementStatusNestedImpl(-1, item);
    }

    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> setNewRequirementStatusLike(int index,RequirementStatus item){
            return new RequirementStatusNestedImpl(index, item);
    }

    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> editRequirementStatus(int index){
            if (requirementStatus.size() <= index) throw new RuntimeException("Can't edit requirementStatus. Index exceeds size.");
            return setNewRequirementStatusLike(index, buildRequirementStatus(index));
    }

    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> editFirstRequirementStatus(){
            if (requirementStatus.size() == 0) throw new RuntimeException("Can't edit first requirementStatus. The list is empty.");
            return setNewRequirementStatusLike(0, buildRequirementStatus(0));
    }

    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> editLastRequirementStatus(){
            int index = requirementStatus.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last requirementStatus. The list is empty.");
            return setNewRequirementStatusLike(index, buildRequirementStatus(index));
    }

    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> editMatchingRequirementStatus(io.fabric8.kubernetes.api.builder.Predicate<RequirementStatusBuilder> predicate){
            int index = -1;
            for (int i=0;i<requirementStatus.size();i++) { 
            if (predicate.apply(requirementStatus.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching requirementStatus. No match found.");
            return setNewRequirementStatusLike(index, buildRequirementStatus(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ClusterServiceVersionStatusFluentImpl that = (ClusterServiceVersionStatusFluentImpl) o;
            if (certsLastUpdated != null ? !certsLastUpdated.equals(that.certsLastUpdated) :that.certsLastUpdated != null) return false;
            if (certsRotateAt != null ? !certsRotateAt.equals(that.certsRotateAt) :that.certsRotateAt != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (lastUpdateTime != null ? !lastUpdateTime.equals(that.lastUpdateTime) :that.lastUpdateTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (requirementStatus != null ? !requirementStatus.equals(that.requirementStatus) :that.requirementStatus != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends ClusterServiceVersionConditionFluentImpl<ClusterServiceVersionStatusFluent.ConditionsNested<N>> implements ClusterServiceVersionStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterServiceVersionConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,ClusterServiceVersionCondition item){
                    this.index = index;
                    this.builder = new ClusterServiceVersionConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new ClusterServiceVersionConditionBuilder(this);
            }
    
    public N and(){
            return (N) ClusterServiceVersionStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition(){
            return and();
    }

}
    public class RequirementStatusNestedImpl<N> extends RequirementStatusFluentImpl<ClusterServiceVersionStatusFluent.RequirementStatusNested<N>> implements ClusterServiceVersionStatusFluent.RequirementStatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RequirementStatusBuilder builder;
        private final int index;
    
            RequirementStatusNestedImpl(int index,RequirementStatus item){
                    this.index = index;
                    this.builder = new RequirementStatusBuilder(this, item);
            }
            RequirementStatusNestedImpl(){
                    this.index = -1;
                    this.builder = new RequirementStatusBuilder(this);
            }
    
    public N and(){
            return (N) ClusterServiceVersionStatusFluentImpl.this.setToRequirementStatus(index,builder.build());
    }
    public N endRequirementStatus(){
            return and();
    }

}


}
