package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppLinkBuilder extends AppLinkFluentImpl<AppLinkBuilder> implements VisitableBuilder<AppLink,AppLinkBuilder>{

    AppLinkFluent<?> fluent;
    Boolean validationEnabled;

    public AppLinkBuilder(){
            this(true);
    }
    public AppLinkBuilder(Boolean validationEnabled){
            this(new AppLink(), validationEnabled);
    }
    public AppLinkBuilder(AppLinkFluent<?> fluent){
            this(fluent, true);
    }
    public AppLinkBuilder(AppLinkFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppLink(), validationEnabled);
    }
    public AppLinkBuilder(AppLinkFluent<?> fluent,AppLink instance){
            this(fluent, instance, true);
    }
    public AppLinkBuilder(AppLinkFluent<?> fluent,AppLink instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }
    public AppLinkBuilder(AppLink instance){
            this(instance,true);
    }
    public AppLinkBuilder(AppLink instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withUrl(instance.getUrl()); 
            this.validationEnabled = validationEnabled; 
    }

    public AppLink build(){
            AppLink buildable = new AppLink(fluent.getName(),fluent.getUrl());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppLinkBuilder that = (AppLinkBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
