package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionCatalogHealthBuilder extends SubscriptionCatalogHealthFluentImpl<SubscriptionCatalogHealthBuilder> implements VisitableBuilder<SubscriptionCatalogHealth,SubscriptionCatalogHealthBuilder>{

    SubscriptionCatalogHealthFluent<?> fluent;
    Boolean validationEnabled;

    public SubscriptionCatalogHealthBuilder(){
            this(true);
    }
    public SubscriptionCatalogHealthBuilder(Boolean validationEnabled){
            this(new SubscriptionCatalogHealth(), validationEnabled);
    }
    public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealthFluent<?> fluent){
            this(fluent, true);
    }
    public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealthFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscriptionCatalogHealth(), validationEnabled);
    }
    public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealthFluent<?> fluent,SubscriptionCatalogHealth instance){
            this(fluent, instance, true);
    }
    public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealthFluent<?> fluent,SubscriptionCatalogHealth instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCatalogSourceRef(instance.getCatalogSourceRef()); 
            fluent.withHealthy(instance.getHealthy()); 
            fluent.withLastUpdated(instance.getLastUpdated()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealth instance){
            this(instance,true);
    }
    public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealth instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCatalogSourceRef(instance.getCatalogSourceRef()); 
            this.withHealthy(instance.getHealthy()); 
            this.withLastUpdated(instance.getLastUpdated()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscriptionCatalogHealth build(){
            SubscriptionCatalogHealth buildable = new SubscriptionCatalogHealth(fluent.getCatalogSourceRef(),fluent.isHealthy(),fluent.getLastUpdated());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscriptionCatalogHealthBuilder that = (SubscriptionCatalogHealthBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
