package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StrategyDeploymentPermissionsBuilder extends StrategyDeploymentPermissionsFluentImpl<StrategyDeploymentPermissionsBuilder> implements VisitableBuilder<StrategyDeploymentPermissions,StrategyDeploymentPermissionsBuilder>{

    StrategyDeploymentPermissionsFluent<?> fluent;
    Boolean validationEnabled;

    public StrategyDeploymentPermissionsBuilder(){
            this(true);
    }
    public StrategyDeploymentPermissionsBuilder(Boolean validationEnabled){
            this(new StrategyDeploymentPermissions(), validationEnabled);
    }
    public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissionsFluent<?> fluent){
            this(fluent, true);
    }
    public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StrategyDeploymentPermissions(), validationEnabled);
    }
    public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissionsFluent<?> fluent,StrategyDeploymentPermissions instance){
            this(fluent, instance, true);
    }
    public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissionsFluent<?> fluent,StrategyDeploymentPermissions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRules(instance.getRules()); 
            fluent.withServiceAccountName(instance.getServiceAccountName()); 
            this.validationEnabled = validationEnabled; 
    }
    public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissions instance){
            this(instance,true);
    }
    public StrategyDeploymentPermissionsBuilder(StrategyDeploymentPermissions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRules(instance.getRules()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.validationEnabled = validationEnabled; 
    }

    public StrategyDeploymentPermissions build(){
            StrategyDeploymentPermissions buildable = new StrategyDeploymentPermissions(fluent.getRules(),fluent.getServiceAccountName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StrategyDeploymentPermissionsBuilder that = (StrategyDeploymentPermissionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
