package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterServiceVersionStatusBuilder extends ClusterServiceVersionStatusFluentImpl<ClusterServiceVersionStatusBuilder> implements VisitableBuilder<ClusterServiceVersionStatus,ClusterServiceVersionStatusBuilder>{

    ClusterServiceVersionStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterServiceVersionStatusBuilder(){
            this(true);
    }
    public ClusterServiceVersionStatusBuilder(Boolean validationEnabled){
            this(new ClusterServiceVersionStatus(), validationEnabled);
    }
    public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterServiceVersionStatus(), validationEnabled);
    }
    public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatusFluent<?> fluent,ClusterServiceVersionStatus instance){
            this(fluent, instance, true);
    }
    public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatusFluent<?> fluent,ClusterServiceVersionStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCertsLastUpdated(instance.getCertsLastUpdated()); 
            fluent.withCertsRotateAt(instance.getCertsRotateAt()); 
            fluent.withConditions(instance.getConditions()); 
            fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
            fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
            fluent.withMessage(instance.getMessage()); 
            fluent.withPhase(instance.getPhase()); 
            fluent.withReason(instance.getReason()); 
            fluent.withRequirementStatus(instance.getRequirementStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatus instance){
            this(instance,true);
    }
    public ClusterServiceVersionStatusBuilder(ClusterServiceVersionStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCertsLastUpdated(instance.getCertsLastUpdated()); 
            this.withCertsRotateAt(instance.getCertsRotateAt()); 
            this.withConditions(instance.getConditions()); 
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withLastUpdateTime(instance.getLastUpdateTime()); 
            this.withMessage(instance.getMessage()); 
            this.withPhase(instance.getPhase()); 
            this.withReason(instance.getReason()); 
            this.withRequirementStatus(instance.getRequirementStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterServiceVersionStatus build(){
            ClusterServiceVersionStatus buildable = new ClusterServiceVersionStatus(fluent.getCertsLastUpdated(),fluent.getCertsRotateAt(),fluent.getConditions(),fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getPhase(),fluent.getReason(),fluent.getRequirementStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterServiceVersionStatusBuilder that = (ClusterServiceVersionStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
