package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class CatalogSourceStatusFluentImpl<A extends CatalogSourceStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CatalogSourceStatusFluent<A>{

    private ConfigMapResourceReferenceBuilder configMapReference;
    private GRPCConnectionStateBuilder connectionState;
    private String latestImageRegistryPoll;
    private String message;
    private String reason;
    private RegistryServiceStatusBuilder registryService;

    public CatalogSourceStatusFluentImpl(){
    }
    public CatalogSourceStatusFluentImpl(CatalogSourceStatus instance){
            this.withConfigMapReference(instance.getConfigMapReference()); 
            this.withConnectionState(instance.getConnectionState()); 
            this.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withRegistryService(instance.getRegistryService()); 
    }

    
/**
 * This method has been deprecated, please use method buildConfigMapReference instead.
 * @return The buildable object.
 */
@Deprecated public ConfigMapResourceReference getConfigMapReference(){
            return this.configMapReference!=null?this.configMapReference.build():null;
    }

    public ConfigMapResourceReference buildConfigMapReference(){
            return this.configMapReference!=null?this.configMapReference.build():null;
    }

    public A withConfigMapReference(ConfigMapResourceReference configMapReference){
            _visitables.get("configMapReference").remove(this.configMapReference);
            if (configMapReference!=null){ this.configMapReference= new ConfigMapResourceReferenceBuilder(configMapReference); _visitables.get("configMapReference").add(this.configMapReference);} return (A) this;
    }

    public Boolean hasConfigMapReference(){
            return this.configMapReference != null;
    }

    public A withNewConfigMapReference(String lastUpdateTime,String name,String namespace,String resourceVersion,String uid){
            return (A)withConfigMapReference(new ConfigMapResourceReference(lastUpdateTime, name, namespace, resourceVersion, uid));
    }

    public CatalogSourceStatusFluent.ConfigMapReferenceNested<A> withNewConfigMapReference(){
            return new ConfigMapReferenceNestedImpl();
    }

    public CatalogSourceStatusFluent.ConfigMapReferenceNested<A> withNewConfigMapReferenceLike(ConfigMapResourceReference item){
            return new ConfigMapReferenceNestedImpl(item);
    }

    public CatalogSourceStatusFluent.ConfigMapReferenceNested<A> editConfigMapReference(){
            return withNewConfigMapReferenceLike(getConfigMapReference());
    }

    public CatalogSourceStatusFluent.ConfigMapReferenceNested<A> editOrNewConfigMapReference(){
            return withNewConfigMapReferenceLike(getConfigMapReference() != null ? getConfigMapReference(): new ConfigMapResourceReferenceBuilder().build());
    }

    public CatalogSourceStatusFluent.ConfigMapReferenceNested<A> editOrNewConfigMapReferenceLike(ConfigMapResourceReference item){
            return withNewConfigMapReferenceLike(getConfigMapReference() != null ? getConfigMapReference(): item);
    }

    
/**
 * This method has been deprecated, please use method buildConnectionState instead.
 * @return The buildable object.
 */
@Deprecated public GRPCConnectionState getConnectionState(){
            return this.connectionState!=null?this.connectionState.build():null;
    }

    public GRPCConnectionState buildConnectionState(){
            return this.connectionState!=null?this.connectionState.build():null;
    }

    public A withConnectionState(GRPCConnectionState connectionState){
            _visitables.get("connectionState").remove(this.connectionState);
            if (connectionState!=null){ this.connectionState= new GRPCConnectionStateBuilder(connectionState); _visitables.get("connectionState").add(this.connectionState);} return (A) this;
    }

    public Boolean hasConnectionState(){
            return this.connectionState != null;
    }

    public A withNewConnectionState(String address,String lastConnect,String lastObservedState){
            return (A)withConnectionState(new GRPCConnectionState(address, lastConnect, lastObservedState));
    }

    public CatalogSourceStatusFluent.ConnectionStateNested<A> withNewConnectionState(){
            return new ConnectionStateNestedImpl();
    }

    public CatalogSourceStatusFluent.ConnectionStateNested<A> withNewConnectionStateLike(GRPCConnectionState item){
            return new ConnectionStateNestedImpl(item);
    }

    public CatalogSourceStatusFluent.ConnectionStateNested<A> editConnectionState(){
            return withNewConnectionStateLike(getConnectionState());
    }

    public CatalogSourceStatusFluent.ConnectionStateNested<A> editOrNewConnectionState(){
            return withNewConnectionStateLike(getConnectionState() != null ? getConnectionState(): new GRPCConnectionStateBuilder().build());
    }

    public CatalogSourceStatusFluent.ConnectionStateNested<A> editOrNewConnectionStateLike(GRPCConnectionState item){
            return withNewConnectionStateLike(getConnectionState() != null ? getConnectionState(): item);
    }

    public String getLatestImageRegistryPoll(){
            return this.latestImageRegistryPoll;
    }

    public A withLatestImageRegistryPoll(String latestImageRegistryPoll){
            this.latestImageRegistryPoll=latestImageRegistryPoll; return (A) this;
    }

    public Boolean hasLatestImageRegistryPoll(){
            return this.latestImageRegistryPoll != null;
    }

    public A withNewLatestImageRegistryPoll(String arg1){
            return (A)withLatestImageRegistryPoll(new String(arg1));
    }

    public A withNewLatestImageRegistryPoll(StringBuilder arg1){
            return (A)withLatestImageRegistryPoll(new String(arg1));
    }

    public A withNewLatestImageRegistryPoll(StringBuffer arg1){
            return (A)withLatestImageRegistryPoll(new String(arg1));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason != null;
    }

    public A withNewReason(String arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1){
            return (A)withReason(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRegistryService instead.
 * @return The buildable object.
 */
@Deprecated public RegistryServiceStatus getRegistryService(){
            return this.registryService!=null?this.registryService.build():null;
    }

    public RegistryServiceStatus buildRegistryService(){
            return this.registryService!=null?this.registryService.build():null;
    }

    public A withRegistryService(RegistryServiceStatus registryService){
            _visitables.get("registryService").remove(this.registryService);
            if (registryService!=null){ this.registryService= new RegistryServiceStatusBuilder(registryService); _visitables.get("registryService").add(this.registryService);} return (A) this;
    }

    public Boolean hasRegistryService(){
            return this.registryService != null;
    }

    public A withNewRegistryService(String createdAt,String port,String protocol,String serviceName,String serviceNamespace){
            return (A)withRegistryService(new RegistryServiceStatus(createdAt, port, protocol, serviceName, serviceNamespace));
    }

    public CatalogSourceStatusFluent.RegistryServiceNested<A> withNewRegistryService(){
            return new RegistryServiceNestedImpl();
    }

    public CatalogSourceStatusFluent.RegistryServiceNested<A> withNewRegistryServiceLike(RegistryServiceStatus item){
            return new RegistryServiceNestedImpl(item);
    }

    public CatalogSourceStatusFluent.RegistryServiceNested<A> editRegistryService(){
            return withNewRegistryServiceLike(getRegistryService());
    }

    public CatalogSourceStatusFluent.RegistryServiceNested<A> editOrNewRegistryService(){
            return withNewRegistryServiceLike(getRegistryService() != null ? getRegistryService(): new RegistryServiceStatusBuilder().build());
    }

    public CatalogSourceStatusFluent.RegistryServiceNested<A> editOrNewRegistryServiceLike(RegistryServiceStatus item){
            return withNewRegistryServiceLike(getRegistryService() != null ? getRegistryService(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            CatalogSourceStatusFluentImpl that = (CatalogSourceStatusFluentImpl) o;
            if (configMapReference != null ? !configMapReference.equals(that.configMapReference) :that.configMapReference != null) return false;
            if (connectionState != null ? !connectionState.equals(that.connectionState) :that.connectionState != null) return false;
            if (latestImageRegistryPoll != null ? !latestImageRegistryPoll.equals(that.latestImageRegistryPoll) :that.latestImageRegistryPoll != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (registryService != null ? !registryService.equals(that.registryService) :that.registryService != null) return false;
            return true;
    }


    public class ConfigMapReferenceNestedImpl<N> extends ConfigMapResourceReferenceFluentImpl<CatalogSourceStatusFluent.ConfigMapReferenceNested<N>> implements CatalogSourceStatusFluent.ConfigMapReferenceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ConfigMapResourceReferenceBuilder builder;
    
            ConfigMapReferenceNestedImpl(ConfigMapResourceReference item){
                    this.builder = new ConfigMapResourceReferenceBuilder(this, item);
            }
            ConfigMapReferenceNestedImpl(){
                    this.builder = new ConfigMapResourceReferenceBuilder(this);
            }
    
    public N and(){
            return (N) CatalogSourceStatusFluentImpl.this.withConfigMapReference(builder.build());
    }
    public N endConfigMapReference(){
            return and();
    }

}
    public class ConnectionStateNestedImpl<N> extends GRPCConnectionStateFluentImpl<CatalogSourceStatusFluent.ConnectionStateNested<N>> implements CatalogSourceStatusFluent.ConnectionStateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GRPCConnectionStateBuilder builder;
    
            ConnectionStateNestedImpl(GRPCConnectionState item){
                    this.builder = new GRPCConnectionStateBuilder(this, item);
            }
            ConnectionStateNestedImpl(){
                    this.builder = new GRPCConnectionStateBuilder(this);
            }
    
    public N and(){
            return (N) CatalogSourceStatusFluentImpl.this.withConnectionState(builder.build());
    }
    public N endConnectionState(){
            return and();
    }

}
    public class RegistryServiceNestedImpl<N> extends RegistryServiceStatusFluentImpl<CatalogSourceStatusFluent.RegistryServiceNested<N>> implements CatalogSourceStatusFluent.RegistryServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RegistryServiceStatusBuilder builder;
    
            RegistryServiceNestedImpl(RegistryServiceStatus item){
                    this.builder = new RegistryServiceStatusBuilder(this, item);
            }
            RegistryServiceNestedImpl(){
                    this.builder = new RegistryServiceStatusBuilder(this);
            }
    
    public N and(){
            return (N) CatalogSourceStatusFluentImpl.this.withRegistryService(builder.build());
    }
    public N endRegistryService(){
            return and();
    }

}


}
