package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class StrategyDeploymentPermissionsFluentImpl<A extends StrategyDeploymentPermissionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StrategyDeploymentPermissionsFluent<A>{

    private List<PolicyRuleBuilder> rules =  new ArrayList<PolicyRuleBuilder>();
    private String serviceAccountName;

    public StrategyDeploymentPermissionsFluentImpl(){
    }
    public StrategyDeploymentPermissionsFluentImpl(StrategyDeploymentPermissions instance){
            this.withRules(instance.getRules()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
    }

    public A addToRules(int index,PolicyRule item){
            if (this.rules == null) {this.rules = new ArrayList<PolicyRuleBuilder>();}
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,PolicyRule item){
            if (this.rules == null) {this.rules = new ArrayList<PolicyRuleBuilder>();}
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
            if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
             return (A)this;
    }

    public A addToRules(PolicyRule... items){
            if (this.rules == null) {this.rules = new ArrayList<PolicyRuleBuilder>();}
            for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<PolicyRule> items){
            if (this.rules == null) {this.rules = new ArrayList<PolicyRuleBuilder>();}
            for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(PolicyRule... items){
            for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<PolicyRule> items){
            for (PolicyRule item : items) {PolicyRuleBuilder builder = new PolicyRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(io.fabric8.kubernetes.api.builder.Predicate<PolicyRuleBuilder> predicate){
            if (rules == null) return (A) this;
            final Iterator<PolicyRuleBuilder> each = rules.iterator();
            final List visitables = _visitables.get("rules");
            while (each.hasNext()) {
              PolicyRuleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<PolicyRule> getRules(){
            return build(rules);
    }

    public List<PolicyRule> buildRules(){
            return build(rules);
    }

    public PolicyRule buildRule(int index){
            return this.rules.get(index).build();
    }

    public PolicyRule buildFirstRule(){
            return this.rules.get(0).build();
    }

    public PolicyRule buildLastRule(){
            return this.rules.get(rules.size() - 1).build();
    }

    public PolicyRule buildMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<PolicyRuleBuilder> predicate){
            for (PolicyRuleBuilder item: rules) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<PolicyRuleBuilder> predicate){
            for (PolicyRuleBuilder item: rules) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRules(List<PolicyRule> rules){
            if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
            if (rules != null) {this.rules = new ArrayList<PolicyRuleBuilder>(); for (PolicyRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(PolicyRule... rules){
            if (this.rules != null) {this.rules.clear();}
            if (rules != null) {for (PolicyRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules(){
            return rules != null && !rules.isEmpty();
    }

    public StrategyDeploymentPermissionsFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public StrategyDeploymentPermissionsFluent.RulesNested<A> addNewRuleLike(PolicyRule item){
            return new RulesNestedImpl(-1, item);
    }

    public StrategyDeploymentPermissionsFluent.RulesNested<A> setNewRuleLike(int index,PolicyRule item){
            return new RulesNestedImpl(index, item);
    }

    public StrategyDeploymentPermissionsFluent.RulesNested<A> editRule(int index){
            if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
            return setNewRuleLike(index, buildRule(index));
    }

    public StrategyDeploymentPermissionsFluent.RulesNested<A> editFirstRule(){
            if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
            return setNewRuleLike(0, buildRule(0));
    }

    public StrategyDeploymentPermissionsFluent.RulesNested<A> editLastRule(){
            int index = rules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
            return setNewRuleLike(index, buildRule(index));
    }

    public StrategyDeploymentPermissionsFluent.RulesNested<A> editMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<PolicyRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<rules.size();i++) { 
            if (predicate.apply(rules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
            return setNewRuleLike(index, buildRule(index));
    }

    public String getServiceAccountName(){
            return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName){
            this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName(){
            return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(String arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuilder arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1){
            return (A)withServiceAccountName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            StrategyDeploymentPermissionsFluentImpl that = (StrategyDeploymentPermissionsFluentImpl) o;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
            return true;
    }


    public class RulesNestedImpl<N> extends PolicyRuleFluentImpl<StrategyDeploymentPermissionsFluent.RulesNested<N>> implements StrategyDeploymentPermissionsFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PolicyRuleBuilder builder;
        private final int index;
    
            RulesNestedImpl(int index,PolicyRule item){
                    this.index = index;
                    this.builder = new PolicyRuleBuilder(this, item);
            }
            RulesNestedImpl(){
                    this.index = -1;
                    this.builder = new PolicyRuleBuilder(this);
            }
    
    public N and(){
            return (N) StrategyDeploymentPermissionsFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule(){
            return and();
    }

}


}
