package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RegistryServiceStatusBuilder extends RegistryServiceStatusFluentImpl<RegistryServiceStatusBuilder> implements VisitableBuilder<RegistryServiceStatus,RegistryServiceStatusBuilder>{

    RegistryServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public RegistryServiceStatusBuilder(){
            this(true);
    }
    public RegistryServiceStatusBuilder(Boolean validationEnabled){
            this(new RegistryServiceStatus(), validationEnabled);
    }
    public RegistryServiceStatusBuilder(RegistryServiceStatusFluent<?> fluent){
            this(fluent, true);
    }
    public RegistryServiceStatusBuilder(RegistryServiceStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RegistryServiceStatus(), validationEnabled);
    }
    public RegistryServiceStatusBuilder(RegistryServiceStatusFluent<?> fluent,RegistryServiceStatus instance){
            this(fluent, instance, true);
    }
    public RegistryServiceStatusBuilder(RegistryServiceStatusFluent<?> fluent,RegistryServiceStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCreatedAt(instance.getCreatedAt()); 
            fluent.withPort(instance.getPort()); 
            fluent.withProtocol(instance.getProtocol()); 
            fluent.withServiceName(instance.getServiceName()); 
            fluent.withServiceNamespace(instance.getServiceNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public RegistryServiceStatusBuilder(RegistryServiceStatus instance){
            this(instance,true);
    }
    public RegistryServiceStatusBuilder(RegistryServiceStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCreatedAt(instance.getCreatedAt()); 
            this.withPort(instance.getPort()); 
            this.withProtocol(instance.getProtocol()); 
            this.withServiceName(instance.getServiceName()); 
            this.withServiceNamespace(instance.getServiceNamespace()); 
            this.validationEnabled = validationEnabled; 
    }

    public RegistryServiceStatus build(){
            RegistryServiceStatus buildable = new RegistryServiceStatus(fluent.getCreatedAt(),fluent.getPort(),fluent.getProtocol(),fluent.getServiceName(),fluent.getServiceNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RegistryServiceStatusBuilder that = (RegistryServiceStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
