package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceDescriptionBuilder extends APIServiceDescriptionFluentImpl<APIServiceDescriptionBuilder> implements VisitableBuilder<APIServiceDescription,APIServiceDescriptionBuilder>{

    APIServiceDescriptionFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceDescriptionBuilder(){
            this(true);
    }
    public APIServiceDescriptionBuilder(Boolean validationEnabled){
            this(new APIServiceDescription(), validationEnabled);
    }
    public APIServiceDescriptionBuilder(APIServiceDescriptionFluent<?> fluent){
            this(fluent, true);
    }
    public APIServiceDescriptionBuilder(APIServiceDescriptionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new APIServiceDescription(), validationEnabled);
    }
    public APIServiceDescriptionBuilder(APIServiceDescriptionFluent<?> fluent,APIServiceDescription instance){
            this(fluent, instance, true);
    }
    public APIServiceDescriptionBuilder(APIServiceDescriptionFluent<?> fluent,APIServiceDescription instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withActionDescriptors(instance.getActionDescriptors()); 
            fluent.withContainerPort(instance.getContainerPort()); 
            fluent.withDeploymentName(instance.getDeploymentName()); 
            fluent.withDescription(instance.getDescription()); 
            fluent.withDisplayName(instance.getDisplayName()); 
            fluent.withGroup(instance.getGroup()); 
            fluent.withKind(instance.getKind()); 
            fluent.withName(instance.getName()); 
            fluent.withResources(instance.getResources()); 
            fluent.withSpecDescriptors(instance.getSpecDescriptors()); 
            fluent.withStatusDescriptors(instance.getStatusDescriptors()); 
            fluent.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }
    public APIServiceDescriptionBuilder(APIServiceDescription instance){
            this(instance,true);
    }
    public APIServiceDescriptionBuilder(APIServiceDescription instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withActionDescriptors(instance.getActionDescriptors()); 
            this.withContainerPort(instance.getContainerPort()); 
            this.withDeploymentName(instance.getDeploymentName()); 
            this.withDescription(instance.getDescription()); 
            this.withDisplayName(instance.getDisplayName()); 
            this.withGroup(instance.getGroup()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withResources(instance.getResources()); 
            this.withSpecDescriptors(instance.getSpecDescriptors()); 
            this.withStatusDescriptors(instance.getStatusDescriptors()); 
            this.withVersion(instance.getVersion()); 
            this.validationEnabled = validationEnabled; 
    }

    public APIServiceDescription build(){
            APIServiceDescription buildable = new APIServiceDescription(fluent.getActionDescriptors(),fluent.getContainerPort(),fluent.getDeploymentName(),fluent.getDescription(),fluent.getDisplayName(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getResources(),fluent.getSpecDescriptors(),fluent.getStatusDescriptors(),fluent.getVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            APIServiceDescriptionBuilder that = (APIServiceDescriptionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
