package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServiceCASpecBuilder extends ServiceCASpecFluent<ServiceCASpecBuilder> implements VisitableBuilder<ServiceCASpec,ServiceCASpecBuilder>{
  public ServiceCASpecBuilder() {
    this(new ServiceCASpec());
  }
  
  public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent) {
    this(fluent, new ServiceCASpec());
  }
  
  public ServiceCASpecBuilder(ServiceCASpecFluent<?> fluent,ServiceCASpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServiceCASpecBuilder(ServiceCASpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServiceCASpecFluent<?> fluent;
  
  public ServiceCASpec build() {
    ServiceCASpec buildable = new ServiceCASpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}