package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KubeAPIServerSpecBuilder extends KubeAPIServerSpecFluent<KubeAPIServerSpecBuilder> implements VisitableBuilder<KubeAPIServerSpec,KubeAPIServerSpecBuilder>{
  public KubeAPIServerSpecBuilder() {
    this(new KubeAPIServerSpec());
  }
  
  public KubeAPIServerSpecBuilder(KubeAPIServerSpecFluent<?> fluent) {
    this(fluent, new KubeAPIServerSpec());
  }
  
  public KubeAPIServerSpecBuilder(KubeAPIServerSpecFluent<?> fluent,KubeAPIServerSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KubeAPIServerSpecBuilder(KubeAPIServerSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KubeAPIServerSpecFluent<?> fluent;
  
  public KubeAPIServerSpec build() {
    KubeAPIServerSpec buildable = new KubeAPIServerSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}