package io.fabric8.openshift.api.model.operator.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CSIDriverConfigSpecFluent<A extends CSIDriverConfigSpecFluent<A>> extends BaseFluent<A>{
  public CSIDriverConfigSpecFluent() {
  }
  
  public CSIDriverConfigSpecFluent(CSIDriverConfigSpec instance) {
    this.copyInstance(instance);
  }
  private AWSCSIDriverConfigSpecBuilder aws;
  private AzureCSIDriverConfigSpecBuilder azure;
  private String driverType;
  private GCPCSIDriverConfigSpecBuilder gcp;
  private VSphereCSIDriverConfigSpecBuilder vSphere;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CSIDriverConfigSpec instance) {
    instance = (instance != null ? instance : new CSIDriverConfigSpec());
    if (instance != null) {
          this.withAws(instance.getAws());
          this.withAzure(instance.getAzure());
          this.withDriverType(instance.getDriverType());
          this.withGcp(instance.getGcp());
          this.withVSphere(instance.getVSphere());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public AWSCSIDriverConfigSpec buildAws() {
    return this.aws != null ? this.aws.build() : null;
  }
  
  public A withAws(AWSCSIDriverConfigSpec aws) {
    this._visitables.remove("aws");
    if (aws != null) {
        this.aws = new AWSCSIDriverConfigSpecBuilder(aws);
        this._visitables.get("aws").add(this.aws);
    } else {
        this.aws = null;
        this._visitables.get("aws").remove(this.aws);
    }
    return (A) this;
  }
  
  public boolean hasAws() {
    return this.aws != null;
  }
  
  public A withNewAws(String kmsKeyARN) {
    return (A)withAws(new AWSCSIDriverConfigSpec(kmsKeyARN));
  }
  
  public AwsNested<A> withNewAws() {
    return new AwsNested(null);
  }
  
  public AwsNested<A> withNewAwsLike(AWSCSIDriverConfigSpec item) {
    return new AwsNested(item);
  }
  
  public AwsNested<A> editAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(null));
  }
  
  public AwsNested<A> editOrNewAws() {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(new AWSCSIDriverConfigSpecBuilder().build()));
  }
  
  public AwsNested<A> editOrNewAwsLike(AWSCSIDriverConfigSpec item) {
    return withNewAwsLike(java.util.Optional.ofNullable(buildAws()).orElse(item));
  }
  
  public AzureCSIDriverConfigSpec buildAzure() {
    return this.azure != null ? this.azure.build() : null;
  }
  
  public A withAzure(AzureCSIDriverConfigSpec azure) {
    this._visitables.remove("azure");
    if (azure != null) {
        this.azure = new AzureCSIDriverConfigSpecBuilder(azure);
        this._visitables.get("azure").add(this.azure);
    } else {
        this.azure = null;
        this._visitables.get("azure").remove(this.azure);
    }
    return (A) this;
  }
  
  public boolean hasAzure() {
    return this.azure != null;
  }
  
  public AzureNested<A> withNewAzure() {
    return new AzureNested(null);
  }
  
  public AzureNested<A> withNewAzureLike(AzureCSIDriverConfigSpec item) {
    return new AzureNested(item);
  }
  
  public AzureNested<A> editAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(null));
  }
  
  public AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(new AzureCSIDriverConfigSpecBuilder().build()));
  }
  
  public AzureNested<A> editOrNewAzureLike(AzureCSIDriverConfigSpec item) {
    return withNewAzureLike(java.util.Optional.ofNullable(buildAzure()).orElse(item));
  }
  
  public String getDriverType() {
    return this.driverType;
  }
  
  public A withDriverType(String driverType) {
    this.driverType = driverType;
    return (A) this;
  }
  
  public boolean hasDriverType() {
    return this.driverType != null;
  }
  
  public GCPCSIDriverConfigSpec buildGcp() {
    return this.gcp != null ? this.gcp.build() : null;
  }
  
  public A withGcp(GCPCSIDriverConfigSpec gcp) {
    this._visitables.remove("gcp");
    if (gcp != null) {
        this.gcp = new GCPCSIDriverConfigSpecBuilder(gcp);
        this._visitables.get("gcp").add(this.gcp);
    } else {
        this.gcp = null;
        this._visitables.get("gcp").remove(this.gcp);
    }
    return (A) this;
  }
  
  public boolean hasGcp() {
    return this.gcp != null;
  }
  
  public GcpNested<A> withNewGcp() {
    return new GcpNested(null);
  }
  
  public GcpNested<A> withNewGcpLike(GCPCSIDriverConfigSpec item) {
    return new GcpNested(item);
  }
  
  public GcpNested<A> editGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(null));
  }
  
  public GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(new GCPCSIDriverConfigSpecBuilder().build()));
  }
  
  public GcpNested<A> editOrNewGcpLike(GCPCSIDriverConfigSpec item) {
    return withNewGcpLike(java.util.Optional.ofNullable(buildGcp()).orElse(item));
  }
  
  public VSphereCSIDriverConfigSpec buildVSphere() {
    return this.vSphere != null ? this.vSphere.build() : null;
  }
  
  public A withVSphere(VSphereCSIDriverConfigSpec vSphere) {
    this._visitables.remove("vSphere");
    if (vSphere != null) {
        this.vSphere = new VSphereCSIDriverConfigSpecBuilder(vSphere);
        this._visitables.get("vSphere").add(this.vSphere);
    } else {
        this.vSphere = null;
        this._visitables.get("vSphere").remove(this.vSphere);
    }
    return (A) this;
  }
  
  public boolean hasVSphere() {
    return this.vSphere != null;
  }
  
  public VSphereNested<A> withNewVSphere() {
    return new VSphereNested(null);
  }
  
  public VSphereNested<A> withNewVSphereLike(VSphereCSIDriverConfigSpec item) {
    return new VSphereNested(item);
  }
  
  public VSphereNested<A> editVSphere() {
    return withNewVSphereLike(java.util.Optional.ofNullable(buildVSphere()).orElse(null));
  }
  
  public VSphereNested<A> editOrNewVSphere() {
    return withNewVSphereLike(java.util.Optional.ofNullable(buildVSphere()).orElse(new VSphereCSIDriverConfigSpecBuilder().build()));
  }
  
  public VSphereNested<A> editOrNewVSphereLike(VSphereCSIDriverConfigSpec item) {
    return withNewVSphereLike(java.util.Optional.ofNullable(buildVSphere()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CSIDriverConfigSpecFluent that = (CSIDriverConfigSpecFluent) o;
    if (!java.util.Objects.equals(aws, that.aws)) return false;
    if (!java.util.Objects.equals(azure, that.azure)) return false;
    if (!java.util.Objects.equals(driverType, that.driverType)) return false;
    if (!java.util.Objects.equals(gcp, that.gcp)) return false;
    if (!java.util.Objects.equals(vSphere, that.vSphere)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  driverType,  gcp,  vSphere,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (driverType != null) { sb.append("driverType:"); sb.append(driverType + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (vSphere != null) { sb.append("vSphere:"); sb.append(vSphere + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class AwsNested<N> extends AWSCSIDriverConfigSpecFluent<AwsNested<N>> implements Nested<N>{
    AwsNested(AWSCSIDriverConfigSpec item) {
      this.builder = new AWSCSIDriverConfigSpecBuilder(this, item);
    }
    AWSCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) CSIDriverConfigSpecFluent.this.withAws(builder.build());
    }
    
    public N endAws() {
      return and();
    }
    
  
  }
  public class AzureNested<N> extends AzureCSIDriverConfigSpecFluent<AzureNested<N>> implements Nested<N>{
    AzureNested(AzureCSIDriverConfigSpec item) {
      this.builder = new AzureCSIDriverConfigSpecBuilder(this, item);
    }
    AzureCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) CSIDriverConfigSpecFluent.this.withAzure(builder.build());
    }
    
    public N endAzure() {
      return and();
    }
    
  
  }
  public class GcpNested<N> extends GCPCSIDriverConfigSpecFluent<GcpNested<N>> implements Nested<N>{
    GcpNested(GCPCSIDriverConfigSpec item) {
      this.builder = new GCPCSIDriverConfigSpecBuilder(this, item);
    }
    GCPCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) CSIDriverConfigSpecFluent.this.withGcp(builder.build());
    }
    
    public N endGcp() {
      return and();
    }
    
  
  }
  public class VSphereNested<N> extends VSphereCSIDriverConfigSpecFluent<VSphereNested<N>> implements Nested<N>{
    VSphereNested(VSphereCSIDriverConfigSpec item) {
      this.builder = new VSphereCSIDriverConfigSpecBuilder(this, item);
    }
    VSphereCSIDriverConfigSpecBuilder builder;
    
    public N and() {
      return (N) CSIDriverConfigSpecFluent.this.withVSphere(builder.build());
    }
    
    public N endVSphere() {
      return and();
    }
    
  
  }

}