package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AWSLoadBalancerParametersBuilder extends AWSLoadBalancerParametersFluent<AWSLoadBalancerParametersBuilder> implements VisitableBuilder<AWSLoadBalancerParameters,AWSLoadBalancerParametersBuilder>{
  public AWSLoadBalancerParametersBuilder() {
    this(new AWSLoadBalancerParameters());
  }
  
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent) {
    this(fluent, new AWSLoadBalancerParameters());
  }
  
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParametersFluent<?> fluent,AWSLoadBalancerParameters instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AWSLoadBalancerParametersBuilder(AWSLoadBalancerParameters instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AWSLoadBalancerParametersFluent<?> fluent;
  
  public AWSLoadBalancerParameters build() {
    AWSLoadBalancerParameters buildable = new AWSLoadBalancerParameters(fluent.buildClassicLoadBalancer(),fluent.buildNetworkLoadBalancer(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}