package io.fabric8.openshift.api.model.operator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageContentSourcePolicyListBuilder extends ImageContentSourcePolicyListFluent<ImageContentSourcePolicyListBuilder> implements VisitableBuilder<ImageContentSourcePolicyList,ImageContentSourcePolicyListBuilder>{
  public ImageContentSourcePolicyListBuilder() {
    this(false);
  }
  public ImageContentSourcePolicyListBuilder(Boolean validationEnabled) {
    this(new ImageContentSourcePolicyList(), validationEnabled);
  }
  public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageContentSourcePolicyList(), validationEnabled);
  }
  public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyListFluent<?> fluent,ImageContentSourcePolicyList instance) {
    this(fluent, instance, false);
  }
  public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyListFluent<?> fluent,ImageContentSourcePolicyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageContentSourcePolicyList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyList instance) {
    this(instance,false);
  }
  public ImageContentSourcePolicyListBuilder(ImageContentSourcePolicyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageContentSourcePolicyList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageContentSourcePolicyListFluent<?> fluent;
  Boolean validationEnabled;
  public ImageContentSourcePolicyList build() {
    ImageContentSourcePolicyList buildable = new ImageContentSourcePolicyList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}