package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VSphereCSIDriverConfigSpecBuilder extends VSphereCSIDriverConfigSpecFluent<VSphereCSIDriverConfigSpecBuilder> implements VisitableBuilder<VSphereCSIDriverConfigSpec,VSphereCSIDriverConfigSpecBuilder>{
  public VSphereCSIDriverConfigSpecBuilder() {
    this(false);
  }
  public VSphereCSIDriverConfigSpecBuilder(Boolean validationEnabled) {
    this(new VSphereCSIDriverConfigSpec(), validationEnabled);
  }
  public VSphereCSIDriverConfigSpecBuilder(VSphereCSIDriverConfigSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public VSphereCSIDriverConfigSpecBuilder(VSphereCSIDriverConfigSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VSphereCSIDriverConfigSpec(), validationEnabled);
  }
  public VSphereCSIDriverConfigSpecBuilder(VSphereCSIDriverConfigSpecFluent<?> fluent,VSphereCSIDriverConfigSpec instance) {
    this(fluent, instance, false);
  }
  public VSphereCSIDriverConfigSpecBuilder(VSphereCSIDriverConfigSpecFluent<?> fluent,VSphereCSIDriverConfigSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VSphereCSIDriverConfigSpec());

    if (instance != null) {
      fluent.withTopologyCategories(instance.getTopologyCategories());
      fluent.withTopologyCategories(instance.getTopologyCategories());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VSphereCSIDriverConfigSpecBuilder(VSphereCSIDriverConfigSpec instance) {
    this(instance,false);
  }
  public VSphereCSIDriverConfigSpecBuilder(VSphereCSIDriverConfigSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VSphereCSIDriverConfigSpec());

    if (instance != null) {
      this.withTopologyCategories(instance.getTopologyCategories());
      this.withTopologyCategories(instance.getTopologyCategories());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VSphereCSIDriverConfigSpecFluent<?> fluent;
  Boolean validationEnabled;
  public VSphereCSIDriverConfigSpec build() {
    VSphereCSIDriverConfigSpec buildable = new VSphereCSIDriverConfigSpec(fluent.getTopologyCategories());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}