package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StaticIPAMRoutesBuilder extends StaticIPAMRoutesFluent<StaticIPAMRoutesBuilder> implements VisitableBuilder<StaticIPAMRoutes,StaticIPAMRoutesBuilder>{
  public StaticIPAMRoutesBuilder() {
    this(false);
  }
  public StaticIPAMRoutesBuilder(Boolean validationEnabled) {
    this(new StaticIPAMRoutes(), validationEnabled);
  }
  public StaticIPAMRoutesBuilder(StaticIPAMRoutesFluent<?> fluent) {
    this(fluent, false);
  }
  public StaticIPAMRoutesBuilder(StaticIPAMRoutesFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StaticIPAMRoutes(), validationEnabled);
  }
  public StaticIPAMRoutesBuilder(StaticIPAMRoutesFluent<?> fluent,StaticIPAMRoutes instance) {
    this(fluent, instance, false);
  }
  public StaticIPAMRoutesBuilder(StaticIPAMRoutesFluent<?> fluent,StaticIPAMRoutes instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StaticIPAMRoutes());

    if (instance != null) {
      fluent.withDestination(instance.getDestination());
      fluent.withGateway(instance.getGateway());
      fluent.withDestination(instance.getDestination());
      fluent.withGateway(instance.getGateway());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StaticIPAMRoutesBuilder(StaticIPAMRoutes instance) {
    this(instance,false);
  }
  public StaticIPAMRoutesBuilder(StaticIPAMRoutes instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StaticIPAMRoutes());

    if (instance != null) {
      this.withDestination(instance.getDestination());
      this.withGateway(instance.getGateway());
      this.withDestination(instance.getDestination());
      this.withGateway(instance.getGateway());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StaticIPAMRoutesFluent<?> fluent;
  Boolean validationEnabled;
  public StaticIPAMRoutes build() {
    StaticIPAMRoutes buildable = new StaticIPAMRoutes(fluent.getDestination(),fluent.getGateway());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}