package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCatalogAPIServerSpecBuilder extends ServiceCatalogAPIServerSpecFluent<ServiceCatalogAPIServerSpecBuilder> implements VisitableBuilder<ServiceCatalogAPIServerSpec,ServiceCatalogAPIServerSpecBuilder>{
  public ServiceCatalogAPIServerSpecBuilder() {
    this(false);
  }
  public ServiceCatalogAPIServerSpecBuilder(Boolean validationEnabled) {
    this(new ServiceCatalogAPIServerSpec(), validationEnabled);
  }
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCatalogAPIServerSpec(), validationEnabled);
  }
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent,ServiceCatalogAPIServerSpec instance) {
    this(fluent, instance, false);
  }
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpecFluent<?> fluent,ServiceCatalogAPIServerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceCatalogAPIServerSpec());

    if (instance != null) {
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpec instance) {
    this(instance,false);
  }
  public ServiceCatalogAPIServerSpecBuilder(ServiceCatalogAPIServerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceCatalogAPIServerSpec());

    if (instance != null) {
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceCatalogAPIServerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCatalogAPIServerSpec build() {
    ServiceCatalogAPIServerSpec buildable = new ServiceCatalogAPIServerSpec(fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}