package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceCAStatusBuilder extends ServiceCAStatusFluent<ServiceCAStatusBuilder> implements VisitableBuilder<ServiceCAStatus,ServiceCAStatusBuilder>{
  public ServiceCAStatusBuilder() {
    this(false);
  }
  public ServiceCAStatusBuilder(Boolean validationEnabled) {
    this(new ServiceCAStatus(), validationEnabled);
  }
  public ServiceCAStatusBuilder(ServiceCAStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceCAStatusBuilder(ServiceCAStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceCAStatus(), validationEnabled);
  }
  public ServiceCAStatusBuilder(ServiceCAStatusFluent<?> fluent,ServiceCAStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceCAStatusBuilder(ServiceCAStatusFluent<?> fluent,ServiceCAStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceCAStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceCAStatusBuilder(ServiceCAStatus instance) {
    this(instance,false);
  }
  public ServiceCAStatusBuilder(ServiceCAStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceCAStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceCAStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceCAStatus build() {
    ServiceCAStatus buildable = new ServiceCAStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}