package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountIssuerStatusBuilder extends ServiceAccountIssuerStatusFluent<ServiceAccountIssuerStatusBuilder> implements VisitableBuilder<ServiceAccountIssuerStatus,ServiceAccountIssuerStatusBuilder>{
  public ServiceAccountIssuerStatusBuilder() {
    this(false);
  }
  public ServiceAccountIssuerStatusBuilder(Boolean validationEnabled) {
    this(new ServiceAccountIssuerStatus(), validationEnabled);
  }
  public ServiceAccountIssuerStatusBuilder(ServiceAccountIssuerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountIssuerStatusBuilder(ServiceAccountIssuerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceAccountIssuerStatus(), validationEnabled);
  }
  public ServiceAccountIssuerStatusBuilder(ServiceAccountIssuerStatusFluent<?> fluent,ServiceAccountIssuerStatus instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountIssuerStatusBuilder(ServiceAccountIssuerStatusFluent<?> fluent,ServiceAccountIssuerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceAccountIssuerStatus());

    if (instance != null) {
      fluent.withExpirationTime(instance.getExpirationTime());
      fluent.withName(instance.getName());
      fluent.withExpirationTime(instance.getExpirationTime());
      fluent.withName(instance.getName());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountIssuerStatusBuilder(ServiceAccountIssuerStatus instance) {
    this(instance,false);
  }
  public ServiceAccountIssuerStatusBuilder(ServiceAccountIssuerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceAccountIssuerStatus());

    if (instance != null) {
      this.withExpirationTime(instance.getExpirationTime());
      this.withName(instance.getName());
      this.withExpirationTime(instance.getExpirationTime());
      this.withName(instance.getName());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceAccountIssuerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceAccountIssuerStatus build() {
    ServiceAccountIssuerStatus buildable = new ServiceAccountIssuerStatus(fluent.getExpirationTime(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}