package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceAttributesAccessReviewBuilder extends ResourceAttributesAccessReviewFluent<ResourceAttributesAccessReviewBuilder> implements VisitableBuilder<ResourceAttributesAccessReview,ResourceAttributesAccessReviewBuilder>{
  public ResourceAttributesAccessReviewBuilder() {
    this(false);
  }
  public ResourceAttributesAccessReviewBuilder(Boolean validationEnabled) {
    this(new ResourceAttributesAccessReview(), validationEnabled);
  }
  public ResourceAttributesAccessReviewBuilder(ResourceAttributesAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceAttributesAccessReviewBuilder(ResourceAttributesAccessReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceAttributesAccessReview(), validationEnabled);
  }
  public ResourceAttributesAccessReviewBuilder(ResourceAttributesAccessReviewFluent<?> fluent,ResourceAttributesAccessReview instance) {
    this(fluent, instance, false);
  }
  public ResourceAttributesAccessReviewBuilder(ResourceAttributesAccessReviewFluent<?> fluent,ResourceAttributesAccessReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceAttributesAccessReview());

    if (instance != null) {
      fluent.withMissing(instance.getMissing());
      fluent.withRequired(instance.getRequired());
      fluent.withMissing(instance.getMissing());
      fluent.withRequired(instance.getRequired());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceAttributesAccessReviewBuilder(ResourceAttributesAccessReview instance) {
    this(instance,false);
  }
  public ResourceAttributesAccessReviewBuilder(ResourceAttributesAccessReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceAttributesAccessReview());

    if (instance != null) {
      this.withMissing(instance.getMissing());
      this.withRequired(instance.getRequired());
      this.withMissing(instance.getMissing());
      this.withRequired(instance.getRequired());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceAttributesAccessReviewFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceAttributesAccessReview build() {
    ResourceAttributesAccessReview buildable = new ResourceAttributesAccessReview(fluent.getMissing(),fluent.getRequired());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}