package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyConfigBuilder extends ProxyConfigFluent<ProxyConfigBuilder> implements VisitableBuilder<ProxyConfig,ProxyConfigBuilder>{
  public ProxyConfigBuilder() {
    this(false);
  }
  public ProxyConfigBuilder(Boolean validationEnabled) {
    this(new ProxyConfig(), validationEnabled);
  }
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProxyConfig(), validationEnabled);
  }
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance) {
    this(fluent, instance, false);
  }
  public ProxyConfigBuilder(ProxyConfigFluent<?> fluent,ProxyConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProxyConfig());

    if (instance != null) {
      fluent.withBindAddress(instance.getBindAddress());
      fluent.withIptablesSyncPeriod(instance.getIptablesSyncPeriod());
      fluent.withProxyArguments(instance.getProxyArguments());
      fluent.withBindAddress(instance.getBindAddress());
      fluent.withIptablesSyncPeriod(instance.getIptablesSyncPeriod());
      fluent.withProxyArguments(instance.getProxyArguments());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProxyConfigBuilder(ProxyConfig instance) {
    this(instance,false);
  }
  public ProxyConfigBuilder(ProxyConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProxyConfig());

    if (instance != null) {
      this.withBindAddress(instance.getBindAddress());
      this.withIptablesSyncPeriod(instance.getIptablesSyncPeriod());
      this.withProxyArguments(instance.getProxyArguments());
      this.withBindAddress(instance.getBindAddress());
      this.withIptablesSyncPeriod(instance.getIptablesSyncPeriod());
      this.withProxyArguments(instance.getProxyArguments());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProxyConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ProxyConfig build() {
    ProxyConfig buildable = new ProxyConfig(fluent.getBindAddress(),fluent.getIptablesSyncPeriod(),fluent.getProxyArguments());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}