package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectAccessBuilder extends ProjectAccessFluent<ProjectAccessBuilder> implements VisitableBuilder<ProjectAccess,ProjectAccessBuilder>{
  public ProjectAccessBuilder() {
    this(false);
  }
  public ProjectAccessBuilder(Boolean validationEnabled) {
    this(new ProjectAccess(), validationEnabled);
  }
  public ProjectAccessBuilder(ProjectAccessFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectAccessBuilder(ProjectAccessFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProjectAccess(), validationEnabled);
  }
  public ProjectAccessBuilder(ProjectAccessFluent<?> fluent,ProjectAccess instance) {
    this(fluent, instance, false);
  }
  public ProjectAccessBuilder(ProjectAccessFluent<?> fluent,ProjectAccess instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProjectAccess());

    if (instance != null) {
      fluent.withAvailableClusterRoles(instance.getAvailableClusterRoles());
      fluent.withAvailableClusterRoles(instance.getAvailableClusterRoles());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProjectAccessBuilder(ProjectAccess instance) {
    this(instance,false);
  }
  public ProjectAccessBuilder(ProjectAccess instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProjectAccess());

    if (instance != null) {
      this.withAvailableClusterRoles(instance.getAvailableClusterRoles());
      this.withAvailableClusterRoles(instance.getAvailableClusterRoles());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProjectAccessFluent<?> fluent;
  Boolean validationEnabled;
  public ProjectAccess build() {
    ProjectAccess buildable = new ProjectAccess(fluent.getAvailableClusterRoles());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}