package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PinnedResourceReferenceBuilder extends PinnedResourceReferenceFluent<PinnedResourceReferenceBuilder> implements VisitableBuilder<PinnedResourceReference,PinnedResourceReferenceBuilder>{
  public PinnedResourceReferenceBuilder() {
    this(false);
  }
  public PinnedResourceReferenceBuilder(Boolean validationEnabled) {
    this(new PinnedResourceReference(), validationEnabled);
  }
  public PinnedResourceReferenceBuilder(PinnedResourceReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public PinnedResourceReferenceBuilder(PinnedResourceReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PinnedResourceReference(), validationEnabled);
  }
  public PinnedResourceReferenceBuilder(PinnedResourceReferenceFluent<?> fluent,PinnedResourceReference instance) {
    this(fluent, instance, false);
  }
  public PinnedResourceReferenceBuilder(PinnedResourceReferenceFluent<?> fluent,PinnedResourceReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PinnedResourceReference());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withResource(instance.getResource());
      fluent.withVersion(instance.getVersion());
      fluent.withGroup(instance.getGroup());
      fluent.withResource(instance.getResource());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PinnedResourceReferenceBuilder(PinnedResourceReference instance) {
    this(instance,false);
  }
  public PinnedResourceReferenceBuilder(PinnedResourceReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PinnedResourceReference());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withResource(instance.getResource());
      this.withVersion(instance.getVersion());
      this.withGroup(instance.getGroup());
      this.withResource(instance.getResource());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PinnedResourceReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public PinnedResourceReference build() {
    PinnedResourceReference buildable = new PinnedResourceReference(fluent.getGroup(),fluent.getResource(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}