package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenShiftAPIServerStatusBuilder extends OpenShiftAPIServerStatusFluent<OpenShiftAPIServerStatusBuilder> implements VisitableBuilder<OpenShiftAPIServerStatus,OpenShiftAPIServerStatusBuilder>{
  public OpenShiftAPIServerStatusBuilder() {
    this(false);
  }
  public OpenShiftAPIServerStatusBuilder(Boolean validationEnabled) {
    this(new OpenShiftAPIServerStatus(), validationEnabled);
  }
  public OpenShiftAPIServerStatusBuilder(OpenShiftAPIServerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenShiftAPIServerStatusBuilder(OpenShiftAPIServerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenShiftAPIServerStatus(), validationEnabled);
  }
  public OpenShiftAPIServerStatusBuilder(OpenShiftAPIServerStatusFluent<?> fluent,OpenShiftAPIServerStatus instance) {
    this(fluent, instance, false);
  }
  public OpenShiftAPIServerStatusBuilder(OpenShiftAPIServerStatusFluent<?> fluent,OpenShiftAPIServerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OpenShiftAPIServerStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenShiftAPIServerStatusBuilder(OpenShiftAPIServerStatus instance) {
    this(instance,false);
  }
  public OpenShiftAPIServerStatusBuilder(OpenShiftAPIServerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OpenShiftAPIServerStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenShiftAPIServerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OpenShiftAPIServerStatus build() {
    OpenShiftAPIServerStatus buildable = new OpenShiftAPIServerStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getLatestAvailableRevision(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}