package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkStatusBuilder extends NetworkStatusFluent<NetworkStatusBuilder> implements VisitableBuilder<NetworkStatus,NetworkStatusBuilder>{
  public NetworkStatusBuilder() {
    this(false);
  }
  public NetworkStatusBuilder(Boolean validationEnabled) {
    this(new NetworkStatus(), validationEnabled);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkStatus(), validationEnabled);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent,NetworkStatus instance) {
    this(fluent, instance, false);
  }
  public NetworkStatusBuilder(NetworkStatusFluent<?> fluent,NetworkStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NetworkStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkStatusBuilder(NetworkStatus instance) {
    this(instance,false);
  }
  public NetworkStatusBuilder(NetworkStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NetworkStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkStatus build() {
    NetworkStatus buildable = new NetworkStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}