package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoggingDestinationBuilder extends LoggingDestinationFluent<LoggingDestinationBuilder> implements VisitableBuilder<LoggingDestination,LoggingDestinationBuilder>{
  public LoggingDestinationBuilder() {
    this(false);
  }
  public LoggingDestinationBuilder(Boolean validationEnabled) {
    this(new LoggingDestination(), validationEnabled);
  }
  public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent) {
    this(fluent, false);
  }
  public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoggingDestination(), validationEnabled);
  }
  public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,LoggingDestination instance) {
    this(fluent, instance, false);
  }
  public LoggingDestinationBuilder(LoggingDestinationFluent<?> fluent,LoggingDestination instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LoggingDestination());

    if (instance != null) {
      fluent.withContainer(instance.getContainer());
      fluent.withSyslog(instance.getSyslog());
      fluent.withType(instance.getType());
      fluent.withContainer(instance.getContainer());
      fluent.withSyslog(instance.getSyslog());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LoggingDestinationBuilder(LoggingDestination instance) {
    this(instance,false);
  }
  public LoggingDestinationBuilder(LoggingDestination instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LoggingDestination());

    if (instance != null) {
      this.withContainer(instance.getContainer());
      this.withSyslog(instance.getSyslog());
      this.withType(instance.getType());
      this.withContainer(instance.getContainer());
      this.withSyslog(instance.getSyslog());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LoggingDestinationFluent<?> fluent;
  Boolean validationEnabled;
  public LoggingDestination build() {
    LoggingDestination buildable = new LoggingDestination(fluent.buildContainer(),fluent.buildSyslog(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}