package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeSchedulerSpecBuilder extends KubeSchedulerSpecFluent<KubeSchedulerSpecBuilder> implements VisitableBuilder<KubeSchedulerSpec,KubeSchedulerSpecBuilder>{
  public KubeSchedulerSpecBuilder() {
    this(false);
  }
  public KubeSchedulerSpecBuilder(Boolean validationEnabled) {
    this(new KubeSchedulerSpec(), validationEnabled);
  }
  public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeSchedulerSpec(), validationEnabled);
  }
  public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent,KubeSchedulerSpec instance) {
    this(fluent, instance, false);
  }
  public KubeSchedulerSpecBuilder(KubeSchedulerSpecFluent<?> fluent,KubeSchedulerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeSchedulerSpec());

    if (instance != null) {
      fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit());
      fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit());
      fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason());
      fluent.withLogLevel(instance.getLogLevel());
      fluent.withManagementState(instance.getManagementState());
      fluent.withObservedConfig(instance.getObservedConfig());
      fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
      fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit());
      fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeSchedulerSpecBuilder(KubeSchedulerSpec instance) {
    this(instance,false);
  }
  public KubeSchedulerSpecBuilder(KubeSchedulerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeSchedulerSpec());

    if (instance != null) {
      this.withFailedRevisionLimit(instance.getFailedRevisionLimit());
      this.withForceRedeploymentReason(instance.getForceRedeploymentReason());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withFailedRevisionLimit(instance.getFailedRevisionLimit());
      this.withForceRedeploymentReason(instance.getForceRedeploymentReason());
      this.withLogLevel(instance.getLogLevel());
      this.withManagementState(instance.getManagementState());
      this.withObservedConfig(instance.getObservedConfig());
      this.withOperatorLogLevel(instance.getOperatorLogLevel());
      this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeSchedulerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KubeSchedulerSpec build() {
    KubeSchedulerSpec buildable = new KubeSchedulerSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.buildObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.buildUnsupportedConfigOverrides());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}