package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeSchedulerBuilder extends KubeSchedulerFluent<KubeSchedulerBuilder> implements VisitableBuilder<KubeScheduler,KubeSchedulerBuilder>{
  public KubeSchedulerBuilder() {
    this(false);
  }
  public KubeSchedulerBuilder(Boolean validationEnabled) {
    this(new KubeScheduler(), validationEnabled);
  }
  public KubeSchedulerBuilder(KubeSchedulerFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeSchedulerBuilder(KubeSchedulerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeScheduler(), validationEnabled);
  }
  public KubeSchedulerBuilder(KubeSchedulerFluent<?> fluent,KubeScheduler instance) {
    this(fluent, instance, false);
  }
  public KubeSchedulerBuilder(KubeSchedulerFluent<?> fluent,KubeScheduler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubeScheduler());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubeSchedulerBuilder(KubeScheduler instance) {
    this(instance,false);
  }
  public KubeSchedulerBuilder(KubeScheduler instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubeScheduler());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubeSchedulerFluent<?> fluent;
  Boolean validationEnabled;
  public KubeScheduler build() {
    KubeScheduler buildable = new KubeScheduler(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}