package io.fabric8.openshift.api.model.operator.v1;

import java.lang.String;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntryFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckConditionFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheck;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrorsBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyListBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntry;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatus;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckCondition;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntryBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrorsFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecBuilder;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.OutageEntry;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatusBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyListFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckConditionBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckListFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicyList;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.util.Map;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicy;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpec;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.LogEntryBuilder;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import io.fabric8.openshift.api.model.operator.v1alpha1.RepositoryDigestMirrors;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.openshift.api.model.operator.v1alpha1.ImageContentSourcePolicySpecBuilder;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckStatusFluent;
import io.fabric8.openshift.api.model.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckListBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressControllerSpecFluent<A extends IngressControllerSpecFluent<A>> extends BaseFluent<A>{
  public IngressControllerSpecFluent() {
  }
  public IngressControllerSpecFluent(IngressControllerSpec instance) {
    instance = (instance != null ? instance : new IngressControllerSpec());

    if (instance != null) {
      this.withClientTLS(instance.getClientTLS());
      this.withDefaultCertificate(instance.getDefaultCertificate());
      this.withDomain(instance.getDomain());
      this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy());
      this.withHttpCompression(instance.getHttpCompression());
      this.withHttpEmptyRequestsPolicy(instance.getHttpEmptyRequestsPolicy());
      this.withHttpErrorCodePages(instance.getHttpErrorCodePages());
      this.withHttpHeaders(instance.getHttpHeaders());
      this.withLogging(instance.getLogging());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withNodePlacement(instance.getNodePlacement());
      this.withReplicas(instance.getReplicas());
      this.withRouteAdmission(instance.getRouteAdmission());
      this.withRouteSelector(instance.getRouteSelector());
      this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
      this.withTuningOptions(instance.getTuningOptions());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withClientTLS(instance.getClientTLS());
      this.withDefaultCertificate(instance.getDefaultCertificate());
      this.withDomain(instance.getDomain());
      this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy());
      this.withHttpCompression(instance.getHttpCompression());
      this.withHttpEmptyRequestsPolicy(instance.getHttpEmptyRequestsPolicy());
      this.withHttpErrorCodePages(instance.getHttpErrorCodePages());
      this.withHttpHeaders(instance.getHttpHeaders());
      this.withLogging(instance.getLogging());
      this.withNamespaceSelector(instance.getNamespaceSelector());
      this.withNodePlacement(instance.getNodePlacement());
      this.withReplicas(instance.getReplicas());
      this.withRouteAdmission(instance.getRouteAdmission());
      this.withRouteSelector(instance.getRouteSelector());
      this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
      this.withTuningOptions(instance.getTuningOptions());
      this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ClientTLSBuilder clientTLS;
  private LocalObjectReferenceBuilder defaultCertificate;
  private String domain;
  private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
  private HTTPCompressionPolicyBuilder httpCompression;
  private String httpEmptyRequestsPolicy;
  private ConfigMapNameReference httpErrorCodePages;
  private IngressControllerHTTPHeadersBuilder httpHeaders;
  private IngressControllerLoggingBuilder logging;
  private LabelSelectorBuilder namespaceSelector;
  private NodePlacementBuilder nodePlacement;
  private Integer replicas;
  private RouteAdmissionPolicyBuilder routeAdmission;
  private LabelSelectorBuilder routeSelector;
  private TLSSecurityProfile tlsSecurityProfile;
  private IngressControllerTuningOptionsBuilder tuningOptions;
  private VisitableBuilder<? extends KubernetesResource,?> unsupportedConfigOverrides;
  private Map<String,Object> additionalProperties;
  public ClientTLS buildClientTLS() {
    return this.clientTLS!=null ?this.clientTLS.build():null;
  }
  public A withClientTLS(ClientTLS clientTLS) {
    _visitables.get("clientTLS").remove(this.clientTLS);
    if (clientTLS!=null){ this.clientTLS= new ClientTLSBuilder(clientTLS); _visitables.get("clientTLS").add(this.clientTLS);} else { this.clientTLS = null; _visitables.get("clientTLS").remove(this.clientTLS); } return (A) this;
  }
  public boolean hasClientTLS() {
    return this.clientTLS != null;
  }
  public ClientTLSNested<A> withNewClientTLS() {
    return new ClientTLSNested(null);
  }
  public ClientTLSNested<A> withNewClientTLSLike(ClientTLS item) {
    return new ClientTLSNested(item);
  }
  public ClientTLSNested<A> editClientTLS() {
    return withNewClientTLSLike(java.util.Optional.ofNullable(buildClientTLS()).orElse(null));
  }
  public ClientTLSNested<A> editOrNewClientTLS() {
    return withNewClientTLSLike(java.util.Optional.ofNullable(buildClientTLS()).orElse(new ClientTLSBuilder().build()));
  }
  public ClientTLSNested<A> editOrNewClientTLSLike(ClientTLS item) {
    return withNewClientTLSLike(java.util.Optional.ofNullable(buildClientTLS()).orElse(item));
  }
  public LocalObjectReference buildDefaultCertificate() {
    return this.defaultCertificate!=null ?this.defaultCertificate.build():null;
  }
  public A withDefaultCertificate(LocalObjectReference defaultCertificate) {
    _visitables.get("defaultCertificate").remove(this.defaultCertificate);
    if (defaultCertificate!=null){ this.defaultCertificate= new LocalObjectReferenceBuilder(defaultCertificate); _visitables.get("defaultCertificate").add(this.defaultCertificate);} else { this.defaultCertificate = null; _visitables.get("defaultCertificate").remove(this.defaultCertificate); } return (A) this;
  }
  public boolean hasDefaultCertificate() {
    return this.defaultCertificate != null;
  }
  public A withNewDefaultCertificate(String name) {
    return (A)withDefaultCertificate(new LocalObjectReference(name));
  }
  public DefaultCertificateNested<A> withNewDefaultCertificate() {
    return new DefaultCertificateNested(null);
  }
  public DefaultCertificateNested<A> withNewDefaultCertificateLike(LocalObjectReference item) {
    return new DefaultCertificateNested(item);
  }
  public DefaultCertificateNested<A> editDefaultCertificate() {
    return withNewDefaultCertificateLike(java.util.Optional.ofNullable(buildDefaultCertificate()).orElse(null));
  }
  public DefaultCertificateNested<A> editOrNewDefaultCertificate() {
    return withNewDefaultCertificateLike(java.util.Optional.ofNullable(buildDefaultCertificate()).orElse(new LocalObjectReferenceBuilder().build()));
  }
  public DefaultCertificateNested<A> editOrNewDefaultCertificateLike(LocalObjectReference item) {
    return withNewDefaultCertificateLike(java.util.Optional.ofNullable(buildDefaultCertificate()).orElse(item));
  }
  public String getDomain() {
    return this.domain;
  }
  public A withDomain(String domain) {
    this.domain=domain; return (A) this;
  }
  public boolean hasDomain() {
    return this.domain != null;
  }
  public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy!=null ?this.endpointPublishingStrategy.build():null;
  }
  public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
    _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
    if (endpointPublishingStrategy!=null){ this.endpointPublishingStrategy= new EndpointPublishingStrategyBuilder(endpointPublishingStrategy); _visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);} else { this.endpointPublishingStrategy = null; _visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy); } return (A) this;
  }
  public boolean hasEndpointPublishingStrategy() {
    return this.endpointPublishingStrategy != null;
  }
  public EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
    return new EndpointPublishingStrategyNested(null);
  }
  public EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return new EndpointPublishingStrategyNested(item);
  }
  public EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(java.util.Optional.ofNullable(buildEndpointPublishingStrategy()).orElse(null));
  }
  public EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
    return withNewEndpointPublishingStrategyLike(java.util.Optional.ofNullable(buildEndpointPublishingStrategy()).orElse(new EndpointPublishingStrategyBuilder().build()));
  }
  public EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
    return withNewEndpointPublishingStrategyLike(java.util.Optional.ofNullable(buildEndpointPublishingStrategy()).orElse(item));
  }
  public HTTPCompressionPolicy buildHttpCompression() {
    return this.httpCompression!=null ?this.httpCompression.build():null;
  }
  public A withHttpCompression(HTTPCompressionPolicy httpCompression) {
    _visitables.get("httpCompression").remove(this.httpCompression);
    if (httpCompression!=null){ this.httpCompression= new HTTPCompressionPolicyBuilder(httpCompression); _visitables.get("httpCompression").add(this.httpCompression);} else { this.httpCompression = null; _visitables.get("httpCompression").remove(this.httpCompression); } return (A) this;
  }
  public boolean hasHttpCompression() {
    return this.httpCompression != null;
  }
  public HttpCompressionNested<A> withNewHttpCompression() {
    return new HttpCompressionNested(null);
  }
  public HttpCompressionNested<A> withNewHttpCompressionLike(HTTPCompressionPolicy item) {
    return new HttpCompressionNested(item);
  }
  public HttpCompressionNested<A> editHttpCompression() {
    return withNewHttpCompressionLike(java.util.Optional.ofNullable(buildHttpCompression()).orElse(null));
  }
  public HttpCompressionNested<A> editOrNewHttpCompression() {
    return withNewHttpCompressionLike(java.util.Optional.ofNullable(buildHttpCompression()).orElse(new HTTPCompressionPolicyBuilder().build()));
  }
  public HttpCompressionNested<A> editOrNewHttpCompressionLike(HTTPCompressionPolicy item) {
    return withNewHttpCompressionLike(java.util.Optional.ofNullable(buildHttpCompression()).orElse(item));
  }
  public String getHttpEmptyRequestsPolicy() {
    return this.httpEmptyRequestsPolicy;
  }
  public A withHttpEmptyRequestsPolicy(String httpEmptyRequestsPolicy) {
    this.httpEmptyRequestsPolicy=httpEmptyRequestsPolicy; return (A) this;
  }
  public boolean hasHttpEmptyRequestsPolicy() {
    return this.httpEmptyRequestsPolicy != null;
  }
  public ConfigMapNameReference getHttpErrorCodePages() {
    return this.httpErrorCodePages;
  }
  public A withHttpErrorCodePages(ConfigMapNameReference httpErrorCodePages) {
    this.httpErrorCodePages=httpErrorCodePages; return (A) this;
  }
  public boolean hasHttpErrorCodePages() {
    return this.httpErrorCodePages != null;
  }
  public A withNewHttpErrorCodePages(String name) {
    return (A)withHttpErrorCodePages(new ConfigMapNameReference(name));
  }
  public IngressControllerHTTPHeaders buildHttpHeaders() {
    return this.httpHeaders!=null ?this.httpHeaders.build():null;
  }
  public A withHttpHeaders(IngressControllerHTTPHeaders httpHeaders) {
    _visitables.get("httpHeaders").remove(this.httpHeaders);
    if (httpHeaders!=null){ this.httpHeaders= new IngressControllerHTTPHeadersBuilder(httpHeaders); _visitables.get("httpHeaders").add(this.httpHeaders);} else { this.httpHeaders = null; _visitables.get("httpHeaders").remove(this.httpHeaders); } return (A) this;
  }
  public boolean hasHttpHeaders() {
    return this.httpHeaders != null;
  }
  public HttpHeadersNested<A> withNewHttpHeaders() {
    return new HttpHeadersNested(null);
  }
  public HttpHeadersNested<A> withNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
    return new HttpHeadersNested(item);
  }
  public HttpHeadersNested<A> editHttpHeaders() {
    return withNewHttpHeadersLike(java.util.Optional.ofNullable(buildHttpHeaders()).orElse(null));
  }
  public HttpHeadersNested<A> editOrNewHttpHeaders() {
    return withNewHttpHeadersLike(java.util.Optional.ofNullable(buildHttpHeaders()).orElse(new IngressControllerHTTPHeadersBuilder().build()));
  }
  public HttpHeadersNested<A> editOrNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
    return withNewHttpHeadersLike(java.util.Optional.ofNullable(buildHttpHeaders()).orElse(item));
  }
  public IngressControllerLogging buildLogging() {
    return this.logging!=null ?this.logging.build():null;
  }
  public A withLogging(IngressControllerLogging logging) {
    _visitables.get("logging").remove(this.logging);
    if (logging!=null){ this.logging= new IngressControllerLoggingBuilder(logging); _visitables.get("logging").add(this.logging);} else { this.logging = null; _visitables.get("logging").remove(this.logging); } return (A) this;
  }
  public boolean hasLogging() {
    return this.logging != null;
  }
  public LoggingNested<A> withNewLogging() {
    return new LoggingNested(null);
  }
  public LoggingNested<A> withNewLoggingLike(IngressControllerLogging item) {
    return new LoggingNested(item);
  }
  public LoggingNested<A> editLogging() {
    return withNewLoggingLike(java.util.Optional.ofNullable(buildLogging()).orElse(null));
  }
  public LoggingNested<A> editOrNewLogging() {
    return withNewLoggingLike(java.util.Optional.ofNullable(buildLogging()).orElse(new IngressControllerLoggingBuilder().build()));
  }
  public LoggingNested<A> editOrNewLoggingLike(IngressControllerLogging item) {
    return withNewLoggingLike(java.util.Optional.ofNullable(buildLogging()).orElse(item));
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NamespaceSelectorNested(item);
  }
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  public NodePlacement buildNodePlacement() {
    return this.nodePlacement!=null ?this.nodePlacement.build():null;
  }
  public A withNodePlacement(NodePlacement nodePlacement) {
    _visitables.get("nodePlacement").remove(this.nodePlacement);
    if (nodePlacement!=null){ this.nodePlacement= new NodePlacementBuilder(nodePlacement); _visitables.get("nodePlacement").add(this.nodePlacement);} else { this.nodePlacement = null; _visitables.get("nodePlacement").remove(this.nodePlacement); } return (A) this;
  }
  public boolean hasNodePlacement() {
    return this.nodePlacement != null;
  }
  public NodePlacementNested<A> withNewNodePlacement() {
    return new NodePlacementNested(null);
  }
  public NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
    return new NodePlacementNested(item);
  }
  public NodePlacementNested<A> editNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(null));
  }
  public NodePlacementNested<A> editOrNewNodePlacement() {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(new NodePlacementBuilder().build()));
  }
  public NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
    return withNewNodePlacementLike(java.util.Optional.ofNullable(buildNodePlacement()).orElse(item));
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  public RouteAdmissionPolicy buildRouteAdmission() {
    return this.routeAdmission!=null ?this.routeAdmission.build():null;
  }
  public A withRouteAdmission(RouteAdmissionPolicy routeAdmission) {
    _visitables.get("routeAdmission").remove(this.routeAdmission);
    if (routeAdmission!=null){ this.routeAdmission= new RouteAdmissionPolicyBuilder(routeAdmission); _visitables.get("routeAdmission").add(this.routeAdmission);} else { this.routeAdmission = null; _visitables.get("routeAdmission").remove(this.routeAdmission); } return (A) this;
  }
  public boolean hasRouteAdmission() {
    return this.routeAdmission != null;
  }
  public A withNewRouteAdmission(String namespaceOwnership,String wildcardPolicy) {
    return (A)withRouteAdmission(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  public RouteAdmissionNested<A> withNewRouteAdmission() {
    return new RouteAdmissionNested(null);
  }
  public RouteAdmissionNested<A> withNewRouteAdmissionLike(RouteAdmissionPolicy item) {
    return new RouteAdmissionNested(item);
  }
  public RouteAdmissionNested<A> editRouteAdmission() {
    return withNewRouteAdmissionLike(java.util.Optional.ofNullable(buildRouteAdmission()).orElse(null));
  }
  public RouteAdmissionNested<A> editOrNewRouteAdmission() {
    return withNewRouteAdmissionLike(java.util.Optional.ofNullable(buildRouteAdmission()).orElse(new RouteAdmissionPolicyBuilder().build()));
  }
  public RouteAdmissionNested<A> editOrNewRouteAdmissionLike(RouteAdmissionPolicy item) {
    return withNewRouteAdmissionLike(java.util.Optional.ofNullable(buildRouteAdmission()).orElse(item));
  }
  public LabelSelector buildRouteSelector() {
    return this.routeSelector!=null ?this.routeSelector.build():null;
  }
  public A withRouteSelector(LabelSelector routeSelector) {
    _visitables.get("routeSelector").remove(this.routeSelector);
    if (routeSelector!=null){ this.routeSelector= new LabelSelectorBuilder(routeSelector); _visitables.get("routeSelector").add(this.routeSelector);} else { this.routeSelector = null; _visitables.get("routeSelector").remove(this.routeSelector); } return (A) this;
  }
  public boolean hasRouteSelector() {
    return this.routeSelector != null;
  }
  public RouteSelectorNested<A> withNewRouteSelector() {
    return new RouteSelectorNested(null);
  }
  public RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
    return new RouteSelectorNested(item);
  }
  public RouteSelectorNested<A> editRouteSelector() {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(null));
  }
  public RouteSelectorNested<A> editOrNewRouteSelector() {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  public RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
    return withNewRouteSelectorLike(java.util.Optional.ofNullable(buildRouteSelector()).orElse(item));
  }
  public TLSSecurityProfile getTlsSecurityProfile() {
    return this.tlsSecurityProfile;
  }
  public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
    this.tlsSecurityProfile=tlsSecurityProfile; return (A) this;
  }
  public boolean hasTlsSecurityProfile() {
    return this.tlsSecurityProfile != null;
  }
  public IngressControllerTuningOptions buildTuningOptions() {
    return this.tuningOptions!=null ?this.tuningOptions.build():null;
  }
  public A withTuningOptions(IngressControllerTuningOptions tuningOptions) {
    _visitables.get("tuningOptions").remove(this.tuningOptions);
    if (tuningOptions!=null){ this.tuningOptions= new IngressControllerTuningOptionsBuilder(tuningOptions); _visitables.get("tuningOptions").add(this.tuningOptions);} else { this.tuningOptions = null; _visitables.get("tuningOptions").remove(this.tuningOptions); } return (A) this;
  }
  public boolean hasTuningOptions() {
    return this.tuningOptions != null;
  }
  public TuningOptionsNested<A> withNewTuningOptions() {
    return new TuningOptionsNested(null);
  }
  public TuningOptionsNested<A> withNewTuningOptionsLike(IngressControllerTuningOptions item) {
    return new TuningOptionsNested(item);
  }
  public TuningOptionsNested<A> editTuningOptions() {
    return withNewTuningOptionsLike(java.util.Optional.ofNullable(buildTuningOptions()).orElse(null));
  }
  public TuningOptionsNested<A> editOrNewTuningOptions() {
    return withNewTuningOptionsLike(java.util.Optional.ofNullable(buildTuningOptions()).orElse(new IngressControllerTuningOptionsBuilder().build()));
  }
  public TuningOptionsNested<A> editOrNewTuningOptionsLike(IngressControllerTuningOptions item) {
    return withNewTuningOptionsLike(java.util.Optional.ofNullable(buildTuningOptions()).orElse(item));
  }
  public KubernetesResource buildUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides!=null?this.unsupportedConfigOverrides.build():null;
  }
  public A withUnsupportedConfigOverrides(KubernetesResource unsupportedConfigOverrides) {
    if (unsupportedConfigOverrides==null){ this.unsupportedConfigOverrides = null; _visitables.remove("unsupportedConfigOverrides"); return (A) this;}
    VisitableBuilder<? extends KubernetesResource,?> builder = builder(unsupportedConfigOverrides); _visitables.get("unsupportedConfigOverrides").clear();_visitables.get("unsupportedConfigOverrides").add(builder);this.unsupportedConfigOverrides = builder;
    return (A) this;
  }
  public boolean hasUnsupportedConfigOverrides() {
    return this.unsupportedConfigOverrides != null;
  }
  public ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerListUnsupportedConfigOverrides() {
    return new ServiceCatalogAPIServerListUnsupportedConfigOverridesNested(null);
  }
  public ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerListUnsupportedConfigOverridesLike(ServiceCatalogAPIServerList item) {
    return new ServiceCatalogAPIServerListUnsupportedConfigOverridesNested(item);
  }
  public ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverrides() {
    return new ImagePrunerUnsupportedConfigOverridesNested(null);
  }
  public ImagePrunerUnsupportedConfigOverridesNested<A> withNewImagePrunerUnsupportedConfigOverridesLike(ImagePruner item) {
    return new ImagePrunerUnsupportedConfigOverridesNested(item);
  }
  public KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverrides() {
    return new KubeControllerManagerUnsupportedConfigOverridesNested(null);
  }
  public KubeControllerManagerUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerUnsupportedConfigOverridesLike(KubeControllerManager item) {
    return new KubeControllerManagerUnsupportedConfigOverridesNested(item);
  }
  public PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested(null);
  }
  public PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckStatusUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckStatus item) {
    return new PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested(item);
  }
  public PodTemplateSpecUnsupportedConfigOverridesNested<A> withNewPodTemplateSpecUnsupportedConfigOverrides() {
    return new PodTemplateSpecUnsupportedConfigOverridesNested(null);
  }
  public PodTemplateSpecUnsupportedConfigOverridesNested<A> withNewPodTemplateSpecUnsupportedConfigOverridesLike(PodTemplateSpec item) {
    return new PodTemplateSpecUnsupportedConfigOverridesNested(item);
  }
  public KubeControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerStatusUnsupportedConfigOverrides() {
    return new KubeControllerManagerStatusUnsupportedConfigOverridesNested(null);
  }
  public KubeControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerStatusUnsupportedConfigOverridesLike(KubeControllerManagerStatus item) {
    return new KubeControllerManagerStatusUnsupportedConfigOverridesNested(item);
  }
  public CSISnapshotControllerStatusUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerStatusUnsupportedConfigOverrides() {
    return new CSISnapshotControllerStatusUnsupportedConfigOverridesNested(null);
  }
  public CSISnapshotControllerStatusUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerStatusUnsupportedConfigOverridesLike(CSISnapshotControllerStatus item) {
    return new CSISnapshotControllerStatusUnsupportedConfigOverridesNested(item);
  }
  public IPsecConfigUnsupportedOverridesNested<A> withNewIPsecConfigUnsupportedOverrides() {
    return new IPsecConfigUnsupportedOverridesNested(null);
  }
  public IPsecConfigUnsupportedOverridesNested<A> withNewIPsecConfigUnsupportedOverridesLike(IPsecConfig item) {
    return new IPsecConfigUnsupportedOverridesNested(item);
  }
  public ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverrides() {
    return new ImageContentSourcePolicyUnsupportedConfigOverridesNested(null);
  }
  public ImageContentSourcePolicyUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyUnsupportedConfigOverridesLike(ImageContentSourcePolicy item) {
    return new ImageContentSourcePolicyUnsupportedConfigOverridesNested(item);
  }
  public ResourceRequirementsUnsupportedConfigOverridesNested<A> withNewResourceRequirementsUnsupportedConfigOverrides() {
    return new ResourceRequirementsUnsupportedConfigOverridesNested(null);
  }
  public ResourceRequirementsUnsupportedConfigOverridesNested<A> withNewResourceRequirementsUnsupportedConfigOverridesLike(ResourceRequirements item) {
    return new ResourceRequirementsUnsupportedConfigOverridesNested(item);
  }
  public KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorSpecUnsupportedConfigOverrides() {
    return new KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested(null);
  }
  public KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorSpecUnsupportedConfigOverridesLike(KubeStorageVersionMigratorSpec item) {
    return new KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested(item);
  }
  public OpenShiftSDNConfigUnsupportedOverridesNested<A> withNewOpenShiftSDNConfigUnsupportedOverrides() {
    return new OpenShiftSDNConfigUnsupportedOverridesNested(null);
  }
  public OpenShiftSDNConfigUnsupportedOverridesNested<A> withNewOpenShiftSDNConfigUnsupportedOverridesLike(OpenShiftSDNConfig item) {
    return new OpenShiftSDNConfigUnsupportedOverridesNested(item);
  }
  public A withNewOpenShiftSDNConfigUnsupportedOverrides(Boolean enableUnidling,String mode,Integer mtu,Boolean useExternalOpenvswitch,Integer vxlanPort) {
    return (A)withUnsupportedConfigOverrides(new OpenShiftSDNConfig(enableUnidling, mode, mtu, useExternalOpenvswitch, vxlanPort));
  }
  public IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPHeadersUnsupportedConfigOverrides() {
    return new IngressControllerHTTPHeadersUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPHeadersUnsupportedConfigOverridesLike(IngressControllerHTTPHeaders item) {
    return new IngressControllerHTTPHeadersUnsupportedConfigOverridesNested(item);
  }
  public ConsoleListUnsupportedConfigOverridesNested<A> withNewConsoleListUnsupportedConfigOverrides() {
    return new ConsoleListUnsupportedConfigOverridesNested(null);
  }
  public ConsoleListUnsupportedConfigOverridesNested<A> withNewConsoleListUnsupportedConfigOverridesLike(ConsoleList item) {
    return new ConsoleListUnsupportedConfigOverridesNested(item);
  }
  public ServiceAccountIssuerStatusUnsupportedConfigOverridesNested<A> withNewServiceAccountIssuerStatusUnsupportedConfigOverrides() {
    return new ServiceAccountIssuerStatusUnsupportedConfigOverridesNested(null);
  }
  public ServiceAccountIssuerStatusUnsupportedConfigOverridesNested<A> withNewServiceAccountIssuerStatusUnsupportedConfigOverridesLike(ServiceAccountIssuerStatus item) {
    return new ServiceAccountIssuerStatusUnsupportedConfigOverridesNested(item);
  }
  public A withNewServiceAccountIssuerStatusUnsupportedConfigOverrides(String expirationTime,String name) {
    return (A)withUnsupportedConfigOverrides(new ServiceAccountIssuerStatus(expirationTime, name));
  }
  public DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides() {
    return new DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested(null);
  }
  public DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCategory item) {
    return new DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested(item);
  }
  public OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerSpecUnsupportedConfigOverrides() {
    return new OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested(null);
  }
  public OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerSpecUnsupportedConfigOverridesLike(OpenShiftControllerManagerSpec item) {
    return new OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested(item);
  }
  public ExportNetworkFlowsUnsupportedConfigOverridesNested<A> withNewExportNetworkFlowsUnsupportedConfigOverrides() {
    return new ExportNetworkFlowsUnsupportedConfigOverridesNested(null);
  }
  public ExportNetworkFlowsUnsupportedConfigOverridesNested<A> withNewExportNetworkFlowsUnsupportedConfigOverridesLike(ExportNetworkFlows item) {
    return new ExportNetworkFlowsUnsupportedConfigOverridesNested(item);
  }
  public ClusterCSIDriverSpecUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverSpecUnsupportedConfigOverrides() {
    return new ClusterCSIDriverSpecUnsupportedConfigOverridesNested(null);
  }
  public ClusterCSIDriverSpecUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverSpecUnsupportedConfigOverridesLike(ClusterCSIDriverSpec item) {
    return new ClusterCSIDriverSpecUnsupportedConfigOverridesNested(item);
  }
  public RepositoryDigestMirrorsUnsupportedConfigOverridesNested<A> withNewRepositoryDigestMirrorsUnsupportedConfigOverrides() {
    return new RepositoryDigestMirrorsUnsupportedConfigOverridesNested(null);
  }
  public RepositoryDigestMirrorsUnsupportedConfigOverridesNested<A> withNewRepositoryDigestMirrorsUnsupportedConfigOverridesLike(RepositoryDigestMirrors item) {
    return new RepositoryDigestMirrorsUnsupportedConfigOverridesNested(item);
  }
  public ConsoleCustomizationUnsupportedConfigOverridesNested<A> withNewConsoleCustomizationUnsupportedConfigOverrides() {
    return new ConsoleCustomizationUnsupportedConfigOverridesNested(null);
  }
  public ConsoleCustomizationUnsupportedConfigOverridesNested<A> withNewConsoleCustomizationUnsupportedConfigOverridesLike(ConsoleCustomization item) {
    return new ConsoleCustomizationUnsupportedConfigOverridesNested(item);
  }
  public CSISnapshotControllerSpecUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerSpecUnsupportedConfigOverrides() {
    return new CSISnapshotControllerSpecUnsupportedConfigOverridesNested(null);
  }
  public CSISnapshotControllerSpecUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerSpecUnsupportedConfigOverridesLike(CSISnapshotControllerSpec item) {
    return new CSISnapshotControllerSpecUnsupportedConfigOverridesNested(item);
  }
  public UpstreamResolversUnsupportedConfigOverridesNested<A> withNewUpstreamResolversUnsupportedConfigOverrides() {
    return new UpstreamResolversUnsupportedConfigOverridesNested(null);
  }
  public UpstreamResolversUnsupportedConfigOverridesNested<A> withNewUpstreamResolversUnsupportedConfigOverridesLike(UpstreamResolvers item) {
    return new UpstreamResolversUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides() {
    return new IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<A> withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
    return new IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested(item);
  }
  public A withNewIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides(String format,String name) {
    return (A)withUnsupportedConfigOverrides(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
  }
  public MTUMigrationValuesUnsupportedConfigOverridesNested<A> withNewMTUMigrationValuesUnsupportedConfigOverrides() {
    return new MTUMigrationValuesUnsupportedConfigOverridesNested(null);
  }
  public MTUMigrationValuesUnsupportedConfigOverridesNested<A> withNewMTUMigrationValuesUnsupportedConfigOverridesLike(MTUMigrationValues item) {
    return new MTUMigrationValuesUnsupportedConfigOverridesNested(item);
  }
  public A withNewMTUMigrationValuesUnsupportedConfigOverrides(Integer from,Integer to) {
    return (A)withUnsupportedConfigOverrides(new MTUMigrationValues(from, to));
  }
  public ConfigStatusUnsupportedConfigOverridesNested<A> withNewConfigStatusUnsupportedConfigOverrides() {
    return new ConfigStatusUnsupportedConfigOverridesNested(null);
  }
  public ConfigStatusUnsupportedConfigOverridesNested<A> withNewConfigStatusUnsupportedConfigOverridesLike(ConfigStatus item) {
    return new ConfigStatusUnsupportedConfigOverridesNested(item);
  }
  public VSphereCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewVSphereCSIDriverConfigSpecUnsupportedOverrides() {
    return new VSphereCSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  public VSphereCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewVSphereCSIDriverConfigSpecUnsupportedOverridesLike(VSphereCSIDriverConfigSpec item) {
    return new VSphereCSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  public ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverrides() {
    return new ServiceCAUnsupportedConfigOverridesNested(null);
  }
  public ServiceCAUnsupportedConfigOverridesNested<A> withNewServiceCAUnsupportedConfigOverridesLike(ServiceCA item) {
    return new ServiceCAUnsupportedConfigOverridesNested(item);
  }
  public ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerSpecUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested(null);
  }
  public ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerSpecUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerSpec item) {
    return new ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerListUnsupportedConfigOverridesNested<A> withNewIngressControllerListUnsupportedConfigOverrides() {
    return new IngressControllerListUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerListUnsupportedConfigOverridesNested<A> withNewIngressControllerListUnsupportedConfigOverridesLike(IngressControllerList item) {
    return new IngressControllerListUnsupportedConfigOverridesNested(item);
  }
  public DNSListUnsupportedConfigOverridesNested<A> withNewDNSListUnsupportedConfigOverrides() {
    return new DNSListUnsupportedConfigOverridesNested(null);
  }
  public DNSListUnsupportedConfigOverridesNested<A> withNewDNSListUnsupportedConfigOverridesLike(DNSList item) {
    return new DNSListUnsupportedConfigOverridesNested(item);
  }
  public KubeAPIServerStatusUnsupportedConfigOverridesNested<A> withNewKubeAPIServerStatusUnsupportedConfigOverrides() {
    return new KubeAPIServerStatusUnsupportedConfigOverridesNested(null);
  }
  public KubeAPIServerStatusUnsupportedConfigOverridesNested<A> withNewKubeAPIServerStatusUnsupportedConfigOverridesLike(KubeAPIServerStatus item) {
    return new KubeAPIServerStatusUnsupportedConfigOverridesNested(item);
  }
  public AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSClassicLoadBalancerParametersUnsupportedConfigOverrides() {
    return new AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  public AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSClassicLoadBalancerParametersUnsupportedConfigOverridesLike(AWSClassicLoadBalancerParameters item) {
    return new AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  public KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverrides() {
    return new KubeAPIServerUnsupportedConfigOverridesNested(null);
  }
  public KubeAPIServerUnsupportedConfigOverridesNested<A> withNewKubeAPIServerUnsupportedConfigOverridesLike(KubeAPIServer item) {
    return new KubeAPIServerUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverrides() {
    return new IngressControllerUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerUnsupportedConfigOverridesNested<A> withNewIngressControllerUnsupportedConfigOverridesLike(IngressController item) {
    return new IngressControllerUnsupportedConfigOverridesNested(item);
  }
  public ConsoleConfigRouteUnsupportedOverridesNested<A> withNewConsoleConfigRouteUnsupportedOverrides() {
    return new ConsoleConfigRouteUnsupportedOverridesNested(null);
  }
  public ConsoleConfigRouteUnsupportedOverridesNested<A> withNewConsoleConfigRouteUnsupportedOverridesLike(ConsoleConfigRoute item) {
    return new ConsoleConfigRouteUnsupportedOverridesNested(item);
  }
  public CloudCredentialStatusUnsupportedConfigOverridesNested<A> withNewCloudCredentialStatusUnsupportedConfigOverrides() {
    return new CloudCredentialStatusUnsupportedConfigOverridesNested(null);
  }
  public CloudCredentialStatusUnsupportedConfigOverridesNested<A> withNewCloudCredentialStatusUnsupportedConfigOverridesLike(CloudCredentialStatus item) {
    return new CloudCredentialStatusUnsupportedConfigOverridesNested(item);
  }
  public KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverrides() {
    return new KubeStorageVersionMigratorUnsupportedConfigOverridesNested(null);
  }
  public KubeStorageVersionMigratorUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorUnsupportedConfigOverridesLike(KubeStorageVersionMigrator item) {
    return new KubeStorageVersionMigratorUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerStatusUnsupportedConfigOverridesNested<A> withNewIngressControllerStatusUnsupportedConfigOverrides() {
    return new IngressControllerStatusUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerStatusUnsupportedConfigOverridesNested<A> withNewIngressControllerStatusUnsupportedConfigOverridesLike(IngressControllerStatus item) {
    return new IngressControllerStatusUnsupportedConfigOverridesNested(item);
  }
  public ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerStatusUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested(null);
  }
  public ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerStatusUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerStatus item) {
    return new ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested(item);
  }
  public ImagePrunerListUnsupportedConfigOverridesNested<A> withNewImagePrunerListUnsupportedConfigOverrides() {
    return new ImagePrunerListUnsupportedConfigOverridesNested(null);
  }
  public ImagePrunerListUnsupportedConfigOverridesNested<A> withNewImagePrunerListUnsupportedConfigOverridesLike(ImagePrunerList item) {
    return new ImagePrunerListUnsupportedConfigOverridesNested(item);
  }
  public LocalObjectReferenceUnsupportedConfigOverridesNested<A> withNewLocalObjectReferenceUnsupportedConfigOverrides() {
    return new LocalObjectReferenceUnsupportedConfigOverridesNested(null);
  }
  public LocalObjectReferenceUnsupportedConfigOverridesNested<A> withNewLocalObjectReferenceUnsupportedConfigOverridesLike(LocalObjectReference item) {
    return new LocalObjectReferenceUnsupportedConfigOverridesNested(item);
  }
  public A withNewLocalObjectReferenceUnsupportedConfigOverrides(String name) {
    return (A)withUnsupportedConfigOverrides(new LocalObjectReference(name));
  }
  public StaticIPAMRoutesUnsupportedConfigOverridesNested<A> withNewStaticIPAMRoutesUnsupportedConfigOverrides() {
    return new StaticIPAMRoutesUnsupportedConfigOverridesNested(null);
  }
  public StaticIPAMRoutesUnsupportedConfigOverridesNested<A> withNewStaticIPAMRoutesUnsupportedConfigOverridesLike(StaticIPAMRoutes item) {
    return new StaticIPAMRoutesUnsupportedConfigOverridesNested(item);
  }
  public A withNewStaticIPAMRoutesUnsupportedConfigOverrides(String destination,String gateway) {
    return (A)withUnsupportedConfigOverrides(new StaticIPAMRoutes(destination, gateway));
  }
  public ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewContainerLoggingDestinationParametersUnsupportedConfigOverrides() {
    return new ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested(null);
  }
  public ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewContainerLoggingDestinationParametersUnsupportedConfigOverridesLike(ContainerLoggingDestinationParameters item) {
    return new ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested(item);
  }
  public A withNewContainerLoggingDestinationParametersUnsupportedConfigOverrides(Integer maxLength) {
    return (A)withUnsupportedConfigOverrides(new ContainerLoggingDestinationParameters(maxLength));
  }
  public KubeSchedulerListUnsupportedConfigOverridesNested<A> withNewKubeSchedulerListUnsupportedConfigOverrides() {
    return new KubeSchedulerListUnsupportedConfigOverridesNested(null);
  }
  public KubeSchedulerListUnsupportedConfigOverridesNested<A> withNewKubeSchedulerListUnsupportedConfigOverridesLike(KubeSchedulerList item) {
    return new KubeSchedulerListUnsupportedConfigOverridesNested(item);
  }
  public KubeAPIServerSpecUnsupportedConfigOverridesNested<A> withNewKubeAPIServerSpecUnsupportedConfigOverrides() {
    return new KubeAPIServerSpecUnsupportedConfigOverridesNested(null);
  }
  public KubeAPIServerSpecUnsupportedConfigOverridesNested<A> withNewKubeAPIServerSpecUnsupportedConfigOverridesLike(KubeAPIServerSpec item) {
    return new KubeAPIServerSpecUnsupportedConfigOverridesNested(item);
  }
  public OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverrides() {
    return new OpenShiftControllerManagerUnsupportedConfigOverridesNested(null);
  }
  public OpenShiftControllerManagerUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerUnsupportedConfigOverridesLike(OpenShiftControllerManager item) {
    return new OpenShiftControllerManagerUnsupportedConfigOverridesNested(item);
  }
  public EndpointPublishingStrategyUnsupportedConfigOverridesNested<A> withNewEndpointPublishingStrategyUnsupportedConfigOverrides() {
    return new EndpointPublishingStrategyUnsupportedConfigOverridesNested(null);
  }
  public EndpointPublishingStrategyUnsupportedConfigOverridesNested<A> withNewEndpointPublishingStrategyUnsupportedConfigOverridesLike(EndpointPublishingStrategy item) {
    return new EndpointPublishingStrategyUnsupportedConfigOverridesNested(item);
  }
  public CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverrides() {
    return new CloudCredentialUnsupportedConfigOverridesNested(null);
  }
  public CloudCredentialUnsupportedConfigOverridesNested<A> withNewCloudCredentialUnsupportedConfigOverridesLike(CloudCredential item) {
    return new CloudCredentialUnsupportedConfigOverridesNested(item);
  }
  public KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverrides() {
    return new KubeSchedulerUnsupportedConfigOverridesNested(null);
  }
  public KubeSchedulerUnsupportedConfigOverridesNested<A> withNewKubeSchedulerUnsupportedConfigOverridesLike(KubeScheduler item) {
    return new KubeSchedulerUnsupportedConfigOverridesNested(item);
  }
  public ClusterCSIDriverStatusUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverStatusUnsupportedConfigOverrides() {
    return new ClusterCSIDriverStatusUnsupportedConfigOverridesNested(null);
  }
  public ClusterCSIDriverStatusUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverStatusUnsupportedConfigOverridesLike(ClusterCSIDriverStatus item) {
    return new ClusterCSIDriverStatusUnsupportedConfigOverridesNested(item);
  }
  public SFlowConfigUnsupportedOverridesNested<A> withNewSFlowConfigUnsupportedOverrides() {
    return new SFlowConfigUnsupportedOverridesNested(null);
  }
  public SFlowConfigUnsupportedOverridesNested<A> withNewSFlowConfigUnsupportedOverridesLike(SFlowConfig item) {
    return new SFlowConfigUnsupportedOverridesNested(item);
  }
  public ForwardPluginUnsupportedConfigOverridesNested<A> withNewForwardPluginUnsupportedConfigOverrides() {
    return new ForwardPluginUnsupportedConfigOverridesNested(null);
  }
  public ForwardPluginUnsupportedConfigOverridesNested<A> withNewForwardPluginUnsupportedConfigOverridesLike(ForwardPlugin item) {
    return new ForwardPluginUnsupportedConfigOverridesNested(item);
  }
  public LogEntryUnsupportedConfigOverridesNested<A> withNewLogEntryUnsupportedConfigOverrides() {
    return new LogEntryUnsupportedConfigOverridesNested(null);
  }
  public LogEntryUnsupportedConfigOverridesNested<A> withNewLogEntryUnsupportedConfigOverridesLike(LogEntry item) {
    return new LogEntryUnsupportedConfigOverridesNested(item);
  }
  public AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewAdditionalNetworkDefinitionUnsupportedConfigOverrides() {
    return new AdditionalNetworkDefinitionUnsupportedConfigOverridesNested(null);
  }
  public AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewAdditionalNetworkDefinitionUnsupportedConfigOverridesLike(AdditionalNetworkDefinition item) {
    return new AdditionalNetworkDefinitionUnsupportedConfigOverridesNested(item);
  }
  public AuthenticationStatusUnsupportedConfigOverridesNested<A> withNewAuthenticationStatusUnsupportedConfigOverrides() {
    return new AuthenticationStatusUnsupportedConfigOverridesNested(null);
  }
  public AuthenticationStatusUnsupportedConfigOverridesNested<A> withNewAuthenticationStatusUnsupportedConfigOverridesLike(AuthenticationStatus item) {
    return new AuthenticationStatusUnsupportedConfigOverridesNested(item);
  }
  public NodePortStrategyUnsupportedConfigOverridesNested<A> withNewNodePortStrategyUnsupportedConfigOverrides() {
    return new NodePortStrategyUnsupportedConfigOverridesNested(null);
  }
  public NodePortStrategyUnsupportedConfigOverridesNested<A> withNewNodePortStrategyUnsupportedConfigOverridesLike(NodePortStrategy item) {
    return new NodePortStrategyUnsupportedConfigOverridesNested(item);
  }
  public A withNewNodePortStrategyUnsupportedConfigOverrides(String protocol) {
    return (A)withUnsupportedConfigOverrides(new NodePortStrategy(protocol));
  }
  public NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverrides() {
    return new NetworkUnsupportedConfigOverridesNested(null);
  }
  public NetworkUnsupportedConfigOverridesNested<A> withNewNetworkUnsupportedConfigOverridesLike(Network item) {
    return new NetworkUnsupportedConfigOverridesNested(item);
  }
  public ClientTLSUnsupportedConfigOverridesNested<A> withNewClientTLSUnsupportedConfigOverrides() {
    return new ClientTLSUnsupportedConfigOverridesNested(null);
  }
  public ClientTLSUnsupportedConfigOverridesNested<A> withNewClientTLSUnsupportedConfigOverridesLike(ClientTLS item) {
    return new ClientTLSUnsupportedConfigOverridesNested(item);
  }
  public ImagePrunerStatusUnsupportedConfigOverridesNested<A> withNewImagePrunerStatusUnsupportedConfigOverrides() {
    return new ImagePrunerStatusUnsupportedConfigOverridesNested(null);
  }
  public ImagePrunerStatusUnsupportedConfigOverridesNested<A> withNewImagePrunerStatusUnsupportedConfigOverridesLike(ImagePrunerStatus item) {
    return new ImagePrunerStatusUnsupportedConfigOverridesNested(item);
  }
  public UpstreamUnsupportedConfigOverridesNested<A> withNewUpstreamUnsupportedConfigOverrides() {
    return new UpstreamUnsupportedConfigOverridesNested(null);
  }
  public UpstreamUnsupportedConfigOverridesNested<A> withNewUpstreamUnsupportedConfigOverridesLike(Upstream item) {
    return new UpstreamUnsupportedConfigOverridesNested(item);
  }
  public A withNewUpstreamUnsupportedConfigOverrides(String address,Integer port,String type) {
    return (A)withUnsupportedConfigOverrides(new Upstream(address, port, type));
  }
  public AzureDiskEncryptionSetUnsupportedConfigOverridesNested<A> withNewAzureDiskEncryptionSetUnsupportedConfigOverrides() {
    return new AzureDiskEncryptionSetUnsupportedConfigOverridesNested(null);
  }
  public AzureDiskEncryptionSetUnsupportedConfigOverridesNested<A> withNewAzureDiskEncryptionSetUnsupportedConfigOverridesLike(AzureDiskEncryptionSet item) {
    return new AzureDiskEncryptionSetUnsupportedConfigOverridesNested(item);
  }
  public A withNewAzureDiskEncryptionSetUnsupportedConfigOverrides(String name,String resourceGroup,String subscriptionID) {
    return (A)withUnsupportedConfigOverrides(new AzureDiskEncryptionSet(name, resourceGroup, subscriptionID));
  }
  public ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverrides() {
    return new ServiceCatalogAPIServerUnsupportedConfigOverridesNested(null);
  }
  public ServiceCatalogAPIServerUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerUnsupportedConfigOverridesLike(ServiceCatalogAPIServer item) {
    return new ServiceCatalogAPIServerUnsupportedConfigOverridesNested(item);
  }
  public CSIDriverConfigSpecUnsupportedOverridesNested<A> withNewCSIDriverConfigSpecUnsupportedOverrides() {
    return new CSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  public CSIDriverConfigSpecUnsupportedOverridesNested<A> withNewCSIDriverConfigSpecUnsupportedOverridesLike(CSIDriverConfigSpec item) {
    return new CSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  public IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides() {
    return new IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPHeader item) {
    return new IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested(item);
  }
  public A withNewIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides(Integer maxLength,String name) {
    return (A)withUnsupportedConfigOverrides(new IngressControllerCaptureHTTPHeader(maxLength, name));
  }
  public NetworkMigrationUnsupportedConfigOverridesNested<A> withNewNetworkMigrationUnsupportedConfigOverrides() {
    return new NetworkMigrationUnsupportedConfigOverridesNested(null);
  }
  public NetworkMigrationUnsupportedConfigOverridesNested<A> withNewNetworkMigrationUnsupportedConfigOverridesLike(NetworkMigration item) {
    return new NetworkMigrationUnsupportedConfigOverridesNested(item);
  }
  public DNSRecordListUnsupportedConfigOverridesNested<A> withNewDNSRecordListUnsupportedConfigOverrides() {
    return new DNSRecordListUnsupportedConfigOverridesNested(null);
  }
  public DNSRecordListUnsupportedConfigOverridesNested<A> withNewDNSRecordListUnsupportedConfigOverridesLike(DNSRecordList item) {
    return new DNSRecordListUnsupportedConfigOverridesNested(item);
  }
  public RawExtensionUnsupportedConfigOverridesNested<A> withNewRawExtensionUnsupportedConfigOverrides() {
    return new RawExtensionUnsupportedConfigOverridesNested(null);
  }
  public RawExtensionUnsupportedConfigOverridesNested<A> withNewRawExtensionUnsupportedConfigOverridesLike(RawExtension item) {
    return new RawExtensionUnsupportedConfigOverridesNested(item);
  }
  public A withNewRawExtensionUnsupportedConfigOverrides(Object value) {
    return (A)withUnsupportedConfigOverrides(new RawExtension(value));
  }
  public EtcdSpecUnsupportedConfigOverridesNested<A> withNewEtcdSpecUnsupportedConfigOverrides() {
    return new EtcdSpecUnsupportedConfigOverridesNested(null);
  }
  public EtcdSpecUnsupportedConfigOverridesNested<A> withNewEtcdSpecUnsupportedConfigOverridesLike(EtcdSpec item) {
    return new EtcdSpecUnsupportedConfigOverridesNested(item);
  }
  public PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckUnsupportedConfigOverridesNested(null);
  }
  public PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckUnsupportedConfigOverridesLike(PodNetworkConnectivityCheck item) {
    return new PodNetworkConnectivityCheckUnsupportedConfigOverridesNested(item);
  }
  public OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerStatusUnsupportedConfigOverrides() {
    return new OpenShiftAPIServerStatusUnsupportedConfigOverridesNested(null);
  }
  public OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerStatusUnsupportedConfigOverridesLike(OpenShiftAPIServerStatus item) {
    return new OpenShiftAPIServerStatusUnsupportedConfigOverridesNested(item);
  }
  public LoadBalancerStrategyUnsupportedConfigOverridesNested<A> withNewLoadBalancerStrategyUnsupportedConfigOverrides() {
    return new LoadBalancerStrategyUnsupportedConfigOverridesNested(null);
  }
  public LoadBalancerStrategyUnsupportedConfigOverridesNested<A> withNewLoadBalancerStrategyUnsupportedConfigOverridesLike(LoadBalancerStrategy item) {
    return new LoadBalancerStrategyUnsupportedConfigOverridesNested(item);
  }
  public DNSOverTLSConfigUnsupportedOverridesNested<A> withNewDNSOverTLSConfigUnsupportedOverrides() {
    return new DNSOverTLSConfigUnsupportedOverridesNested(null);
  }
  public DNSOverTLSConfigUnsupportedOverridesNested<A> withNewDNSOverTLSConfigUnsupportedOverridesLike(DNSOverTLSConfig item) {
    return new DNSOverTLSConfigUnsupportedOverridesNested(item);
  }
  public CloudCredentialListUnsupportedConfigOverridesNested<A> withNewCloudCredentialListUnsupportedConfigOverrides() {
    return new CloudCredentialListUnsupportedConfigOverridesNested(null);
  }
  public CloudCredentialListUnsupportedConfigOverridesNested<A> withNewCloudCredentialListUnsupportedConfigOverridesLike(CloudCredentialList item) {
    return new CloudCredentialListUnsupportedConfigOverridesNested(item);
  }
  public DNSCacheUnsupportedConfigOverridesNested<A> withNewDNSCacheUnsupportedConfigOverrides() {
    return new DNSCacheUnsupportedConfigOverridesNested(null);
  }
  public DNSCacheUnsupportedConfigOverridesNested<A> withNewDNSCacheUnsupportedConfigOverridesLike(DNSCache item) {
    return new DNSCacheUnsupportedConfigOverridesNested(item);
  }
  public ImagePrunerSpecUnsupportedConfigOverridesNested<A> withNewImagePrunerSpecUnsupportedConfigOverrides() {
    return new ImagePrunerSpecUnsupportedConfigOverridesNested(null);
  }
  public ImagePrunerSpecUnsupportedConfigOverridesNested<A> withNewImagePrunerSpecUnsupportedConfigOverridesLike(ImagePrunerSpec item) {
    return new ImagePrunerSpecUnsupportedConfigOverridesNested(item);
  }
  public ConfigListUnsupportedConfigOverridesNested<A> withNewConfigListUnsupportedConfigOverrides() {
    return new ConfigListUnsupportedConfigOverridesNested(null);
  }
  public ConfigListUnsupportedConfigOverridesNested<A> withNewConfigListUnsupportedConfigOverridesLike(ConfigList item) {
    return new ConfigListUnsupportedConfigOverridesNested(item);
  }
  public AuthenticationListUnsupportedConfigOverridesNested<A> withNewAuthenticationListUnsupportedConfigOverrides() {
    return new AuthenticationListUnsupportedConfigOverridesNested(null);
  }
  public AuthenticationListUnsupportedConfigOverridesNested<A> withNewAuthenticationListUnsupportedConfigOverridesLike(AuthenticationList item) {
    return new AuthenticationListUnsupportedConfigOverridesNested(item);
  }
  public PinnedResourceReferenceUnsupportedConfigOverridesNested<A> withNewPinnedResourceReferenceUnsupportedConfigOverrides() {
    return new PinnedResourceReferenceUnsupportedConfigOverridesNested(null);
  }
  public PinnedResourceReferenceUnsupportedConfigOverridesNested<A> withNewPinnedResourceReferenceUnsupportedConfigOverridesLike(PinnedResourceReference item) {
    return new PinnedResourceReferenceUnsupportedConfigOverridesNested(item);
  }
  public A withNewPinnedResourceReferenceUnsupportedConfigOverrides(String group,String resource,String version) {
    return (A)withUnsupportedConfigOverrides(new PinnedResourceReference(group, resource, version));
  }
  public KubeControllerManagerListUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerListUnsupportedConfigOverrides() {
    return new KubeControllerManagerListUnsupportedConfigOverridesNested(null);
  }
  public KubeControllerManagerListUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerListUnsupportedConfigOverridesLike(KubeControllerManagerList item) {
    return new KubeControllerManagerListUnsupportedConfigOverridesNested(item);
  }
  public IPAMConfigUnsupportedOverridesNested<A> withNewIPAMConfigUnsupportedOverrides() {
    return new IPAMConfigUnsupportedOverridesNested(null);
  }
  public IPAMConfigUnsupportedOverridesNested<A> withNewIPAMConfigUnsupportedOverridesLike(IPAMConfig item) {
    return new IPAMConfigUnsupportedOverridesNested(item);
  }
  public ContainerUnsupportedConfigOverridesNested<A> withNewContainerUnsupportedConfigOverrides() {
    return new ContainerUnsupportedConfigOverridesNested(null);
  }
  public ContainerUnsupportedConfigOverridesNested<A> withNewContainerUnsupportedConfigOverridesLike(Container item) {
    return new ContainerUnsupportedConfigOverridesNested(item);
  }
  public IBMLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewIBMLoadBalancerParametersUnsupportedConfigOverrides() {
    return new IBMLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  public IBMLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewIBMLoadBalancerParametersUnsupportedConfigOverridesLike(IBMLoadBalancerParameters item) {
    return new IBMLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  public A withNewIBMLoadBalancerParametersUnsupportedConfigOverrides(String protocol) {
    return (A)withUnsupportedConfigOverrides(new IBMLoadBalancerParameters(protocol));
  }
  public AccessLoggingUnsupportedConfigOverridesNested<A> withNewAccessLoggingUnsupportedConfigOverrides() {
    return new AccessLoggingUnsupportedConfigOverridesNested(null);
  }
  public AccessLoggingUnsupportedConfigOverridesNested<A> withNewAccessLoggingUnsupportedConfigOverridesLike(AccessLogging item) {
    return new AccessLoggingUnsupportedConfigOverridesNested(item);
  }
  public HostNetworkStrategyUnsupportedConfigOverridesNested<A> withNewHostNetworkStrategyUnsupportedConfigOverrides() {
    return new HostNetworkStrategyUnsupportedConfigOverridesNested(null);
  }
  public HostNetworkStrategyUnsupportedConfigOverridesNested<A> withNewHostNetworkStrategyUnsupportedConfigOverridesLike(HostNetworkStrategy item) {
    return new HostNetworkStrategyUnsupportedConfigOverridesNested(item);
  }
  public A withNewHostNetworkStrategyUnsupportedConfigOverrides(Integer httpPort,Integer httpsPort,String protocol,Integer statsPort) {
    return (A)withUnsupportedConfigOverrides(new HostNetworkStrategy(httpPort, httpsPort, protocol, statsPort));
  }
  public KubeSchedulerSpecUnsupportedConfigOverridesNested<A> withNewKubeSchedulerSpecUnsupportedConfigOverrides() {
    return new KubeSchedulerSpecUnsupportedConfigOverridesNested(null);
  }
  public KubeSchedulerSpecUnsupportedConfigOverridesNested<A> withNewKubeSchedulerSpecUnsupportedConfigOverridesLike(KubeSchedulerSpec item) {
    return new KubeSchedulerSpecUnsupportedConfigOverridesNested(item);
  }
  public ImageContentSourcePolicyListUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyListUnsupportedConfigOverrides() {
    return new ImageContentSourcePolicyListUnsupportedConfigOverridesNested(null);
  }
  public ImageContentSourcePolicyListUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicyListUnsupportedConfigOverridesLike(ImageContentSourcePolicyList item) {
    return new ImageContentSourcePolicyListUnsupportedConfigOverridesNested(item);
  }
  public OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerStatusUnsupportedConfigOverrides() {
    return new OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested(null);
  }
  public OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerStatusUnsupportedConfigOverridesLike(OpenShiftControllerManagerStatus item) {
    return new OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested(item);
  }
  public ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerStatusUnsupportedConfigOverrides() {
    return new ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested(null);
  }
  public ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerStatusUnsupportedConfigOverridesLike(ServiceCatalogAPIServerStatus item) {
    return new ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested(item);
  }
  public DNSNodePlacementUnsupportedConfigOverridesNested<A> withNewDNSNodePlacementUnsupportedConfigOverrides() {
    return new DNSNodePlacementUnsupportedConfigOverridesNested(null);
  }
  public DNSNodePlacementUnsupportedConfigOverridesNested<A> withNewDNSNodePlacementUnsupportedConfigOverridesLike(DNSNodePlacement item) {
    return new DNSNodePlacementUnsupportedConfigOverridesNested(item);
  }
  public NetworkListUnsupportedConfigOverridesNested<A> withNewNetworkListUnsupportedConfigOverrides() {
    return new NetworkListUnsupportedConfigOverridesNested(null);
  }
  public NetworkListUnsupportedConfigOverridesNested<A> withNewNetworkListUnsupportedConfigOverridesLike(NetworkList item) {
    return new NetworkListUnsupportedConfigOverridesNested(item);
  }
  public ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewProviderLoadBalancerParametersUnsupportedConfigOverrides() {
    return new ProviderLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  public ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewProviderLoadBalancerParametersUnsupportedConfigOverridesLike(ProviderLoadBalancerParameters item) {
    return new ProviderLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  public ResourceAttributesAccessReviewUnsupportedConfigOverridesNested<A> withNewResourceAttributesAccessReviewUnsupportedConfigOverrides() {
    return new ResourceAttributesAccessReviewUnsupportedConfigOverridesNested(null);
  }
  public ResourceAttributesAccessReviewUnsupportedConfigOverridesNested<A> withNewResourceAttributesAccessReviewUnsupportedConfigOverridesLike(ResourceAttributesAccessReview item) {
    return new ResourceAttributesAccessReviewUnsupportedConfigOverridesNested(item);
  }
  public ServiceCASpecUnsupportedConfigOverridesNested<A> withNewServiceCASpecUnsupportedConfigOverrides() {
    return new ServiceCASpecUnsupportedConfigOverridesNested(null);
  }
  public ServiceCASpecUnsupportedConfigOverridesNested<A> withNewServiceCASpecUnsupportedConfigOverridesLike(ServiceCASpec item) {
    return new ServiceCASpecUnsupportedConfigOverridesNested(item);
  }
  public PrivateStrategyUnsupportedConfigOverridesNested<A> withNewPrivateStrategyUnsupportedConfigOverrides() {
    return new PrivateStrategyUnsupportedConfigOverridesNested(null);
  }
  public PrivateStrategyUnsupportedConfigOverridesNested<A> withNewPrivateStrategyUnsupportedConfigOverridesLike(PrivateStrategy item) {
    return new PrivateStrategyUnsupportedConfigOverridesNested(item);
  }
  public A withNewPrivateStrategyUnsupportedConfigOverrides(String protocol) {
    return (A)withUnsupportedConfigOverrides(new PrivateStrategy(protocol));
  }
  public PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckListUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested(null);
  }
  public PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckListUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckList item) {
    return new PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested(item);
  }
  public OpenShiftAPIServerListUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerListUnsupportedConfigOverrides() {
    return new OpenShiftAPIServerListUnsupportedConfigOverridesNested(null);
  }
  public OpenShiftAPIServerListUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerListUnsupportedConfigOverridesLike(OpenShiftAPIServerList item) {
    return new OpenShiftAPIServerListUnsupportedConfigOverridesNested(item);
  }
  public OAuthAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOAuthAPIServerStatusUnsupportedConfigOverrides() {
    return new OAuthAPIServerStatusUnsupportedConfigOverridesNested(null);
  }
  public OAuthAPIServerStatusUnsupportedConfigOverridesNested<A> withNewOAuthAPIServerStatusUnsupportedConfigOverridesLike(OAuthAPIServerStatus item) {
    return new OAuthAPIServerStatusUnsupportedConfigOverridesNested(item);
  }
  public A withNewOAuthAPIServerStatusUnsupportedConfigOverrides(Integer latestAvailableRevision) {
    return (A)withUnsupportedConfigOverrides(new OAuthAPIServerStatus(latestAvailableRevision));
  }
  public GCPCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewGCPCSIDriverConfigSpecUnsupportedOverrides() {
    return new GCPCSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  public GCPCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewGCPCSIDriverConfigSpecUnsupportedOverridesLike(GCPCSIDriverConfigSpec item) {
    return new GCPCSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  public ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerUnsupportedConfigOverridesNested(null);
  }
  public ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerUnsupportedConfigOverridesLike(ServiceCatalogControllerManager item) {
    return new ServiceCatalogControllerManagerUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides() {
    return new IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPCookie item) {
    return new IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested(item);
  }
  public A withNewIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides(String matchType,Integer maxLength,String name,String namePrefix) {
    return (A)withUnsupportedConfigOverrides(new IngressControllerCaptureHTTPCookie(matchType, maxLength, name, namePrefix));
  }
  public DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverrides() {
    return new DNSUnsupportedConfigOverridesNested(null);
  }
  public DNSUnsupportedConfigOverridesNested<A> withNewDNSUnsupportedConfigOverridesLike(DNS item) {
    return new DNSUnsupportedConfigOverridesNested(item);
  }
  public AddPageUnsupportedConfigOverridesNested<A> withNewAddPageUnsupportedConfigOverrides() {
    return new AddPageUnsupportedConfigOverridesNested(null);
  }
  public AddPageUnsupportedConfigOverridesNested<A> withNewAddPageUnsupportedConfigOverridesLike(AddPage item) {
    return new AddPageUnsupportedConfigOverridesNested(item);
  }
  public AzureCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewAzureCSIDriverConfigSpecUnsupportedOverrides() {
    return new AzureCSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  public AzureCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewAzureCSIDriverConfigSpecUnsupportedOverridesLike(AzureCSIDriverConfigSpec item) {
    return new AzureCSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  public StorageListUnsupportedConfigOverridesNested<A> withNewStorageListUnsupportedConfigOverrides() {
    return new StorageListUnsupportedConfigOverridesNested(null);
  }
  public StorageListUnsupportedConfigOverridesNested<A> withNewStorageListUnsupportedConfigOverridesLike(StorageList item) {
    return new StorageListUnsupportedConfigOverridesNested(item);
  }
  public AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverrides() {
    return new AuthenticationUnsupportedConfigOverridesNested(null);
  }
  public AuthenticationUnsupportedConfigOverridesNested<A> withNewAuthenticationUnsupportedConfigOverridesLike(Authentication item) {
    return new AuthenticationUnsupportedConfigOverridesNested(item);
  }
  public ServiceCAStatusUnsupportedConfigOverridesNested<A> withNewServiceCAStatusUnsupportedConfigOverrides() {
    return new ServiceCAStatusUnsupportedConfigOverridesNested(null);
  }
  public ServiceCAStatusUnsupportedConfigOverridesNested<A> withNewServiceCAStatusUnsupportedConfigOverridesLike(ServiceCAStatus item) {
    return new ServiceCAStatusUnsupportedConfigOverridesNested(item);
  }
  public PerspectiveUnsupportedConfigOverridesNested<A> withNewPerspectiveUnsupportedConfigOverrides() {
    return new PerspectiveUnsupportedConfigOverridesNested(null);
  }
  public PerspectiveUnsupportedConfigOverridesNested<A> withNewPerspectiveUnsupportedConfigOverridesLike(Perspective item) {
    return new PerspectiveUnsupportedConfigOverridesNested(item);
  }
  public MTUMigrationUnsupportedConfigOverridesNested<A> withNewMTUMigrationUnsupportedConfigOverrides() {
    return new MTUMigrationUnsupportedConfigOverridesNested(null);
  }
  public MTUMigrationUnsupportedConfigOverridesNested<A> withNewMTUMigrationUnsupportedConfigOverridesLike(MTUMigration item) {
    return new MTUMigrationUnsupportedConfigOverridesNested(item);
  }
  public LabelSelectorUnsupportedConfigOverridesNested<A> withNewLabelSelectorUnsupportedConfigOverrides() {
    return new LabelSelectorUnsupportedConfigOverridesNested(null);
  }
  public LabelSelectorUnsupportedConfigOverridesNested<A> withNewLabelSelectorUnsupportedConfigOverridesLike(LabelSelector item) {
    return new LabelSelectorUnsupportedConfigOverridesNested(item);
  }
  public KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorListUnsupportedConfigOverrides() {
    return new KubeStorageVersionMigratorListUnsupportedConfigOverridesNested(null);
  }
  public KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorListUnsupportedConfigOverridesLike(KubeStorageVersionMigratorList item) {
    return new KubeStorageVersionMigratorListUnsupportedConfigOverridesNested(item);
  }
  public StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverrides() {
    return new StorageUnsupportedConfigOverridesNested(null);
  }
  public StorageUnsupportedConfigOverridesNested<A> withNewStorageUnsupportedConfigOverridesLike(Storage item) {
    return new StorageUnsupportedConfigOverridesNested(item);
  }
  public ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerListUnsupportedConfigOverrides() {
    return new ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested(null);
  }
  public ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<A> withNewServiceCatalogControllerManagerListUnsupportedConfigOverridesLike(ServiceCatalogControllerManagerList item) {
    return new ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested(item);
  }
  public OVNKubernetesConfigUnsupportedOverridesNested<A> withNewOVNKubernetesConfigUnsupportedOverrides() {
    return new OVNKubernetesConfigUnsupportedOverridesNested(null);
  }
  public OVNKubernetesConfigUnsupportedOverridesNested<A> withNewOVNKubernetesConfigUnsupportedOverridesLike(OVNKubernetesConfig item) {
    return new OVNKubernetesConfigUnsupportedOverridesNested(item);
  }
  public DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides() {
    return new DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested(null);
  }
  public DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCategoryMeta item) {
    return new DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerSpecUnsupportedConfigOverridesNested<A> withNewIngressControllerSpecUnsupportedConfigOverrides() {
    return new IngressControllerSpecUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerSpecUnsupportedConfigOverridesNested<A> withNewIngressControllerSpecUnsupportedConfigOverridesLike(IngressControllerSpec item) {
    return new IngressControllerSpecUnsupportedConfigOverridesNested(item);
  }
  public DNSSpecUnsupportedConfigOverridesNested<A> withNewDNSSpecUnsupportedConfigOverrides() {
    return new DNSSpecUnsupportedConfigOverridesNested(null);
  }
  public DNSSpecUnsupportedConfigOverridesNested<A> withNewDNSSpecUnsupportedConfigOverridesLike(DNSSpec item) {
    return new DNSSpecUnsupportedConfigOverridesNested(item);
  }
  public OperatorConditionUnsupportedConfigOverridesNested<A> withNewOperatorConditionUnsupportedConfigOverrides() {
    return new OperatorConditionUnsupportedConfigOverridesNested(null);
  }
  public OperatorConditionUnsupportedConfigOverridesNested<A> withNewOperatorConditionUnsupportedConfigOverridesLike(OperatorCondition item) {
    return new OperatorConditionUnsupportedConfigOverridesNested(item);
  }
  public A withNewOperatorConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withUnsupportedConfigOverrides(new OperatorCondition(lastTransitionTime, message, reason, status, type));
  }
  public ProxyConfigUnsupportedOverridesNested<A> withNewProxyConfigUnsupportedOverrides() {
    return new ProxyConfigUnsupportedOverridesNested(null);
  }
  public ProxyConfigUnsupportedOverridesNested<A> withNewProxyConfigUnsupportedOverridesLike(ProxyConfig item) {
    return new ProxyConfigUnsupportedOverridesNested(item);
  }
  public KuryrConfigUnsupportedOverridesNested<A> withNewKuryrConfigUnsupportedOverrides() {
    return new KuryrConfigUnsupportedOverridesNested(null);
  }
  public KuryrConfigUnsupportedOverridesNested<A> withNewKuryrConfigUnsupportedOverridesLike(KuryrConfig item) {
    return new KuryrConfigUnsupportedOverridesNested(item);
  }
  public ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerSpecUnsupportedConfigOverrides() {
    return new ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested(null);
  }
  public ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<A> withNewServiceCatalogAPIServerSpecUnsupportedConfigOverridesLike(ServiceCatalogAPIServerSpec item) {
    return new ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested(item);
  }
  public ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicySpecUnsupportedConfigOverrides() {
    return new ImageContentSourcePolicySpecUnsupportedConfigOverridesNested(null);
  }
  public ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<A> withNewImageContentSourcePolicySpecUnsupportedConfigOverridesLike(ImageContentSourcePolicySpec item) {
    return new ImageContentSourcePolicySpecUnsupportedConfigOverridesNested(item);
  }
  public DNSStatusUnsupportedConfigOverridesNested<A> withNewDNSStatusUnsupportedConfigOverrides() {
    return new DNSStatusUnsupportedConfigOverridesNested(null);
  }
  public DNSStatusUnsupportedConfigOverridesNested<A> withNewDNSStatusUnsupportedConfigOverridesLike(DNSStatus item) {
    return new DNSStatusUnsupportedConfigOverridesNested(item);
  }
  public DNSTransportConfigUnsupportedOverridesNested<A> withNewDNSTransportConfigUnsupportedOverrides() {
    return new DNSTransportConfigUnsupportedOverridesNested(null);
  }
  public DNSTransportConfigUnsupportedOverridesNested<A> withNewDNSTransportConfigUnsupportedOverridesLike(DNSTransportConfig item) {
    return new DNSTransportConfigUnsupportedOverridesNested(item);
  }
  public GCPLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewGCPLoadBalancerParametersUnsupportedConfigOverrides() {
    return new GCPLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  public GCPLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewGCPLoadBalancerParametersUnsupportedConfigOverridesLike(GCPLoadBalancerParameters item) {
    return new GCPLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  public A withNewGCPLoadBalancerParametersUnsupportedConfigOverrides(String clientAccess) {
    return (A)withUnsupportedConfigOverrides(new GCPLoadBalancerParameters(clientAccess));
  }
  public KubeAPIServerListUnsupportedConfigOverridesNested<A> withNewKubeAPIServerListUnsupportedConfigOverrides() {
    return new KubeAPIServerListUnsupportedConfigOverridesNested(null);
  }
  public KubeAPIServerListUnsupportedConfigOverridesNested<A> withNewKubeAPIServerListUnsupportedConfigOverridesLike(KubeAPIServerList item) {
    return new KubeAPIServerListUnsupportedConfigOverridesNested(item);
  }
  public ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverrides() {
    return new ConfigUnsupportedConfigOverridesNested(null);
  }
  public ConfigUnsupportedConfigOverridesNested<A> withNewConfigUnsupportedConfigOverridesLike(Config item) {
    return new ConfigUnsupportedConfigOverridesNested(item);
  }
  public ObjectMetaUnsupportedConfigOverridesNested<A> withNewObjectMetaUnsupportedConfigOverrides() {
    return new ObjectMetaUnsupportedConfigOverridesNested(null);
  }
  public ObjectMetaUnsupportedConfigOverridesNested<A> withNewObjectMetaUnsupportedConfigOverridesLike(ObjectMeta item) {
    return new ObjectMetaUnsupportedConfigOverridesNested(item);
  }
  public ClusterCSIDriverListUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverListUnsupportedConfigOverrides() {
    return new ClusterCSIDriverListUnsupportedConfigOverridesNested(null);
  }
  public ClusterCSIDriverListUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverListUnsupportedConfigOverridesLike(ClusterCSIDriverList item) {
    return new ClusterCSIDriverListUnsupportedConfigOverridesNested(item);
  }
  public SimpleMacvlanConfigUnsupportedOverridesNested<A> withNewSimpleMacvlanConfigUnsupportedOverrides() {
    return new SimpleMacvlanConfigUnsupportedOverridesNested(null);
  }
  public SimpleMacvlanConfigUnsupportedOverridesNested<A> withNewSimpleMacvlanConfigUnsupportedOverridesLike(SimpleMacvlanConfig item) {
    return new SimpleMacvlanConfigUnsupportedOverridesNested(item);
  }
  public PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverrides() {
    return new PersistentVolumeClaimUnsupportedConfigOverridesNested(null);
  }
  public PersistentVolumeClaimUnsupportedConfigOverridesNested<A> withNewPersistentVolumeClaimUnsupportedConfigOverridesLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimUnsupportedConfigOverridesNested(item);
  }
  public GenericKubernetesResourceUnsupportedConfigOverridesNested<A> withNewGenericKubernetesResourceUnsupportedConfigOverrides() {
    return new GenericKubernetesResourceUnsupportedConfigOverridesNested(null);
  }
  public GenericKubernetesResourceUnsupportedConfigOverridesNested<A> withNewGenericKubernetesResourceUnsupportedConfigOverridesLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceUnsupportedConfigOverridesNested(item);
  }
  public EgressIPConfigUnsupportedOverridesNested<A> withNewEgressIPConfigUnsupportedOverrides() {
    return new EgressIPConfigUnsupportedOverridesNested(null);
  }
  public EgressIPConfigUnsupportedOverridesNested<A> withNewEgressIPConfigUnsupportedOverridesLike(EgressIPConfig item) {
    return new EgressIPConfigUnsupportedOverridesNested(item);
  }
  public A withNewEgressIPConfigUnsupportedOverrides(Integer reachabilityTotalTimeoutSeconds) {
    return (A)withUnsupportedConfigOverrides(new EgressIPConfig(reachabilityTotalTimeoutSeconds));
  }
  public HybridOverlayConfigUnsupportedOverridesNested<A> withNewHybridOverlayConfigUnsupportedOverrides() {
    return new HybridOverlayConfigUnsupportedOverridesNested(null);
  }
  public HybridOverlayConfigUnsupportedOverridesNested<A> withNewHybridOverlayConfigUnsupportedOverridesLike(HybridOverlayConfig item) {
    return new HybridOverlayConfigUnsupportedOverridesNested(item);
  }
  public AWSLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSLoadBalancerParametersUnsupportedConfigOverrides() {
    return new AWSLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  public AWSLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSLoadBalancerParametersUnsupportedConfigOverridesLike(AWSLoadBalancerParameters item) {
    return new AWSLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  public CSISnapshotControllerListUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerListUnsupportedConfigOverrides() {
    return new CSISnapshotControllerListUnsupportedConfigOverridesNested(null);
  }
  public CSISnapshotControllerListUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerListUnsupportedConfigOverridesLike(CSISnapshotControllerList item) {
    return new CSISnapshotControllerListUnsupportedConfigOverridesNested(item);
  }
  public ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverrides() {
    return new ConsoleUnsupportedConfigOverridesNested(null);
  }
  public ConsoleUnsupportedConfigOverridesNested<A> withNewConsoleUnsupportedConfigOverridesLike(Console item) {
    return new ConsoleUnsupportedConfigOverridesNested(item);
  }
  public DNSZoneConditionUnsupportedConfigOverridesNested<A> withNewDNSZoneConditionUnsupportedConfigOverrides() {
    return new DNSZoneConditionUnsupportedConfigOverridesNested(null);
  }
  public DNSZoneConditionUnsupportedConfigOverridesNested<A> withNewDNSZoneConditionUnsupportedConfigOverridesLike(DNSZoneCondition item) {
    return new DNSZoneConditionUnsupportedConfigOverridesNested(item);
  }
  public A withNewDNSZoneConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withUnsupportedConfigOverrides(new DNSZoneCondition(lastTransitionTime, message, reason, status, type));
  }
  public ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverrides() {
    return new ClusterCSIDriverUnsupportedConfigOverridesNested(null);
  }
  public ClusterCSIDriverUnsupportedConfigOverridesNested<A> withNewClusterCSIDriverUnsupportedConfigOverridesLike(ClusterCSIDriver item) {
    return new ClusterCSIDriverUnsupportedConfigOverridesNested(item);
  }
  public QuickStartsUnsupportedConfigOverridesNested<A> withNewQuickStartsUnsupportedConfigOverrides() {
    return new QuickStartsUnsupportedConfigOverridesNested(null);
  }
  public QuickStartsUnsupportedConfigOverridesNested<A> withNewQuickStartsUnsupportedConfigOverridesLike(QuickStarts item) {
    return new QuickStartsUnsupportedConfigOverridesNested(item);
  }
  public DNSZoneStatusUnsupportedConfigOverridesNested<A> withNewDNSZoneStatusUnsupportedConfigOverrides() {
    return new DNSZoneStatusUnsupportedConfigOverridesNested(null);
  }
  public DNSZoneStatusUnsupportedConfigOverridesNested<A> withNewDNSZoneStatusUnsupportedConfigOverridesLike(DNSZoneStatus item) {
    return new DNSZoneStatusUnsupportedConfigOverridesNested(item);
  }
  public ConfigSpecUnsupportedConfigOverridesNested<A> withNewConfigSpecUnsupportedConfigOverrides() {
    return new ConfigSpecUnsupportedConfigOverridesNested(null);
  }
  public ConfigSpecUnsupportedConfigOverridesNested<A> withNewConfigSpecUnsupportedConfigOverridesLike(ConfigSpec item) {
    return new ConfigSpecUnsupportedConfigOverridesNested(item);
  }
  public OutageEntryUnsupportedConfigOverridesNested<A> withNewOutageEntryUnsupportedConfigOverrides() {
    return new OutageEntryUnsupportedConfigOverridesNested(null);
  }
  public OutageEntryUnsupportedConfigOverridesNested<A> withNewOutageEntryUnsupportedConfigOverridesLike(OutageEntry item) {
    return new OutageEntryUnsupportedConfigOverridesNested(item);
  }
  public OpenShiftControllerManagerListUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerListUnsupportedConfigOverrides() {
    return new OpenShiftControllerManagerListUnsupportedConfigOverridesNested(null);
  }
  public OpenShiftControllerManagerListUnsupportedConfigOverridesNested<A> withNewOpenShiftControllerManagerListUnsupportedConfigOverridesLike(OpenShiftControllerManagerList item) {
    return new OpenShiftControllerManagerListUnsupportedConfigOverridesNested(item);
  }
  public EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverrides() {
    return new EtcdUnsupportedConfigOverridesNested(null);
  }
  public EtcdUnsupportedConfigOverridesNested<A> withNewEtcdUnsupportedConfigOverridesLike(Etcd item) {
    return new EtcdUnsupportedConfigOverridesNested(item);
  }
  public IPFIXConfigUnsupportedOverridesNested<A> withNewIPFIXConfigUnsupportedOverrides() {
    return new IPFIXConfigUnsupportedOverridesNested(null);
  }
  public IPFIXConfigUnsupportedOverridesNested<A> withNewIPFIXConfigUnsupportedOverridesLike(IPFIXConfig item) {
    return new IPFIXConfigUnsupportedOverridesNested(item);
  }
  public NetworkStatusUnsupportedConfigOverridesNested<A> withNewNetworkStatusUnsupportedConfigOverrides() {
    return new NetworkStatusUnsupportedConfigOverridesNested(null);
  }
  public NetworkStatusUnsupportedConfigOverridesNested<A> withNewNetworkStatusUnsupportedConfigOverridesLike(NetworkStatus item) {
    return new NetworkStatusUnsupportedConfigOverridesNested(item);
  }
  public NodeStatusUnsupportedConfigOverridesNested<A> withNewNodeStatusUnsupportedConfigOverrides() {
    return new NodeStatusUnsupportedConfigOverridesNested(null);
  }
  public NodeStatusUnsupportedConfigOverridesNested<A> withNewNodeStatusUnsupportedConfigOverridesLike(NodeStatus item) {
    return new NodeStatusUnsupportedConfigOverridesNested(item);
  }
  public PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested(null);
  }
  public PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckCondition item) {
    return new PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested(item);
  }
  public A withNewPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withUnsupportedConfigOverrides(new PodNetworkConnectivityCheckCondition(lastTransitionTime, message, reason, status, type));
  }
  public RouteAdmissionPolicyUnsupportedConfigOverridesNested<A> withNewRouteAdmissionPolicyUnsupportedConfigOverrides() {
    return new RouteAdmissionPolicyUnsupportedConfigOverridesNested(null);
  }
  public RouteAdmissionPolicyUnsupportedConfigOverridesNested<A> withNewRouteAdmissionPolicyUnsupportedConfigOverridesLike(RouteAdmissionPolicy item) {
    return new RouteAdmissionPolicyUnsupportedConfigOverridesNested(item);
  }
  public A withNewRouteAdmissionPolicyUnsupportedConfigOverrides(String namespaceOwnership,String wildcardPolicy) {
    return (A)withUnsupportedConfigOverrides(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
  }
  public GenerationStatusUnsupportedConfigOverridesNested<A> withNewGenerationStatusUnsupportedConfigOverrides() {
    return new GenerationStatusUnsupportedConfigOverridesNested(null);
  }
  public GenerationStatusUnsupportedConfigOverridesNested<A> withNewGenerationStatusUnsupportedConfigOverridesLike(GenerationStatus item) {
    return new GenerationStatusUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides() {
    return new IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<A> withNewIngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesLike(IngressControllerCaptureHTTPHeaders item) {
    return new IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested(item);
  }
  public EtcdListUnsupportedConfigOverridesNested<A> withNewEtcdListUnsupportedConfigOverrides() {
    return new EtcdListUnsupportedConfigOverridesNested(null);
  }
  public EtcdListUnsupportedConfigOverridesNested<A> withNewEtcdListUnsupportedConfigOverridesLike(EtcdList item) {
    return new EtcdListUnsupportedConfigOverridesNested(item);
  }
  public FeaturesMigrationUnsupportedConfigOverridesNested<A> withNewFeaturesMigrationUnsupportedConfigOverrides() {
    return new FeaturesMigrationUnsupportedConfigOverridesNested(null);
  }
  public FeaturesMigrationUnsupportedConfigOverridesNested<A> withNewFeaturesMigrationUnsupportedConfigOverridesLike(FeaturesMigration item) {
    return new FeaturesMigrationUnsupportedConfigOverridesNested(item);
  }
  public A withNewFeaturesMigrationUnsupportedConfigOverrides(Boolean egressFirewall,Boolean egressIP,Boolean multicast) {
    return (A)withUnsupportedConfigOverrides(new FeaturesMigration(egressFirewall, egressIP, multicast));
  }
  public DefaultNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewDefaultNetworkDefinitionUnsupportedConfigOverrides() {
    return new DefaultNetworkDefinitionUnsupportedConfigOverridesNested(null);
  }
  public DefaultNetworkDefinitionUnsupportedConfigOverridesNested<A> withNewDefaultNetworkDefinitionUnsupportedConfigOverridesLike(DefaultNetworkDefinition item) {
    return new DefaultNetworkDefinitionUnsupportedConfigOverridesNested(item);
  }
  public GCPKMSKeyReferenceUnsupportedConfigOverridesNested<A> withNewGCPKMSKeyReferenceUnsupportedConfigOverrides() {
    return new GCPKMSKeyReferenceUnsupportedConfigOverridesNested(null);
  }
  public GCPKMSKeyReferenceUnsupportedConfigOverridesNested<A> withNewGCPKMSKeyReferenceUnsupportedConfigOverridesLike(GCPKMSKeyReference item) {
    return new GCPKMSKeyReferenceUnsupportedConfigOverridesNested(item);
  }
  public A withNewGCPKMSKeyReferenceUnsupportedConfigOverrides(String keyRing,String location,String name,String projectID) {
    return (A)withUnsupportedConfigOverrides(new GCPKMSKeyReference(keyRing, location, name, projectID));
  }
  public OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerSpecUnsupportedConfigOverrides() {
    return new OpenShiftAPIServerSpecUnsupportedConfigOverridesNested(null);
  }
  public OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerSpecUnsupportedConfigOverridesLike(OpenShiftAPIServerSpec item) {
    return new OpenShiftAPIServerSpecUnsupportedConfigOverridesNested(item);
  }
  public KubeSchedulerStatusUnsupportedConfigOverridesNested<A> withNewKubeSchedulerStatusUnsupportedConfigOverrides() {
    return new KubeSchedulerStatusUnsupportedConfigOverridesNested(null);
  }
  public KubeSchedulerStatusUnsupportedConfigOverridesNested<A> withNewKubeSchedulerStatusUnsupportedConfigOverridesLike(KubeSchedulerStatus item) {
    return new KubeSchedulerStatusUnsupportedConfigOverridesNested(item);
  }
  public SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewSyslogLoggingDestinationParametersUnsupportedConfigOverrides() {
    return new SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested(null);
  }
  public SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<A> withNewSyslogLoggingDestinationParametersUnsupportedConfigOverridesLike(SyslogLoggingDestinationParameters item) {
    return new SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested(item);
  }
  public A withNewSyslogLoggingDestinationParametersUnsupportedConfigOverrides(String address,String facility,Integer maxLength,Integer port) {
    return (A)withUnsupportedConfigOverrides(new SyslogLoggingDestinationParameters(address, facility, maxLength, port));
  }
  public AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides() {
    return new AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested(null);
  }
  public AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<A> withNewAWSNetworkLoadBalancerParametersUnsupportedConfigOverridesLike(AWSNetworkLoadBalancerParameters item) {
    return new AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested(item);
  }
  public ServiceCAListUnsupportedConfigOverridesNested<A> withNewServiceCAListUnsupportedConfigOverrides() {
    return new ServiceCAListUnsupportedConfigOverridesNested(null);
  }
  public ServiceCAListUnsupportedConfigOverridesNested<A> withNewServiceCAListUnsupportedConfigOverridesLike(ServiceCAList item) {
    return new ServiceCAListUnsupportedConfigOverridesNested(item);
  }
  public EtcdStatusUnsupportedConfigOverridesNested<A> withNewEtcdStatusUnsupportedConfigOverrides() {
    return new EtcdStatusUnsupportedConfigOverridesNested(null);
  }
  public EtcdStatusUnsupportedConfigOverridesNested<A> withNewEtcdStatusUnsupportedConfigOverridesLike(EtcdStatus item) {
    return new EtcdStatusUnsupportedConfigOverridesNested(item);
  }
  public StatuspageProviderUnsupportedConfigOverridesNested<A> withNewStatuspageProviderUnsupportedConfigOverrides() {
    return new StatuspageProviderUnsupportedConfigOverridesNested(null);
  }
  public StatuspageProviderUnsupportedConfigOverridesNested<A> withNewStatuspageProviderUnsupportedConfigOverridesLike(StatuspageProvider item) {
    return new StatuspageProviderUnsupportedConfigOverridesNested(item);
  }
  public A withNewStatuspageProviderUnsupportedConfigOverrides(String pageID) {
    return (A)withUnsupportedConfigOverrides(new StatuspageProvider(pageID));
  }
  public KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorStatusUnsupportedConfigOverrides() {
    return new KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested(null);
  }
  public KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<A> withNewKubeStorageVersionMigratorStatusUnsupportedConfigOverridesLike(KubeStorageVersionMigratorStatus item) {
    return new KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested(item);
  }
  public ConsoleProvidersUnsupportedConfigOverridesNested<A> withNewConsoleProvidersUnsupportedConfigOverrides() {
    return new ConsoleProvidersUnsupportedConfigOverridesNested(null);
  }
  public ConsoleProvidersUnsupportedConfigOverridesNested<A> withNewConsoleProvidersUnsupportedConfigOverridesLike(ConsoleProviders item) {
    return new ConsoleProvidersUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerLoggingUnsupportedConfigOverridesNested<A> withNewIngressControllerLoggingUnsupportedConfigOverrides() {
    return new IngressControllerLoggingUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerLoggingUnsupportedConfigOverridesNested<A> withNewIngressControllerLoggingUnsupportedConfigOverridesLike(IngressControllerLogging item) {
    return new IngressControllerLoggingUnsupportedConfigOverridesNested(item);
  }
  public StorageStatusUnsupportedConfigOverridesNested<A> withNewStorageStatusUnsupportedConfigOverrides() {
    return new StorageStatusUnsupportedConfigOverridesNested(null);
  }
  public StorageStatusUnsupportedConfigOverridesNested<A> withNewStorageStatusUnsupportedConfigOverridesLike(StorageStatus item) {
    return new StorageStatusUnsupportedConfigOverridesNested(item);
  }
  public AuthenticationSpecUnsupportedConfigOverridesNested<A> withNewAuthenticationSpecUnsupportedConfigOverrides() {
    return new AuthenticationSpecUnsupportedConfigOverridesNested(null);
  }
  public AuthenticationSpecUnsupportedConfigOverridesNested<A> withNewAuthenticationSpecUnsupportedConfigOverridesLike(AuthenticationSpec item) {
    return new AuthenticationSpecUnsupportedConfigOverridesNested(item);
  }
  public CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverrides() {
    return new CSISnapshotControllerUnsupportedConfigOverridesNested(null);
  }
  public CSISnapshotControllerUnsupportedConfigOverridesNested<A> withNewCSISnapshotControllerUnsupportedConfigOverridesLike(CSISnapshotController item) {
    return new CSISnapshotControllerUnsupportedConfigOverridesNested(item);
  }
  public PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides() {
    return new PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested(null);
  }
  public PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<A> withNewPodNetworkConnectivityCheckSpecUnsupportedConfigOverridesLike(PodNetworkConnectivityCheckSpec item) {
    return new PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested(item);
  }
  public DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogTypesUnsupportedConfigOverrides() {
    return new DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested(null);
  }
  public DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogTypesUnsupportedConfigOverridesLike(DeveloperConsoleCatalogTypes item) {
    return new DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested(item);
  }
  public DNSRecordSpecUnsupportedConfigOverridesNested<A> withNewDNSRecordSpecUnsupportedConfigOverrides() {
    return new DNSRecordSpecUnsupportedConfigOverridesNested(null);
  }
  public DNSRecordSpecUnsupportedConfigOverridesNested<A> withNewDNSRecordSpecUnsupportedConfigOverridesLike(DNSRecordSpec item) {
    return new DNSRecordSpecUnsupportedConfigOverridesNested(item);
  }
  public DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides() {
    return new DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested(null);
  }
  public DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<A> withNewDeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesLike(DeveloperConsoleCatalogCustomization item) {
    return new DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested(item);
  }
  public LoggingDestinationUnsupportedConfigOverridesNested<A> withNewLoggingDestinationUnsupportedConfigOverrides() {
    return new LoggingDestinationUnsupportedConfigOverridesNested(null);
  }
  public LoggingDestinationUnsupportedConfigOverridesNested<A> withNewLoggingDestinationUnsupportedConfigOverridesLike(LoggingDestination item) {
    return new LoggingDestinationUnsupportedConfigOverridesNested(item);
  }
  public IngressControllerTuningOptionsUnsupportedConfigOverridesNested<A> withNewIngressControllerTuningOptionsUnsupportedConfigOverrides() {
    return new IngressControllerTuningOptionsUnsupportedConfigOverridesNested(null);
  }
  public IngressControllerTuningOptionsUnsupportedConfigOverridesNested<A> withNewIngressControllerTuningOptionsUnsupportedConfigOverridesLike(IngressControllerTuningOptions item) {
    return new IngressControllerTuningOptionsUnsupportedConfigOverridesNested(item);
  }
  public StaticIPAMConfigUnsupportedOverridesNested<A> withNewStaticIPAMConfigUnsupportedOverrides() {
    return new StaticIPAMConfigUnsupportedOverridesNested(null);
  }
  public StaticIPAMConfigUnsupportedOverridesNested<A> withNewStaticIPAMConfigUnsupportedOverridesLike(StaticIPAMConfig item) {
    return new StaticIPAMConfigUnsupportedOverridesNested(item);
  }
  public AWSCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewAWSCSIDriverConfigSpecUnsupportedOverrides() {
    return new AWSCSIDriverConfigSpecUnsupportedOverridesNested(null);
  }
  public AWSCSIDriverConfigSpecUnsupportedOverridesNested<A> withNewAWSCSIDriverConfigSpecUnsupportedOverridesLike(AWSCSIDriverConfigSpec item) {
    return new AWSCSIDriverConfigSpecUnsupportedOverridesNested(item);
  }
  public A withNewAWSCSIDriverConfigSpecUnsupportedOverrides(String kmsKeyARN) {
    return (A)withUnsupportedConfigOverrides(new AWSCSIDriverConfigSpec(kmsKeyARN));
  }
  public KubeControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerSpecUnsupportedConfigOverrides() {
    return new KubeControllerManagerSpecUnsupportedConfigOverridesNested(null);
  }
  public KubeControllerManagerSpecUnsupportedConfigOverridesNested<A> withNewKubeControllerManagerSpecUnsupportedConfigOverridesLike(KubeControllerManagerSpec item) {
    return new KubeControllerManagerSpecUnsupportedConfigOverridesNested(item);
  }
  public StaticIPAMDNSUnsupportedConfigOverridesNested<A> withNewStaticIPAMDNSUnsupportedConfigOverrides() {
    return new StaticIPAMDNSUnsupportedConfigOverridesNested(null);
  }
  public StaticIPAMDNSUnsupportedConfigOverridesNested<A> withNewStaticIPAMDNSUnsupportedConfigOverridesLike(StaticIPAMDNS item) {
    return new StaticIPAMDNSUnsupportedConfigOverridesNested(item);
  }
  public StorageSpecUnsupportedConfigOverridesNested<A> withNewStorageSpecUnsupportedConfigOverrides() {
    return new StorageSpecUnsupportedConfigOverridesNested(null);
  }
  public StorageSpecUnsupportedConfigOverridesNested<A> withNewStorageSpecUnsupportedConfigOverridesLike(StorageSpec item) {
    return new StorageSpecUnsupportedConfigOverridesNested(item);
  }
  public NodePlacementUnsupportedConfigOverridesNested<A> withNewNodePlacementUnsupportedConfigOverrides() {
    return new NodePlacementUnsupportedConfigOverridesNested(null);
  }
  public NodePlacementUnsupportedConfigOverridesNested<A> withNewNodePlacementUnsupportedConfigOverridesLike(NodePlacement item) {
    return new NodePlacementUnsupportedConfigOverridesNested(item);
  }
  public NetworkSpecUnsupportedConfigOverridesNested<A> withNewNetworkSpecUnsupportedConfigOverrides() {
    return new NetworkSpecUnsupportedConfigOverridesNested(null);
  }
  public NetworkSpecUnsupportedConfigOverridesNested<A> withNewNetworkSpecUnsupportedConfigOverridesLike(NetworkSpec item) {
    return new NetworkSpecUnsupportedConfigOverridesNested(item);
  }
  public ConsoleStatusUnsupportedConfigOverridesNested<A> withNewConsoleStatusUnsupportedConfigOverrides() {
    return new ConsoleStatusUnsupportedConfigOverridesNested(null);
  }
  public ConsoleStatusUnsupportedConfigOverridesNested<A> withNewConsoleStatusUnsupportedConfigOverridesLike(ConsoleStatus item) {
    return new ConsoleStatusUnsupportedConfigOverridesNested(item);
  }
  public ObjectReferenceUnsupportedConfigOverridesNested<A> withNewObjectReferenceUnsupportedConfigOverrides() {
    return new ObjectReferenceUnsupportedConfigOverridesNested(null);
  }
  public ObjectReferenceUnsupportedConfigOverridesNested<A> withNewObjectReferenceUnsupportedConfigOverridesLike(ObjectReference item) {
    return new ObjectReferenceUnsupportedConfigOverridesNested(item);
  }
  public ServerUnsupportedConfigOverridesNested<A> withNewServerUnsupportedConfigOverrides() {
    return new ServerUnsupportedConfigOverridesNested(null);
  }
  public ServerUnsupportedConfigOverridesNested<A> withNewServerUnsupportedConfigOverridesLike(Server item) {
    return new ServerUnsupportedConfigOverridesNested(item);
  }
  public CloudCredentialSpecUnsupportedConfigOverridesNested<A> withNewCloudCredentialSpecUnsupportedConfigOverrides() {
    return new CloudCredentialSpecUnsupportedConfigOverridesNested(null);
  }
  public CloudCredentialSpecUnsupportedConfigOverridesNested<A> withNewCloudCredentialSpecUnsupportedConfigOverridesLike(CloudCredentialSpec item) {
    return new CloudCredentialSpecUnsupportedConfigOverridesNested(item);
  }
  public DNSRecordStatusUnsupportedConfigOverridesNested<A> withNewDNSRecordStatusUnsupportedConfigOverrides() {
    return new DNSRecordStatusUnsupportedConfigOverridesNested(null);
  }
  public DNSRecordStatusUnsupportedConfigOverridesNested<A> withNewDNSRecordStatusUnsupportedConfigOverridesLike(DNSRecordStatus item) {
    return new DNSRecordStatusUnsupportedConfigOverridesNested(item);
  }
  public ClusterNetworkEntryUnsupportedConfigOverridesNested<A> withNewClusterNetworkEntryUnsupportedConfigOverrides() {
    return new ClusterNetworkEntryUnsupportedConfigOverridesNested(null);
  }
  public ClusterNetworkEntryUnsupportedConfigOverridesNested<A> withNewClusterNetworkEntryUnsupportedConfigOverridesLike(ClusterNetworkEntry item) {
    return new ClusterNetworkEntryUnsupportedConfigOverridesNested(item);
  }
  public A withNewClusterNetworkEntryUnsupportedConfigOverrides(String cidr,Integer hostPrefix) {
    return (A)withUnsupportedConfigOverrides(new ClusterNetworkEntry(cidr, hostPrefix));
  }
  public HTTPCompressionPolicyUnsupportedConfigOverridesNested<A> withNewHTTPCompressionPolicyUnsupportedConfigOverrides() {
    return new HTTPCompressionPolicyUnsupportedConfigOverridesNested(null);
  }
  public HTTPCompressionPolicyUnsupportedConfigOverridesNested<A> withNewHTTPCompressionPolicyUnsupportedConfigOverridesLike(HTTPCompressionPolicy item) {
    return new HTTPCompressionPolicyUnsupportedConfigOverridesNested(item);
  }
  public ProjectAccessUnsupportedConfigOverridesNested<A> withNewProjectAccessUnsupportedConfigOverrides() {
    return new ProjectAccessUnsupportedConfigOverridesNested(null);
  }
  public ProjectAccessUnsupportedConfigOverridesNested<A> withNewProjectAccessUnsupportedConfigOverridesLike(ProjectAccess item) {
    return new ProjectAccessUnsupportedConfigOverridesNested(item);
  }
  public NetFlowConfigUnsupportedOverridesNested<A> withNewNetFlowConfigUnsupportedOverrides() {
    return new NetFlowConfigUnsupportedOverridesNested(null);
  }
  public NetFlowConfigUnsupportedOverridesNested<A> withNewNetFlowConfigUnsupportedOverridesLike(NetFlowConfig item) {
    return new NetFlowConfigUnsupportedOverridesNested(item);
  }
  public GatewayConfigUnsupportedOverridesNested<A> withNewGatewayConfigUnsupportedOverrides() {
    return new GatewayConfigUnsupportedOverridesNested(null);
  }
  public GatewayConfigUnsupportedOverridesNested<A> withNewGatewayConfigUnsupportedOverridesLike(GatewayConfig item) {
    return new GatewayConfigUnsupportedOverridesNested(item);
  }
  public A withNewGatewayConfigUnsupportedOverrides(String ipForwarding,Boolean routingViaHost) {
    return (A)withUnsupportedConfigOverrides(new GatewayConfig(ipForwarding, routingViaHost));
  }
  public PolicyAuditConfigUnsupportedOverridesNested<A> withNewPolicyAuditConfigUnsupportedOverrides() {
    return new PolicyAuditConfigUnsupportedOverridesNested(null);
  }
  public PolicyAuditConfigUnsupportedOverridesNested<A> withNewPolicyAuditConfigUnsupportedOverridesLike(PolicyAuditConfig item) {
    return new PolicyAuditConfigUnsupportedOverridesNested(item);
  }
  public A withNewPolicyAuditConfigUnsupportedOverrides(String destination,Integer maxFileSize,Integer maxLogFiles,Integer rateLimit,String syslogFacility) {
    return (A)withUnsupportedConfigOverrides(new PolicyAuditConfig(destination, maxFileSize, maxLogFiles, rateLimit, syslogFacility));
  }
  public PerspectiveVisibilityUnsupportedConfigOverridesNested<A> withNewPerspectiveVisibilityUnsupportedConfigOverrides() {
    return new PerspectiveVisibilityUnsupportedConfigOverridesNested(null);
  }
  public PerspectiveVisibilityUnsupportedConfigOverridesNested<A> withNewPerspectiveVisibilityUnsupportedConfigOverridesLike(PerspectiveVisibility item) {
    return new PerspectiveVisibilityUnsupportedConfigOverridesNested(item);
  }
  public StaticIPAMAddressesUnsupportedConfigOverridesNested<A> withNewStaticIPAMAddressesUnsupportedConfigOverrides() {
    return new StaticIPAMAddressesUnsupportedConfigOverridesNested(null);
  }
  public StaticIPAMAddressesUnsupportedConfigOverridesNested<A> withNewStaticIPAMAddressesUnsupportedConfigOverridesLike(StaticIPAMAddresses item) {
    return new StaticIPAMAddressesUnsupportedConfigOverridesNested(item);
  }
  public A withNewStaticIPAMAddressesUnsupportedConfigOverrides(String address,String gateway) {
    return (A)withUnsupportedConfigOverrides(new StaticIPAMAddresses(address, gateway));
  }
  public DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverrides() {
    return new DNSRecordUnsupportedConfigOverridesNested(null);
  }
  public DNSRecordUnsupportedConfigOverridesNested<A> withNewDNSRecordUnsupportedConfigOverridesLike(DNSRecord item) {
    return new DNSRecordUnsupportedConfigOverridesNested(item);
  }
  public OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverrides() {
    return new OpenShiftAPIServerUnsupportedConfigOverridesNested(null);
  }
  public OpenShiftAPIServerUnsupportedConfigOverridesNested<A> withNewOpenShiftAPIServerUnsupportedConfigOverridesLike(OpenShiftAPIServer item) {
    return new OpenShiftAPIServerUnsupportedConfigOverridesNested(item);
  }
  public ConsoleSpecUnsupportedConfigOverridesNested<A> withNewConsoleSpecUnsupportedConfigOverrides() {
    return new ConsoleSpecUnsupportedConfigOverridesNested(null);
  }
  public ConsoleSpecUnsupportedConfigOverridesNested<A> withNewConsoleSpecUnsupportedConfigOverridesLike(ConsoleSpec item) {
    return new ConsoleSpecUnsupportedConfigOverridesNested(item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressControllerSpecFluent that = (IngressControllerSpecFluent) o;
    if (!java.util.Objects.equals(clientTLS, that.clientTLS)) return false;

    if (!java.util.Objects.equals(defaultCertificate, that.defaultCertificate)) return false;

    if (!java.util.Objects.equals(domain, that.domain)) return false;

    if (!java.util.Objects.equals(endpointPublishingStrategy, that.endpointPublishingStrategy)) return false;

    if (!java.util.Objects.equals(httpCompression, that.httpCompression)) return false;

    if (!java.util.Objects.equals(httpEmptyRequestsPolicy, that.httpEmptyRequestsPolicy)) return false;

    if (!java.util.Objects.equals(httpErrorCodePages, that.httpErrorCodePages)) return false;

    if (!java.util.Objects.equals(httpHeaders, that.httpHeaders)) return false;

    if (!java.util.Objects.equals(logging, that.logging)) return false;

    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;

    if (!java.util.Objects.equals(nodePlacement, that.nodePlacement)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(routeAdmission, that.routeAdmission)) return false;

    if (!java.util.Objects.equals(routeSelector, that.routeSelector)) return false;

    if (!java.util.Objects.equals(tlsSecurityProfile, that.tlsSecurityProfile)) return false;

    if (!java.util.Objects.equals(tuningOptions, that.tuningOptions)) return false;

    if (!java.util.Objects.equals(unsupportedConfigOverrides, that.unsupportedConfigOverrides)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientTLS,  defaultCertificate,  domain,  endpointPublishingStrategy,  httpCompression,  httpEmptyRequestsPolicy,  httpErrorCodePages,  httpHeaders,  logging,  namespaceSelector,  nodePlacement,  replicas,  routeAdmission,  routeSelector,  tlsSecurityProfile,  tuningOptions,  unsupportedConfigOverrides,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientTLS != null) { sb.append("clientTLS:"); sb.append(clientTLS + ","); }
    if (defaultCertificate != null) { sb.append("defaultCertificate:"); sb.append(defaultCertificate + ","); }
    if (domain != null) { sb.append("domain:"); sb.append(domain + ","); }
    if (endpointPublishingStrategy != null) { sb.append("endpointPublishingStrategy:"); sb.append(endpointPublishingStrategy + ","); }
    if (httpCompression != null) { sb.append("httpCompression:"); sb.append(httpCompression + ","); }
    if (httpEmptyRequestsPolicy != null) { sb.append("httpEmptyRequestsPolicy:"); sb.append(httpEmptyRequestsPolicy + ","); }
    if (httpErrorCodePages != null) { sb.append("httpErrorCodePages:"); sb.append(httpErrorCodePages + ","); }
    if (httpHeaders != null) { sb.append("httpHeaders:"); sb.append(httpHeaders + ","); }
    if (logging != null) { sb.append("logging:"); sb.append(logging + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (nodePlacement != null) { sb.append("nodePlacement:"); sb.append(nodePlacement + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (routeAdmission != null) { sb.append("routeAdmission:"); sb.append(routeAdmission + ","); }
    if (routeSelector != null) { sb.append("routeSelector:"); sb.append(routeSelector + ","); }
    if (tlsSecurityProfile != null) { sb.append("tlsSecurityProfile:"); sb.append(tlsSecurityProfile + ","); }
    if (tuningOptions != null) { sb.append("tuningOptions:"); sb.append(tuningOptions + ","); }
    if (unsupportedConfigOverrides != null) { sb.append("unsupportedConfigOverrides:"); sb.append(unsupportedConfigOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogAPIServerList": return (VisitableBuilder<T, ?>)new ServiceCatalogAPIServerListBuilder((ServiceCatalogAPIServerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ImagePruner": return (VisitableBuilder<T, ?>)new ImagePrunerBuilder((ImagePruner) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeControllerManager": return (VisitableBuilder<T, ?>)new KubeControllerManagerBuilder((KubeControllerManager) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheckStatus": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckStatusBuilder((PodNetworkConnectivityCheckStatus) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateSpec": return (VisitableBuilder<T, ?>)new PodTemplateSpecBuilder((PodTemplateSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeControllerManagerStatus": return (VisitableBuilder<T, ?>)new KubeControllerManagerStatusBuilder((KubeControllerManagerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSISnapshotControllerStatus": return (VisitableBuilder<T, ?>)new CSISnapshotControllerStatusBuilder((CSISnapshotControllerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IPsecConfig": return (VisitableBuilder<T, ?>)new IPsecConfigBuilder((IPsecConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1alpha1."+"ImageContentSourcePolicy": return (VisitableBuilder<T, ?>)new ImageContentSourcePolicyBuilder((ImageContentSourcePolicy) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceRequirements": return (VisitableBuilder<T, ?>)new ResourceRequirementsBuilder((ResourceRequirements) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeStorageVersionMigratorSpec": return (VisitableBuilder<T, ?>)new KubeStorageVersionMigratorSpecBuilder((KubeStorageVersionMigratorSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftSDNConfig": return (VisitableBuilder<T, ?>)new OpenShiftSDNConfigBuilder((OpenShiftSDNConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerHTTPHeaders": return (VisitableBuilder<T, ?>)new IngressControllerHTTPHeadersBuilder((IngressControllerHTTPHeaders) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleList": return (VisitableBuilder<T, ?>)new ConsoleListBuilder((ConsoleList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceAccountIssuerStatus": return (VisitableBuilder<T, ?>)new ServiceAccountIssuerStatusBuilder((ServiceAccountIssuerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DeveloperConsoleCatalogCategory": return (VisitableBuilder<T, ?>)new DeveloperConsoleCatalogCategoryBuilder((DeveloperConsoleCatalogCategory) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftControllerManagerSpec": return (VisitableBuilder<T, ?>)new OpenShiftControllerManagerSpecBuilder((OpenShiftControllerManagerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ExportNetworkFlows": return (VisitableBuilder<T, ?>)new ExportNetworkFlowsBuilder((ExportNetworkFlows) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterCSIDriverSpec": return (VisitableBuilder<T, ?>)new ClusterCSIDriverSpecBuilder((ClusterCSIDriverSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1alpha1."+"RepositoryDigestMirrors": return (VisitableBuilder<T, ?>)new RepositoryDigestMirrorsBuilder((RepositoryDigestMirrors) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleCustomization": return (VisitableBuilder<T, ?>)new ConsoleCustomizationBuilder((ConsoleCustomization) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSISnapshotControllerSpec": return (VisitableBuilder<T, ?>)new CSISnapshotControllerSpecBuilder((CSISnapshotControllerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"UpstreamResolvers": return (VisitableBuilder<T, ?>)new UpstreamResolversBuilder((UpstreamResolvers) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerHTTPUniqueIdHeaderPolicy": return (VisitableBuilder<T, ?>)new IngressControllerHTTPUniqueIdHeaderPolicyBuilder((IngressControllerHTTPUniqueIdHeaderPolicy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"MTUMigrationValues": return (VisitableBuilder<T, ?>)new MTUMigrationValuesBuilder((MTUMigrationValues) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConfigStatus": return (VisitableBuilder<T, ?>)new ConfigStatusBuilder((ConfigStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"VSphereCSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new VSphereCSIDriverConfigSpecBuilder((VSphereCSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCA": return (VisitableBuilder<T, ?>)new ServiceCABuilder((ServiceCA) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogControllerManagerSpec": return (VisitableBuilder<T, ?>)new ServiceCatalogControllerManagerSpecBuilder((ServiceCatalogControllerManagerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerList": return (VisitableBuilder<T, ?>)new IngressControllerListBuilder((IngressControllerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSList": return (VisitableBuilder<T, ?>)new DNSListBuilder((DNSList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeAPIServerStatus": return (VisitableBuilder<T, ?>)new KubeAPIServerStatusBuilder((KubeAPIServerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AWSClassicLoadBalancerParameters": return (VisitableBuilder<T, ?>)new AWSClassicLoadBalancerParametersBuilder((AWSClassicLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeAPIServer": return (VisitableBuilder<T, ?>)new KubeAPIServerBuilder((KubeAPIServer) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressController": return (VisitableBuilder<T, ?>)new IngressControllerBuilder((IngressController) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleConfigRoute": return (VisitableBuilder<T, ?>)new ConsoleConfigRouteBuilder((ConsoleConfigRoute) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CloudCredentialStatus": return (VisitableBuilder<T, ?>)new CloudCredentialStatusBuilder((CloudCredentialStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeStorageVersionMigrator": return (VisitableBuilder<T, ?>)new KubeStorageVersionMigratorBuilder((KubeStorageVersionMigrator) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerStatus": return (VisitableBuilder<T, ?>)new IngressControllerStatusBuilder((IngressControllerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogControllerManagerStatus": return (VisitableBuilder<T, ?>)new ServiceCatalogControllerManagerStatusBuilder((ServiceCatalogControllerManagerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ImagePrunerList": return (VisitableBuilder<T, ?>)new ImagePrunerListBuilder((ImagePrunerList) item);
    case "io.fabric8.kubernetes.api.model."+"LocalObjectReference": return (VisitableBuilder<T, ?>)new LocalObjectReferenceBuilder((LocalObjectReference) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StaticIPAMRoutes": return (VisitableBuilder<T, ?>)new StaticIPAMRoutesBuilder((StaticIPAMRoutes) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ContainerLoggingDestinationParameters": return (VisitableBuilder<T, ?>)new ContainerLoggingDestinationParametersBuilder((ContainerLoggingDestinationParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeSchedulerList": return (VisitableBuilder<T, ?>)new KubeSchedulerListBuilder((KubeSchedulerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeAPIServerSpec": return (VisitableBuilder<T, ?>)new KubeAPIServerSpecBuilder((KubeAPIServerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftControllerManager": return (VisitableBuilder<T, ?>)new OpenShiftControllerManagerBuilder((OpenShiftControllerManager) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EndpointPublishingStrategy": return (VisitableBuilder<T, ?>)new EndpointPublishingStrategyBuilder((EndpointPublishingStrategy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CloudCredential": return (VisitableBuilder<T, ?>)new CloudCredentialBuilder((CloudCredential) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeScheduler": return (VisitableBuilder<T, ?>)new KubeSchedulerBuilder((KubeScheduler) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterCSIDriverStatus": return (VisitableBuilder<T, ?>)new ClusterCSIDriverStatusBuilder((ClusterCSIDriverStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"SFlowConfig": return (VisitableBuilder<T, ?>)new SFlowConfigBuilder((SFlowConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ForwardPlugin": return (VisitableBuilder<T, ?>)new ForwardPluginBuilder((ForwardPlugin) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"LogEntry": return (VisitableBuilder<T, ?>)new LogEntryBuilder((LogEntry) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AdditionalNetworkDefinition": return (VisitableBuilder<T, ?>)new AdditionalNetworkDefinitionBuilder((AdditionalNetworkDefinition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AuthenticationStatus": return (VisitableBuilder<T, ?>)new AuthenticationStatusBuilder((AuthenticationStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NodePortStrategy": return (VisitableBuilder<T, ?>)new NodePortStrategyBuilder((NodePortStrategy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Network": return (VisitableBuilder<T, ?>)new NetworkBuilder((Network) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClientTLS": return (VisitableBuilder<T, ?>)new ClientTLSBuilder((ClientTLS) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ImagePrunerStatus": return (VisitableBuilder<T, ?>)new ImagePrunerStatusBuilder((ImagePrunerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Upstream": return (VisitableBuilder<T, ?>)new UpstreamBuilder((Upstream) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AzureDiskEncryptionSet": return (VisitableBuilder<T, ?>)new AzureDiskEncryptionSetBuilder((AzureDiskEncryptionSet) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogAPIServer": return (VisitableBuilder<T, ?>)new ServiceCatalogAPIServerBuilder((ServiceCatalogAPIServer) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new CSIDriverConfigSpecBuilder((CSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerCaptureHTTPHeader": return (VisitableBuilder<T, ?>)new IngressControllerCaptureHTTPHeaderBuilder((IngressControllerCaptureHTTPHeader) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetworkMigration": return (VisitableBuilder<T, ?>)new NetworkMigrationBuilder((NetworkMigration) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSRecordList": return (VisitableBuilder<T, ?>)new DNSRecordListBuilder((DNSRecordList) item);
    case "io.fabric8.kubernetes.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new RawExtensionBuilder((RawExtension) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EtcdSpec": return (VisitableBuilder<T, ?>)new EtcdSpecBuilder((EtcdSpec) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheck": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckBuilder((PodNetworkConnectivityCheck) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftAPIServerStatus": return (VisitableBuilder<T, ?>)new OpenShiftAPIServerStatusBuilder((OpenShiftAPIServerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"LoadBalancerStrategy": return (VisitableBuilder<T, ?>)new LoadBalancerStrategyBuilder((LoadBalancerStrategy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSOverTLSConfig": return (VisitableBuilder<T, ?>)new DNSOverTLSConfigBuilder((DNSOverTLSConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CloudCredentialList": return (VisitableBuilder<T, ?>)new CloudCredentialListBuilder((CloudCredentialList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSCache": return (VisitableBuilder<T, ?>)new DNSCacheBuilder((DNSCache) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ImagePrunerSpec": return (VisitableBuilder<T, ?>)new ImagePrunerSpecBuilder((ImagePrunerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConfigList": return (VisitableBuilder<T, ?>)new ConfigListBuilder((ConfigList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AuthenticationList": return (VisitableBuilder<T, ?>)new AuthenticationListBuilder((AuthenticationList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"PinnedResourceReference": return (VisitableBuilder<T, ?>)new PinnedResourceReferenceBuilder((PinnedResourceReference) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeControllerManagerList": return (VisitableBuilder<T, ?>)new KubeControllerManagerListBuilder((KubeControllerManagerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IPAMConfig": return (VisitableBuilder<T, ?>)new IPAMConfigBuilder((IPAMConfig) item);
    case "io.fabric8.kubernetes.api.model."+"Container": return (VisitableBuilder<T, ?>)new ContainerBuilder((Container) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IBMLoadBalancerParameters": return (VisitableBuilder<T, ?>)new IBMLoadBalancerParametersBuilder((IBMLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AccessLogging": return (VisitableBuilder<T, ?>)new AccessLoggingBuilder((AccessLogging) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"HostNetworkStrategy": return (VisitableBuilder<T, ?>)new HostNetworkStrategyBuilder((HostNetworkStrategy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeSchedulerSpec": return (VisitableBuilder<T, ?>)new KubeSchedulerSpecBuilder((KubeSchedulerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1alpha1."+"ImageContentSourcePolicyList": return (VisitableBuilder<T, ?>)new ImageContentSourcePolicyListBuilder((ImageContentSourcePolicyList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftControllerManagerStatus": return (VisitableBuilder<T, ?>)new OpenShiftControllerManagerStatusBuilder((OpenShiftControllerManagerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogAPIServerStatus": return (VisitableBuilder<T, ?>)new ServiceCatalogAPIServerStatusBuilder((ServiceCatalogAPIServerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSNodePlacement": return (VisitableBuilder<T, ?>)new DNSNodePlacementBuilder((DNSNodePlacement) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetworkList": return (VisitableBuilder<T, ?>)new NetworkListBuilder((NetworkList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ProviderLoadBalancerParameters": return (VisitableBuilder<T, ?>)new ProviderLoadBalancerParametersBuilder((ProviderLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ResourceAttributesAccessReview": return (VisitableBuilder<T, ?>)new ResourceAttributesAccessReviewBuilder((ResourceAttributesAccessReview) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCASpec": return (VisitableBuilder<T, ?>)new ServiceCASpecBuilder((ServiceCASpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"PrivateStrategy": return (VisitableBuilder<T, ?>)new PrivateStrategyBuilder((PrivateStrategy) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheckList": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckListBuilder((PodNetworkConnectivityCheckList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftAPIServerList": return (VisitableBuilder<T, ?>)new OpenShiftAPIServerListBuilder((OpenShiftAPIServerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OAuthAPIServerStatus": return (VisitableBuilder<T, ?>)new OAuthAPIServerStatusBuilder((OAuthAPIServerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GCPCSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new GCPCSIDriverConfigSpecBuilder((GCPCSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogControllerManager": return (VisitableBuilder<T, ?>)new ServiceCatalogControllerManagerBuilder((ServiceCatalogControllerManager) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerCaptureHTTPCookie": return (VisitableBuilder<T, ?>)new IngressControllerCaptureHTTPCookieBuilder((IngressControllerCaptureHTTPCookie) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNS": return (VisitableBuilder<T, ?>)new DNSBuilder((DNS) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AddPage": return (VisitableBuilder<T, ?>)new AddPageBuilder((AddPage) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AzureCSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new AzureCSIDriverConfigSpecBuilder((AzureCSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StorageList": return (VisitableBuilder<T, ?>)new StorageListBuilder((StorageList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Authentication": return (VisitableBuilder<T, ?>)new AuthenticationBuilder((Authentication) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCAStatus": return (VisitableBuilder<T, ?>)new ServiceCAStatusBuilder((ServiceCAStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Perspective": return (VisitableBuilder<T, ?>)new PerspectiveBuilder((Perspective) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"MTUMigration": return (VisitableBuilder<T, ?>)new MTUMigrationBuilder((MTUMigration) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelector": return (VisitableBuilder<T, ?>)new LabelSelectorBuilder((LabelSelector) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeStorageVersionMigratorList": return (VisitableBuilder<T, ?>)new KubeStorageVersionMigratorListBuilder((KubeStorageVersionMigratorList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Storage": return (VisitableBuilder<T, ?>)new StorageBuilder((Storage) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogControllerManagerList": return (VisitableBuilder<T, ?>)new ServiceCatalogControllerManagerListBuilder((ServiceCatalogControllerManagerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OVNKubernetesConfig": return (VisitableBuilder<T, ?>)new OVNKubernetesConfigBuilder((OVNKubernetesConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DeveloperConsoleCatalogCategoryMeta": return (VisitableBuilder<T, ?>)new DeveloperConsoleCatalogCategoryMetaBuilder((DeveloperConsoleCatalogCategoryMeta) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerSpec": return (VisitableBuilder<T, ?>)new IngressControllerSpecBuilder((IngressControllerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSSpec": return (VisitableBuilder<T, ?>)new DNSSpecBuilder((DNSSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OperatorCondition": return (VisitableBuilder<T, ?>)new OperatorConditionBuilder((OperatorCondition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ProxyConfig": return (VisitableBuilder<T, ?>)new ProxyConfigBuilder((ProxyConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KuryrConfig": return (VisitableBuilder<T, ?>)new KuryrConfigBuilder((KuryrConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCatalogAPIServerSpec": return (VisitableBuilder<T, ?>)new ServiceCatalogAPIServerSpecBuilder((ServiceCatalogAPIServerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1alpha1."+"ImageContentSourcePolicySpec": return (VisitableBuilder<T, ?>)new ImageContentSourcePolicySpecBuilder((ImageContentSourcePolicySpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSStatus": return (VisitableBuilder<T, ?>)new DNSStatusBuilder((DNSStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSTransportConfig": return (VisitableBuilder<T, ?>)new DNSTransportConfigBuilder((DNSTransportConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GCPLoadBalancerParameters": return (VisitableBuilder<T, ?>)new GCPLoadBalancerParametersBuilder((GCPLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeAPIServerList": return (VisitableBuilder<T, ?>)new KubeAPIServerListBuilder((KubeAPIServerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Config": return (VisitableBuilder<T, ?>)new ConfigBuilder((Config) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectMeta": return (VisitableBuilder<T, ?>)new ObjectMetaBuilder((ObjectMeta) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterCSIDriverList": return (VisitableBuilder<T, ?>)new ClusterCSIDriverListBuilder((ClusterCSIDriverList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"SimpleMacvlanConfig": return (VisitableBuilder<T, ?>)new SimpleMacvlanConfigBuilder((SimpleMacvlanConfig) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EgressIPConfig": return (VisitableBuilder<T, ?>)new EgressIPConfigBuilder((EgressIPConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"HybridOverlayConfig": return (VisitableBuilder<T, ?>)new HybridOverlayConfigBuilder((HybridOverlayConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AWSLoadBalancerParameters": return (VisitableBuilder<T, ?>)new AWSLoadBalancerParametersBuilder((AWSLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSISnapshotControllerList": return (VisitableBuilder<T, ?>)new CSISnapshotControllerListBuilder((CSISnapshotControllerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Console": return (VisitableBuilder<T, ?>)new ConsoleBuilder((Console) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSZoneCondition": return (VisitableBuilder<T, ?>)new DNSZoneConditionBuilder((DNSZoneCondition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterCSIDriver": return (VisitableBuilder<T, ?>)new ClusterCSIDriverBuilder((ClusterCSIDriver) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"QuickStarts": return (VisitableBuilder<T, ?>)new QuickStartsBuilder((QuickStarts) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSZoneStatus": return (VisitableBuilder<T, ?>)new DNSZoneStatusBuilder((DNSZoneStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConfigSpec": return (VisitableBuilder<T, ?>)new ConfigSpecBuilder((ConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"OutageEntry": return (VisitableBuilder<T, ?>)new OutageEntryBuilder((OutageEntry) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftControllerManagerList": return (VisitableBuilder<T, ?>)new OpenShiftControllerManagerListBuilder((OpenShiftControllerManagerList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Etcd": return (VisitableBuilder<T, ?>)new EtcdBuilder((Etcd) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IPFIXConfig": return (VisitableBuilder<T, ?>)new IPFIXConfigBuilder((IPFIXConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetworkStatus": return (VisitableBuilder<T, ?>)new NetworkStatusBuilder((NetworkStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NodeStatus": return (VisitableBuilder<T, ?>)new NodeStatusBuilder((NodeStatus) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheckCondition": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckConditionBuilder((PodNetworkConnectivityCheckCondition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"RouteAdmissionPolicy": return (VisitableBuilder<T, ?>)new RouteAdmissionPolicyBuilder((RouteAdmissionPolicy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GenerationStatus": return (VisitableBuilder<T, ?>)new GenerationStatusBuilder((GenerationStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerCaptureHTTPHeaders": return (VisitableBuilder<T, ?>)new IngressControllerCaptureHTTPHeadersBuilder((IngressControllerCaptureHTTPHeaders) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EtcdList": return (VisitableBuilder<T, ?>)new EtcdListBuilder((EtcdList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"FeaturesMigration": return (VisitableBuilder<T, ?>)new FeaturesMigrationBuilder((FeaturesMigration) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DefaultNetworkDefinition": return (VisitableBuilder<T, ?>)new DefaultNetworkDefinitionBuilder((DefaultNetworkDefinition) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GCPKMSKeyReference": return (VisitableBuilder<T, ?>)new GCPKMSKeyReferenceBuilder((GCPKMSKeyReference) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftAPIServerSpec": return (VisitableBuilder<T, ?>)new OpenShiftAPIServerSpecBuilder((OpenShiftAPIServerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeSchedulerStatus": return (VisitableBuilder<T, ?>)new KubeSchedulerStatusBuilder((KubeSchedulerStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"SyslogLoggingDestinationParameters": return (VisitableBuilder<T, ?>)new SyslogLoggingDestinationParametersBuilder((SyslogLoggingDestinationParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AWSNetworkLoadBalancerParameters": return (VisitableBuilder<T, ?>)new AWSNetworkLoadBalancerParametersBuilder((AWSNetworkLoadBalancerParameters) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ServiceCAList": return (VisitableBuilder<T, ?>)new ServiceCAListBuilder((ServiceCAList) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"EtcdStatus": return (VisitableBuilder<T, ?>)new EtcdStatusBuilder((EtcdStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StatuspageProvider": return (VisitableBuilder<T, ?>)new StatuspageProviderBuilder((StatuspageProvider) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeStorageVersionMigratorStatus": return (VisitableBuilder<T, ?>)new KubeStorageVersionMigratorStatusBuilder((KubeStorageVersionMigratorStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleProviders": return (VisitableBuilder<T, ?>)new ConsoleProvidersBuilder((ConsoleProviders) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerLogging": return (VisitableBuilder<T, ?>)new IngressControllerLoggingBuilder((IngressControllerLogging) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StorageStatus": return (VisitableBuilder<T, ?>)new StorageStatusBuilder((StorageStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AuthenticationSpec": return (VisitableBuilder<T, ?>)new AuthenticationSpecBuilder((AuthenticationSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CSISnapshotController": return (VisitableBuilder<T, ?>)new CSISnapshotControllerBuilder((CSISnapshotController) item);
    case "io.fabric8.openshift.api.model.operator.controlplane.v1alpha1."+"PodNetworkConnectivityCheckSpec": return (VisitableBuilder<T, ?>)new PodNetworkConnectivityCheckSpecBuilder((PodNetworkConnectivityCheckSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DeveloperConsoleCatalogTypes": return (VisitableBuilder<T, ?>)new DeveloperConsoleCatalogTypesBuilder((DeveloperConsoleCatalogTypes) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSRecordSpec": return (VisitableBuilder<T, ?>)new DNSRecordSpecBuilder((DNSRecordSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DeveloperConsoleCatalogCustomization": return (VisitableBuilder<T, ?>)new DeveloperConsoleCatalogCustomizationBuilder((DeveloperConsoleCatalogCustomization) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"LoggingDestination": return (VisitableBuilder<T, ?>)new LoggingDestinationBuilder((LoggingDestination) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"IngressControllerTuningOptions": return (VisitableBuilder<T, ?>)new IngressControllerTuningOptionsBuilder((IngressControllerTuningOptions) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StaticIPAMConfig": return (VisitableBuilder<T, ?>)new StaticIPAMConfigBuilder((StaticIPAMConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"AWSCSIDriverConfigSpec": return (VisitableBuilder<T, ?>)new AWSCSIDriverConfigSpecBuilder((AWSCSIDriverConfigSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"KubeControllerManagerSpec": return (VisitableBuilder<T, ?>)new KubeControllerManagerSpecBuilder((KubeControllerManagerSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StaticIPAMDNS": return (VisitableBuilder<T, ?>)new StaticIPAMDNSBuilder((StaticIPAMDNS) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StorageSpec": return (VisitableBuilder<T, ?>)new StorageSpecBuilder((StorageSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NodePlacement": return (VisitableBuilder<T, ?>)new NodePlacementBuilder((NodePlacement) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetworkSpec": return (VisitableBuilder<T, ?>)new NetworkSpecBuilder((NetworkSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleStatus": return (VisitableBuilder<T, ?>)new ConsoleStatusBuilder((ConsoleStatus) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectReference": return (VisitableBuilder<T, ?>)new ObjectReferenceBuilder((ObjectReference) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"Server": return (VisitableBuilder<T, ?>)new ServerBuilder((Server) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"CloudCredentialSpec": return (VisitableBuilder<T, ?>)new CloudCredentialSpecBuilder((CloudCredentialSpec) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSRecordStatus": return (VisitableBuilder<T, ?>)new DNSRecordStatusBuilder((DNSRecordStatus) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ClusterNetworkEntry": return (VisitableBuilder<T, ?>)new ClusterNetworkEntryBuilder((ClusterNetworkEntry) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"HTTPCompressionPolicy": return (VisitableBuilder<T, ?>)new HTTPCompressionPolicyBuilder((HTTPCompressionPolicy) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ProjectAccess": return (VisitableBuilder<T, ?>)new ProjectAccessBuilder((ProjectAccess) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"NetFlowConfig": return (VisitableBuilder<T, ?>)new NetFlowConfigBuilder((NetFlowConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"GatewayConfig": return (VisitableBuilder<T, ?>)new GatewayConfigBuilder((GatewayConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"PolicyAuditConfig": return (VisitableBuilder<T, ?>)new PolicyAuditConfigBuilder((PolicyAuditConfig) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"PerspectiveVisibility": return (VisitableBuilder<T, ?>)new PerspectiveVisibilityBuilder((PerspectiveVisibility) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"StaticIPAMAddresses": return (VisitableBuilder<T, ?>)new StaticIPAMAddressesBuilder((StaticIPAMAddresses) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"DNSRecord": return (VisitableBuilder<T, ?>)new DNSRecordBuilder((DNSRecord) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"OpenShiftAPIServer": return (VisitableBuilder<T, ?>)new OpenShiftAPIServerBuilder((OpenShiftAPIServer) item);
    case "io.fabric8.openshift.api.model.operator.v1."+"ConsoleSpec": return (VisitableBuilder<T, ?>)new ConsoleSpecBuilder((ConsoleSpec) item);
    }
 return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class ClientTLSNested<N> extends ClientTLSFluent<ClientTLSNested<N>> implements Nested<N>{
    ClientTLSNested(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withClientTLS(builder.build());
    }
    public N endClientTLS() {
      return and();
    }
    
  }
  public class DefaultCertificateNested<N> extends LocalObjectReferenceFluent<DefaultCertificateNested<N>> implements Nested<N>{
    DefaultCertificateNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withDefaultCertificate(builder.build());
    }
    public N endDefaultCertificate() {
      return and();
    }
    
  }
  public class EndpointPublishingStrategyNested<N> extends EndpointPublishingStrategyFluent<EndpointPublishingStrategyNested<N>> implements Nested<N>{
    EndpointPublishingStrategyNested(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withEndpointPublishingStrategy(builder.build());
    }
    public N endEndpointPublishingStrategy() {
      return and();
    }
    
  }
  public class HttpCompressionNested<N> extends HTTPCompressionPolicyFluent<HttpCompressionNested<N>> implements Nested<N>{
    HttpCompressionNested(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HTTPCompressionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withHttpCompression(builder.build());
    }
    public N endHttpCompression() {
      return and();
    }
    
  }
  public class HttpHeadersNested<N> extends IngressControllerHTTPHeadersFluent<HttpHeadersNested<N>> implements Nested<N>{
    HttpHeadersNested(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    IngressControllerHTTPHeadersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withHttpHeaders(builder.build());
    }
    public N endHttpHeaders() {
      return and();
    }
    
  }
  public class LoggingNested<N> extends IngressControllerLoggingFluent<LoggingNested<N>> implements Nested<N>{
    LoggingNested(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    IngressControllerLoggingBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withLogging(builder.build());
    }
    public N endLogging() {
      return and();
    }
    
  }
  public class NamespaceSelectorNested<N> extends LabelSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  public class NodePlacementNested<N> extends NodePlacementFluent<NodePlacementNested<N>> implements Nested<N>{
    NodePlacementNested(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withNodePlacement(builder.build());
    }
    public N endNodePlacement() {
      return and();
    }
    
  }
  public class RouteAdmissionNested<N> extends RouteAdmissionPolicyFluent<RouteAdmissionNested<N>> implements Nested<N>{
    RouteAdmissionNested(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withRouteAdmission(builder.build());
    }
    public N endRouteAdmission() {
      return and();
    }
    
  }
  public class RouteSelectorNested<N> extends LabelSelectorFluent<RouteSelectorNested<N>> implements Nested<N>{
    RouteSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withRouteSelector(builder.build());
    }
    public N endRouteSelector() {
      return and();
    }
    
  }
  public class TuningOptionsNested<N> extends IngressControllerTuningOptionsFluent<TuningOptionsNested<N>> implements Nested<N>{
    TuningOptionsNested(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    IngressControllerTuningOptionsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withTuningOptions(builder.build());
    }
    public N endTuningOptions() {
      return and();
    }
    
  }
  public class ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<N> extends ServiceCatalogAPIServerListFluent<ServiceCatalogAPIServerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerListUnsupportedConfigOverridesNested(ServiceCatalogAPIServerList item) {
      this.builder = new ServiceCatalogAPIServerListBuilder(this, item);
    }
    ServiceCatalogAPIServerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ImagePrunerUnsupportedConfigOverridesNested<N> extends ImagePrunerFluent<ImagePrunerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImagePrunerUnsupportedConfigOverridesNested(ImagePruner item) {
      this.builder = new ImagePrunerBuilder(this, item);
    }
    ImagePrunerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeControllerManagerUnsupportedConfigOverridesNested<N> extends KubeControllerManagerFluent<KubeControllerManagerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeControllerManagerUnsupportedConfigOverridesNested(KubeControllerManager item) {
      this.builder = new KubeControllerManagerBuilder(this, item);
    }
    KubeControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckStatusFluent<PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckStatusUnsupportedConfigOverridesNested(PodNetworkConnectivityCheckStatus item) {
      this.builder = new PodNetworkConnectivityCheckStatusBuilder(this, item);
    }
    PodNetworkConnectivityCheckStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PodTemplateSpecUnsupportedConfigOverridesNested<N> extends PodTemplateSpecFluent<PodTemplateSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodTemplateSpecUnsupportedConfigOverridesNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodTemplateSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeControllerManagerStatusUnsupportedConfigOverridesNested<N> extends KubeControllerManagerStatusFluent<KubeControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeControllerManagerStatusUnsupportedConfigOverridesNested(KubeControllerManagerStatus item) {
      this.builder = new KubeControllerManagerStatusBuilder(this, item);
    }
    KubeControllerManagerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CSISnapshotControllerStatusUnsupportedConfigOverridesNested<N> extends CSISnapshotControllerStatusFluent<CSISnapshotControllerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CSISnapshotControllerStatusUnsupportedConfigOverridesNested(CSISnapshotControllerStatus item) {
      this.builder = new CSISnapshotControllerStatusBuilder(this, item);
    }
    CSISnapshotControllerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IPsecConfigUnsupportedOverridesNested<N> extends IPsecConfigFluent<IPsecConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    IPsecConfigUnsupportedOverridesNested(IPsecConfig item) {
      this.builder = new IPsecConfigBuilder(this, item);
    }
    IPsecConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPsecConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class ImageContentSourcePolicyUnsupportedConfigOverridesNested<N> extends ImageContentSourcePolicyFluent<ImageContentSourcePolicyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImageContentSourcePolicyUnsupportedConfigOverridesNested(ImageContentSourcePolicy item) {
      this.builder = new ImageContentSourcePolicyBuilder(this, item);
    }
    ImageContentSourcePolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ResourceRequirementsUnsupportedConfigOverridesNested<N> extends ResourceRequirementsFluent<ResourceRequirementsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ResourceRequirementsUnsupportedConfigOverridesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endResourceRequirementsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<N> extends KubeStorageVersionMigratorSpecFluent<KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorSpecUnsupportedConfigOverridesNested(KubeStorageVersionMigratorSpec item) {
      this.builder = new KubeStorageVersionMigratorSpecBuilder(this, item);
    }
    KubeStorageVersionMigratorSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftSDNConfigUnsupportedOverridesNested<N> extends OpenShiftSDNConfigFluent<OpenShiftSDNConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    OpenShiftSDNConfigUnsupportedOverridesNested(OpenShiftSDNConfig item) {
      this.builder = new OpenShiftSDNConfigBuilder(this, item);
    }
    OpenShiftSDNConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftSDNConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<N> extends IngressControllerHTTPHeadersFluent<IngressControllerHTTPHeadersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerHTTPHeadersUnsupportedConfigOverridesNested(IngressControllerHTTPHeaders item) {
      this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
    }
    IngressControllerHTTPHeadersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerHTTPHeadersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConsoleListUnsupportedConfigOverridesNested<N> extends ConsoleListFluent<ConsoleListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleListUnsupportedConfigOverridesNested(ConsoleList item) {
      this.builder = new ConsoleListBuilder(this, item);
    }
    ConsoleListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceAccountIssuerStatusUnsupportedConfigOverridesNested<N> extends ServiceAccountIssuerStatusFluent<ServiceAccountIssuerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceAccountIssuerStatusUnsupportedConfigOverridesNested(ServiceAccountIssuerStatus item) {
      this.builder = new ServiceAccountIssuerStatusBuilder(this, item);
    }
    ServiceAccountIssuerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceAccountIssuerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<N> extends DeveloperConsoleCatalogCategoryFluent<DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCategoryUnsupportedConfigOverridesNested(DeveloperConsoleCatalogCategory item) {
      this.builder = new DeveloperConsoleCatalogCategoryBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCategoryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<N> extends OpenShiftControllerManagerSpecFluent<OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftControllerManagerSpecUnsupportedConfigOverridesNested(OpenShiftControllerManagerSpec item) {
      this.builder = new OpenShiftControllerManagerSpecBuilder(this, item);
    }
    OpenShiftControllerManagerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ExportNetworkFlowsUnsupportedConfigOverridesNested<N> extends ExportNetworkFlowsFluent<ExportNetworkFlowsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ExportNetworkFlowsUnsupportedConfigOverridesNested(ExportNetworkFlows item) {
      this.builder = new ExportNetworkFlowsBuilder(this, item);
    }
    ExportNetworkFlowsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endExportNetworkFlowsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ClusterCSIDriverSpecUnsupportedConfigOverridesNested<N> extends ClusterCSIDriverSpecFluent<ClusterCSIDriverSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterCSIDriverSpecUnsupportedConfigOverridesNested(ClusterCSIDriverSpec item) {
      this.builder = new ClusterCSIDriverSpecBuilder(this, item);
    }
    ClusterCSIDriverSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class RepositoryDigestMirrorsUnsupportedConfigOverridesNested<N> extends RepositoryDigestMirrorsFluent<RepositoryDigestMirrorsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    RepositoryDigestMirrorsUnsupportedConfigOverridesNested(RepositoryDigestMirrors item) {
      this.builder = new RepositoryDigestMirrorsBuilder(this, item);
    }
    RepositoryDigestMirrorsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRepositoryDigestMirrorsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConsoleCustomizationUnsupportedConfigOverridesNested<N> extends ConsoleCustomizationFluent<ConsoleCustomizationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleCustomizationUnsupportedConfigOverridesNested(ConsoleCustomization item) {
      this.builder = new ConsoleCustomizationBuilder(this, item);
    }
    ConsoleCustomizationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleCustomizationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CSISnapshotControllerSpecUnsupportedConfigOverridesNested<N> extends CSISnapshotControllerSpecFluent<CSISnapshotControllerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CSISnapshotControllerSpecUnsupportedConfigOverridesNested(CSISnapshotControllerSpec item) {
      this.builder = new CSISnapshotControllerSpecBuilder(this, item);
    }
    CSISnapshotControllerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class UpstreamResolversUnsupportedConfigOverridesNested<N> extends UpstreamResolversFluent<UpstreamResolversUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    UpstreamResolversUnsupportedConfigOverridesNested(UpstreamResolvers item) {
      this.builder = new UpstreamResolversBuilder(this, item);
    }
    UpstreamResolversBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endUpstreamResolversUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<N> extends IngressControllerHTTPUniqueIdHeaderPolicyFluent<IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverridesNested(IngressControllerHTTPUniqueIdHeaderPolicy item) {
      this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
    }
    IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerHTTPUniqueIdHeaderPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class MTUMigrationValuesUnsupportedConfigOverridesNested<N> extends MTUMigrationValuesFluent<MTUMigrationValuesUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    MTUMigrationValuesUnsupportedConfigOverridesNested(MTUMigrationValues item) {
      this.builder = new MTUMigrationValuesBuilder(this, item);
    }
    MTUMigrationValuesBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endMTUMigrationValuesUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConfigStatusUnsupportedConfigOverridesNested<N> extends ConfigStatusFluent<ConfigStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConfigStatusUnsupportedConfigOverridesNested(ConfigStatus item) {
      this.builder = new ConfigStatusBuilder(this, item);
    }
    ConfigStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class VSphereCSIDriverConfigSpecUnsupportedOverridesNested<N> extends VSphereCSIDriverConfigSpecFluent<VSphereCSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    VSphereCSIDriverConfigSpecUnsupportedOverridesNested(VSphereCSIDriverConfigSpec item) {
      this.builder = new VSphereCSIDriverConfigSpecBuilder(this, item);
    }
    VSphereCSIDriverConfigSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endVSphereCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  }
  public class ServiceCAUnsupportedConfigOverridesNested<N> extends ServiceCAFluent<ServiceCAUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCAUnsupportedConfigOverridesNested(ServiceCA item) {
      this.builder = new ServiceCABuilder(this, item);
    }
    ServiceCABuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<N> extends ServiceCatalogControllerManagerSpecFluent<ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerSpecUnsupportedConfigOverridesNested(ServiceCatalogControllerManagerSpec item) {
      this.builder = new ServiceCatalogControllerManagerSpecBuilder(this, item);
    }
    ServiceCatalogControllerManagerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerListUnsupportedConfigOverridesNested<N> extends IngressControllerListFluent<IngressControllerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerListUnsupportedConfigOverridesNested(IngressControllerList item) {
      this.builder = new IngressControllerListBuilder(this, item);
    }
    IngressControllerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSListUnsupportedConfigOverridesNested<N> extends DNSListFluent<DNSListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSListUnsupportedConfigOverridesNested(DNSList item) {
      this.builder = new DNSListBuilder(this, item);
    }
    DNSListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeAPIServerStatusUnsupportedConfigOverridesNested<N> extends KubeAPIServerStatusFluent<KubeAPIServerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeAPIServerStatusUnsupportedConfigOverridesNested(KubeAPIServerStatus item) {
      this.builder = new KubeAPIServerStatusBuilder(this, item);
    }
    KubeAPIServerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends AWSClassicLoadBalancerParametersFluent<AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AWSClassicLoadBalancerParametersUnsupportedConfigOverridesNested(AWSClassicLoadBalancerParameters item) {
      this.builder = new AWSClassicLoadBalancerParametersBuilder(this, item);
    }
    AWSClassicLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSClassicLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeAPIServerUnsupportedConfigOverridesNested<N> extends KubeAPIServerFluent<KubeAPIServerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeAPIServerUnsupportedConfigOverridesNested(KubeAPIServer item) {
      this.builder = new KubeAPIServerBuilder(this, item);
    }
    KubeAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerUnsupportedConfigOverridesNested<N> extends IngressControllerFluent<IngressControllerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerUnsupportedConfigOverridesNested(IngressController item) {
      this.builder = new IngressControllerBuilder(this, item);
    }
    IngressControllerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConsoleConfigRouteUnsupportedOverridesNested<N> extends ConsoleConfigRouteFluent<ConsoleConfigRouteUnsupportedOverridesNested<N>> implements Nested<N>{
    ConsoleConfigRouteUnsupportedOverridesNested(ConsoleConfigRoute item) {
      this.builder = new ConsoleConfigRouteBuilder(this, item);
    }
    ConsoleConfigRouteBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleConfigRouteUnsupportedOverrides() {
      return and();
    }
    
  }
  public class CloudCredentialStatusUnsupportedConfigOverridesNested<N> extends CloudCredentialStatusFluent<CloudCredentialStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CloudCredentialStatusUnsupportedConfigOverridesNested(CloudCredentialStatus item) {
      this.builder = new CloudCredentialStatusBuilder(this, item);
    }
    CloudCredentialStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N> extends KubeStorageVersionMigratorFluent<KubeStorageVersionMigratorUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorUnsupportedConfigOverridesNested(KubeStorageVersionMigrator item) {
      this.builder = new KubeStorageVersionMigratorBuilder(this, item);
    }
    KubeStorageVersionMigratorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerStatusUnsupportedConfigOverridesNested<N> extends IngressControllerStatusFluent<IngressControllerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerStatusUnsupportedConfigOverridesNested(IngressControllerStatus item) {
      this.builder = new IngressControllerStatusBuilder(this, item);
    }
    IngressControllerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<N> extends ServiceCatalogControllerManagerStatusFluent<ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerStatusUnsupportedConfigOverridesNested(ServiceCatalogControllerManagerStatus item) {
      this.builder = new ServiceCatalogControllerManagerStatusBuilder(this, item);
    }
    ServiceCatalogControllerManagerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ImagePrunerListUnsupportedConfigOverridesNested<N> extends ImagePrunerListFluent<ImagePrunerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImagePrunerListUnsupportedConfigOverridesNested(ImagePrunerList item) {
      this.builder = new ImagePrunerListBuilder(this, item);
    }
    ImagePrunerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class LocalObjectReferenceUnsupportedConfigOverridesNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LocalObjectReferenceUnsupportedConfigOverridesNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLocalObjectReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StaticIPAMRoutesUnsupportedConfigOverridesNested<N> extends StaticIPAMRoutesFluent<StaticIPAMRoutesUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StaticIPAMRoutesUnsupportedConfigOverridesNested(StaticIPAMRoutes item) {
      this.builder = new StaticIPAMRoutesBuilder(this, item);
    }
    StaticIPAMRoutesBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMRoutesUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<N> extends ContainerLoggingDestinationParametersFluent<ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ContainerLoggingDestinationParametersUnsupportedConfigOverridesNested(ContainerLoggingDestinationParameters item) {
      this.builder = new ContainerLoggingDestinationParametersBuilder(this, item);
    }
    ContainerLoggingDestinationParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endContainerLoggingDestinationParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeSchedulerListUnsupportedConfigOverridesNested<N> extends KubeSchedulerListFluent<KubeSchedulerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeSchedulerListUnsupportedConfigOverridesNested(KubeSchedulerList item) {
      this.builder = new KubeSchedulerListBuilder(this, item);
    }
    KubeSchedulerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeAPIServerSpecUnsupportedConfigOverridesNested<N> extends KubeAPIServerSpecFluent<KubeAPIServerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeAPIServerSpecUnsupportedConfigOverridesNested(KubeAPIServerSpec item) {
      this.builder = new KubeAPIServerSpecBuilder(this, item);
    }
    KubeAPIServerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftControllerManagerUnsupportedConfigOverridesNested<N> extends OpenShiftControllerManagerFluent<OpenShiftControllerManagerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftControllerManagerUnsupportedConfigOverridesNested(OpenShiftControllerManager item) {
      this.builder = new OpenShiftControllerManagerBuilder(this, item);
    }
    OpenShiftControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class EndpointPublishingStrategyUnsupportedConfigOverridesNested<N> extends EndpointPublishingStrategyFluent<EndpointPublishingStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EndpointPublishingStrategyUnsupportedConfigOverridesNested(EndpointPublishingStrategy item) {
      this.builder = new EndpointPublishingStrategyBuilder(this, item);
    }
    EndpointPublishingStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEndpointPublishingStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CloudCredentialUnsupportedConfigOverridesNested<N> extends CloudCredentialFluent<CloudCredentialUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CloudCredentialUnsupportedConfigOverridesNested(CloudCredential item) {
      this.builder = new CloudCredentialBuilder(this, item);
    }
    CloudCredentialBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeSchedulerUnsupportedConfigOverridesNested<N> extends KubeSchedulerFluent<KubeSchedulerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeSchedulerUnsupportedConfigOverridesNested(KubeScheduler item) {
      this.builder = new KubeSchedulerBuilder(this, item);
    }
    KubeSchedulerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ClusterCSIDriverStatusUnsupportedConfigOverridesNested<N> extends ClusterCSIDriverStatusFluent<ClusterCSIDriverStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterCSIDriverStatusUnsupportedConfigOverridesNested(ClusterCSIDriverStatus item) {
      this.builder = new ClusterCSIDriverStatusBuilder(this, item);
    }
    ClusterCSIDriverStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class SFlowConfigUnsupportedOverridesNested<N> extends SFlowConfigFluent<SFlowConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    SFlowConfigUnsupportedOverridesNested(SFlowConfig item) {
      this.builder = new SFlowConfigBuilder(this, item);
    }
    SFlowConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSFlowConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class ForwardPluginUnsupportedConfigOverridesNested<N> extends ForwardPluginFluent<ForwardPluginUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ForwardPluginUnsupportedConfigOverridesNested(ForwardPlugin item) {
      this.builder = new ForwardPluginBuilder(this, item);
    }
    ForwardPluginBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endForwardPluginUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class LogEntryUnsupportedConfigOverridesNested<N> extends LogEntryFluent<LogEntryUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LogEntryUnsupportedConfigOverridesNested(LogEntry item) {
      this.builder = new LogEntryBuilder(this, item);
    }
    LogEntryBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLogEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<N> extends AdditionalNetworkDefinitionFluent<AdditionalNetworkDefinitionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AdditionalNetworkDefinitionUnsupportedConfigOverridesNested(AdditionalNetworkDefinition item) {
      this.builder = new AdditionalNetworkDefinitionBuilder(this, item);
    }
    AdditionalNetworkDefinitionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAdditionalNetworkDefinitionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AuthenticationStatusUnsupportedConfigOverridesNested<N> extends AuthenticationStatusFluent<AuthenticationStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AuthenticationStatusUnsupportedConfigOverridesNested(AuthenticationStatus item) {
      this.builder = new AuthenticationStatusBuilder(this, item);
    }
    AuthenticationStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NodePortStrategyUnsupportedConfigOverridesNested<N> extends NodePortStrategyFluent<NodePortStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NodePortStrategyUnsupportedConfigOverridesNested(NodePortStrategy item) {
      this.builder = new NodePortStrategyBuilder(this, item);
    }
    NodePortStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodePortStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NetworkUnsupportedConfigOverridesNested<N> extends NetworkFluent<NetworkUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkUnsupportedConfigOverridesNested(Network item) {
      this.builder = new NetworkBuilder(this, item);
    }
    NetworkBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ClientTLSUnsupportedConfigOverridesNested<N> extends ClientTLSFluent<ClientTLSUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClientTLSUnsupportedConfigOverridesNested(ClientTLS item) {
      this.builder = new ClientTLSBuilder(this, item);
    }
    ClientTLSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClientTLSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ImagePrunerStatusUnsupportedConfigOverridesNested<N> extends ImagePrunerStatusFluent<ImagePrunerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImagePrunerStatusUnsupportedConfigOverridesNested(ImagePrunerStatus item) {
      this.builder = new ImagePrunerStatusBuilder(this, item);
    }
    ImagePrunerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class UpstreamUnsupportedConfigOverridesNested<N> extends UpstreamFluent<UpstreamUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    UpstreamUnsupportedConfigOverridesNested(Upstream item) {
      this.builder = new UpstreamBuilder(this, item);
    }
    UpstreamBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endUpstreamUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AzureDiskEncryptionSetUnsupportedConfigOverridesNested<N> extends AzureDiskEncryptionSetFluent<AzureDiskEncryptionSetUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AzureDiskEncryptionSetUnsupportedConfigOverridesNested(AzureDiskEncryptionSet item) {
      this.builder = new AzureDiskEncryptionSetBuilder(this, item);
    }
    AzureDiskEncryptionSetBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAzureDiskEncryptionSetUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N> extends ServiceCatalogAPIServerFluent<ServiceCatalogAPIServerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerUnsupportedConfigOverridesNested(ServiceCatalogAPIServer item) {
      this.builder = new ServiceCatalogAPIServerBuilder(this, item);
    }
    ServiceCatalogAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CSIDriverConfigSpecUnsupportedOverridesNested<N> extends CSIDriverConfigSpecFluent<CSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    CSIDriverConfigSpecUnsupportedOverridesNested(CSIDriverConfigSpec item) {
      this.builder = new CSIDriverConfigSpecBuilder(this, item);
    }
    CSIDriverConfigSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  }
  public class IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<N> extends IngressControllerCaptureHTTPHeaderFluent<IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPHeaderUnsupportedConfigOverridesNested(IngressControllerCaptureHTTPHeader item) {
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeaderBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPHeaderUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NetworkMigrationUnsupportedConfigOverridesNested<N> extends NetworkMigrationFluent<NetworkMigrationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkMigrationUnsupportedConfigOverridesNested(NetworkMigration item) {
      this.builder = new NetworkMigrationBuilder(this, item);
    }
    NetworkMigrationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkMigrationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSRecordListUnsupportedConfigOverridesNested<N> extends DNSRecordListFluent<DNSRecordListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSRecordListUnsupportedConfigOverridesNested(DNSRecordList item) {
      this.builder = new DNSRecordListBuilder(this, item);
    }
    DNSRecordListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class RawExtensionUnsupportedConfigOverridesNested<N> extends RawExtensionFluent<RawExtensionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    RawExtensionUnsupportedConfigOverridesNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRawExtensionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class EtcdSpecUnsupportedConfigOverridesNested<N> extends EtcdSpecFluent<EtcdSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EtcdSpecUnsupportedConfigOverridesNested(EtcdSpec item) {
      this.builder = new EtcdSpecBuilder(this, item);
    }
    EtcdSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckFluent<PodNetworkConnectivityCheckUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckUnsupportedConfigOverridesNested(PodNetworkConnectivityCheck item) {
      this.builder = new PodNetworkConnectivityCheckBuilder(this, item);
    }
    PodNetworkConnectivityCheckBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<N> extends OpenShiftAPIServerStatusFluent<OpenShiftAPIServerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftAPIServerStatusUnsupportedConfigOverridesNested(OpenShiftAPIServerStatus item) {
      this.builder = new OpenShiftAPIServerStatusBuilder(this, item);
    }
    OpenShiftAPIServerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class LoadBalancerStrategyUnsupportedConfigOverridesNested<N> extends LoadBalancerStrategyFluent<LoadBalancerStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LoadBalancerStrategyUnsupportedConfigOverridesNested(LoadBalancerStrategy item) {
      this.builder = new LoadBalancerStrategyBuilder(this, item);
    }
    LoadBalancerStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLoadBalancerStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSOverTLSConfigUnsupportedOverridesNested<N> extends DNSOverTLSConfigFluent<DNSOverTLSConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    DNSOverTLSConfigUnsupportedOverridesNested(DNSOverTLSConfig item) {
      this.builder = new DNSOverTLSConfigBuilder(this, item);
    }
    DNSOverTLSConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSOverTLSConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class CloudCredentialListUnsupportedConfigOverridesNested<N> extends CloudCredentialListFluent<CloudCredentialListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CloudCredentialListUnsupportedConfigOverridesNested(CloudCredentialList item) {
      this.builder = new CloudCredentialListBuilder(this, item);
    }
    CloudCredentialListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSCacheUnsupportedConfigOverridesNested<N> extends DNSCacheFluent<DNSCacheUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSCacheUnsupportedConfigOverridesNested(DNSCache item) {
      this.builder = new DNSCacheBuilder(this, item);
    }
    DNSCacheBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSCacheUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ImagePrunerSpecUnsupportedConfigOverridesNested<N> extends ImagePrunerSpecFluent<ImagePrunerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImagePrunerSpecUnsupportedConfigOverridesNested(ImagePrunerSpec item) {
      this.builder = new ImagePrunerSpecBuilder(this, item);
    }
    ImagePrunerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImagePrunerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConfigListUnsupportedConfigOverridesNested<N> extends ConfigListFluent<ConfigListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConfigListUnsupportedConfigOverridesNested(ConfigList item) {
      this.builder = new ConfigListBuilder(this, item);
    }
    ConfigListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AuthenticationListUnsupportedConfigOverridesNested<N> extends AuthenticationListFluent<AuthenticationListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AuthenticationListUnsupportedConfigOverridesNested(AuthenticationList item) {
      this.builder = new AuthenticationListBuilder(this, item);
    }
    AuthenticationListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PinnedResourceReferenceUnsupportedConfigOverridesNested<N> extends PinnedResourceReferenceFluent<PinnedResourceReferenceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PinnedResourceReferenceUnsupportedConfigOverridesNested(PinnedResourceReference item) {
      this.builder = new PinnedResourceReferenceBuilder(this, item);
    }
    PinnedResourceReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPinnedResourceReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeControllerManagerListUnsupportedConfigOverridesNested<N> extends KubeControllerManagerListFluent<KubeControllerManagerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeControllerManagerListUnsupportedConfigOverridesNested(KubeControllerManagerList item) {
      this.builder = new KubeControllerManagerListBuilder(this, item);
    }
    KubeControllerManagerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IPAMConfigUnsupportedOverridesNested<N> extends IPAMConfigFluent<IPAMConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    IPAMConfigUnsupportedOverridesNested(IPAMConfig item) {
      this.builder = new IPAMConfigBuilder(this, item);
    }
    IPAMConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPAMConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class ContainerUnsupportedConfigOverridesNested<N> extends ContainerFluent<ContainerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ContainerUnsupportedConfigOverridesNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endContainerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IBMLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends IBMLoadBalancerParametersFluent<IBMLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IBMLoadBalancerParametersUnsupportedConfigOverridesNested(IBMLoadBalancerParameters item) {
      this.builder = new IBMLoadBalancerParametersBuilder(this, item);
    }
    IBMLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIBMLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AccessLoggingUnsupportedConfigOverridesNested<N> extends AccessLoggingFluent<AccessLoggingUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AccessLoggingUnsupportedConfigOverridesNested(AccessLogging item) {
      this.builder = new AccessLoggingBuilder(this, item);
    }
    AccessLoggingBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAccessLoggingUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class HostNetworkStrategyUnsupportedConfigOverridesNested<N> extends HostNetworkStrategyFluent<HostNetworkStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    HostNetworkStrategyUnsupportedConfigOverridesNested(HostNetworkStrategy item) {
      this.builder = new HostNetworkStrategyBuilder(this, item);
    }
    HostNetworkStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHostNetworkStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeSchedulerSpecUnsupportedConfigOverridesNested<N> extends KubeSchedulerSpecFluent<KubeSchedulerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeSchedulerSpecUnsupportedConfigOverridesNested(KubeSchedulerSpec item) {
      this.builder = new KubeSchedulerSpecBuilder(this, item);
    }
    KubeSchedulerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ImageContentSourcePolicyListUnsupportedConfigOverridesNested<N> extends ImageContentSourcePolicyListFluent<ImageContentSourcePolicyListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImageContentSourcePolicyListUnsupportedConfigOverridesNested(ImageContentSourcePolicyList item) {
      this.builder = new ImageContentSourcePolicyListBuilder(this, item);
    }
    ImageContentSourcePolicyListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicyListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<N> extends OpenShiftControllerManagerStatusFluent<OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftControllerManagerStatusUnsupportedConfigOverridesNested(OpenShiftControllerManagerStatus item) {
      this.builder = new OpenShiftControllerManagerStatusBuilder(this, item);
    }
    OpenShiftControllerManagerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<N> extends ServiceCatalogAPIServerStatusFluent<ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerStatusUnsupportedConfigOverridesNested(ServiceCatalogAPIServerStatus item) {
      this.builder = new ServiceCatalogAPIServerStatusBuilder(this, item);
    }
    ServiceCatalogAPIServerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSNodePlacementUnsupportedConfigOverridesNested<N> extends DNSNodePlacementFluent<DNSNodePlacementUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSNodePlacementUnsupportedConfigOverridesNested(DNSNodePlacement item) {
      this.builder = new DNSNodePlacementBuilder(this, item);
    }
    DNSNodePlacementBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSNodePlacementUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NetworkListUnsupportedConfigOverridesNested<N> extends NetworkListFluent<NetworkListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkListUnsupportedConfigOverridesNested(NetworkList item) {
      this.builder = new NetworkListBuilder(this, item);
    }
    NetworkListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends ProviderLoadBalancerParametersFluent<ProviderLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ProviderLoadBalancerParametersUnsupportedConfigOverridesNested(ProviderLoadBalancerParameters item) {
      this.builder = new ProviderLoadBalancerParametersBuilder(this, item);
    }
    ProviderLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProviderLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ResourceAttributesAccessReviewUnsupportedConfigOverridesNested<N> extends ResourceAttributesAccessReviewFluent<ResourceAttributesAccessReviewUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ResourceAttributesAccessReviewUnsupportedConfigOverridesNested(ResourceAttributesAccessReview item) {
      this.builder = new ResourceAttributesAccessReviewBuilder(this, item);
    }
    ResourceAttributesAccessReviewBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endResourceAttributesAccessReviewUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCASpecUnsupportedConfigOverridesNested<N> extends ServiceCASpecFluent<ServiceCASpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCASpecUnsupportedConfigOverridesNested(ServiceCASpec item) {
      this.builder = new ServiceCASpecBuilder(this, item);
    }
    ServiceCASpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCASpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PrivateStrategyUnsupportedConfigOverridesNested<N> extends PrivateStrategyFluent<PrivateStrategyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PrivateStrategyUnsupportedConfigOverridesNested(PrivateStrategy item) {
      this.builder = new PrivateStrategyBuilder(this, item);
    }
    PrivateStrategyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPrivateStrategyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckListFluent<PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckListUnsupportedConfigOverridesNested(PodNetworkConnectivityCheckList item) {
      this.builder = new PodNetworkConnectivityCheckListBuilder(this, item);
    }
    PodNetworkConnectivityCheckListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftAPIServerListUnsupportedConfigOverridesNested<N> extends OpenShiftAPIServerListFluent<OpenShiftAPIServerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftAPIServerListUnsupportedConfigOverridesNested(OpenShiftAPIServerList item) {
      this.builder = new OpenShiftAPIServerListBuilder(this, item);
    }
    OpenShiftAPIServerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OAuthAPIServerStatusUnsupportedConfigOverridesNested<N> extends OAuthAPIServerStatusFluent<OAuthAPIServerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OAuthAPIServerStatusUnsupportedConfigOverridesNested(OAuthAPIServerStatus item) {
      this.builder = new OAuthAPIServerStatusBuilder(this, item);
    }
    OAuthAPIServerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOAuthAPIServerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class GCPCSIDriverConfigSpecUnsupportedOverridesNested<N> extends GCPCSIDriverConfigSpecFluent<GCPCSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    GCPCSIDriverConfigSpecUnsupportedOverridesNested(GCPCSIDriverConfigSpec item) {
      this.builder = new GCPCSIDriverConfigSpecBuilder(this, item);
    }
    GCPCSIDriverConfigSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGCPCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N> extends ServiceCatalogControllerManagerFluent<ServiceCatalogControllerManagerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerUnsupportedConfigOverridesNested(ServiceCatalogControllerManager item) {
      this.builder = new ServiceCatalogControllerManagerBuilder(this, item);
    }
    ServiceCatalogControllerManagerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<N> extends IngressControllerCaptureHTTPCookieFluent<IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPCookieUnsupportedConfigOverridesNested(IngressControllerCaptureHTTPCookie item) {
      this.builder = new IngressControllerCaptureHTTPCookieBuilder(this, item);
    }
    IngressControllerCaptureHTTPCookieBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPCookieUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSUnsupportedConfigOverridesNested<N> extends DNSFluent<DNSUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSUnsupportedConfigOverridesNested(DNS item) {
      this.builder = new DNSBuilder(this, item);
    }
    DNSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AddPageUnsupportedConfigOverridesNested<N> extends AddPageFluent<AddPageUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AddPageUnsupportedConfigOverridesNested(AddPage item) {
      this.builder = new AddPageBuilder(this, item);
    }
    AddPageBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAddPageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AzureCSIDriverConfigSpecUnsupportedOverridesNested<N> extends AzureCSIDriverConfigSpecFluent<AzureCSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    AzureCSIDriverConfigSpecUnsupportedOverridesNested(AzureCSIDriverConfigSpec item) {
      this.builder = new AzureCSIDriverConfigSpecBuilder(this, item);
    }
    AzureCSIDriverConfigSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAzureCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  }
  public class StorageListUnsupportedConfigOverridesNested<N> extends StorageListFluent<StorageListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StorageListUnsupportedConfigOverridesNested(StorageList item) {
      this.builder = new StorageListBuilder(this, item);
    }
    StorageListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AuthenticationUnsupportedConfigOverridesNested<N> extends AuthenticationFluent<AuthenticationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AuthenticationUnsupportedConfigOverridesNested(Authentication item) {
      this.builder = new AuthenticationBuilder(this, item);
    }
    AuthenticationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCAStatusUnsupportedConfigOverridesNested<N> extends ServiceCAStatusFluent<ServiceCAStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCAStatusUnsupportedConfigOverridesNested(ServiceCAStatus item) {
      this.builder = new ServiceCAStatusBuilder(this, item);
    }
    ServiceCAStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PerspectiveUnsupportedConfigOverridesNested<N> extends PerspectiveFluent<PerspectiveUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PerspectiveUnsupportedConfigOverridesNested(Perspective item) {
      this.builder = new PerspectiveBuilder(this, item);
    }
    PerspectiveBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPerspectiveUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class MTUMigrationUnsupportedConfigOverridesNested<N> extends MTUMigrationFluent<MTUMigrationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    MTUMigrationUnsupportedConfigOverridesNested(MTUMigration item) {
      this.builder = new MTUMigrationBuilder(this, item);
    }
    MTUMigrationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endMTUMigrationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class LabelSelectorUnsupportedConfigOverridesNested<N> extends LabelSelectorFluent<LabelSelectorUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LabelSelectorUnsupportedConfigOverridesNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLabelSelectorUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<N> extends KubeStorageVersionMigratorListFluent<KubeStorageVersionMigratorListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorListUnsupportedConfigOverridesNested(KubeStorageVersionMigratorList item) {
      this.builder = new KubeStorageVersionMigratorListBuilder(this, item);
    }
    KubeStorageVersionMigratorListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StorageUnsupportedConfigOverridesNested<N> extends StorageFluent<StorageUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StorageUnsupportedConfigOverridesNested(Storage item) {
      this.builder = new StorageBuilder(this, item);
    }
    StorageBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<N> extends ServiceCatalogControllerManagerListFluent<ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogControllerManagerListUnsupportedConfigOverridesNested(ServiceCatalogControllerManagerList item) {
      this.builder = new ServiceCatalogControllerManagerListBuilder(this, item);
    }
    ServiceCatalogControllerManagerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OVNKubernetesConfigUnsupportedOverridesNested<N> extends OVNKubernetesConfigFluent<OVNKubernetesConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    OVNKubernetesConfigUnsupportedOverridesNested(OVNKubernetesConfig item) {
      this.builder = new OVNKubernetesConfigBuilder(this, item);
    }
    OVNKubernetesConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOVNKubernetesConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<N> extends DeveloperConsoleCatalogCategoryMetaFluent<DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverridesNested(DeveloperConsoleCatalogCategoryMeta item) {
      this.builder = new DeveloperConsoleCatalogCategoryMetaBuilder(this, item);
    }
    DeveloperConsoleCatalogCategoryMetaBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCategoryMetaUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerSpecUnsupportedConfigOverridesNested<N> extends IngressControllerSpecFluent<IngressControllerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerSpecUnsupportedConfigOverridesNested(IngressControllerSpec item) {
      this.builder = new IngressControllerSpecBuilder(this, item);
    }
    IngressControllerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSSpecUnsupportedConfigOverridesNested<N> extends DNSSpecFluent<DNSSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSSpecUnsupportedConfigOverridesNested(DNSSpec item) {
      this.builder = new DNSSpecBuilder(this, item);
    }
    DNSSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OperatorConditionUnsupportedConfigOverridesNested<N> extends OperatorConditionFluent<OperatorConditionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OperatorConditionUnsupportedConfigOverridesNested(OperatorCondition item) {
      this.builder = new OperatorConditionBuilder(this, item);
    }
    OperatorConditionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOperatorConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ProxyConfigUnsupportedOverridesNested<N> extends ProxyConfigFluent<ProxyConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    ProxyConfigUnsupportedOverridesNested(ProxyConfig item) {
      this.builder = new ProxyConfigBuilder(this, item);
    }
    ProxyConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProxyConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class KuryrConfigUnsupportedOverridesNested<N> extends KuryrConfigFluent<KuryrConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    KuryrConfigUnsupportedOverridesNested(KuryrConfig item) {
      this.builder = new KuryrConfigBuilder(this, item);
    }
    KuryrConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKuryrConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<N> extends ServiceCatalogAPIServerSpecFluent<ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCatalogAPIServerSpecUnsupportedConfigOverridesNested(ServiceCatalogAPIServerSpec item) {
      this.builder = new ServiceCatalogAPIServerSpecBuilder(this, item);
    }
    ServiceCatalogAPIServerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCatalogAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<N> extends ImageContentSourcePolicySpecFluent<ImageContentSourcePolicySpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ImageContentSourcePolicySpecUnsupportedConfigOverridesNested(ImageContentSourcePolicySpec item) {
      this.builder = new ImageContentSourcePolicySpecBuilder(this, item);
    }
    ImageContentSourcePolicySpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endImageContentSourcePolicySpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSStatusUnsupportedConfigOverridesNested<N> extends DNSStatusFluent<DNSStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSStatusUnsupportedConfigOverridesNested(DNSStatus item) {
      this.builder = new DNSStatusBuilder(this, item);
    }
    DNSStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSTransportConfigUnsupportedOverridesNested<N> extends DNSTransportConfigFluent<DNSTransportConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    DNSTransportConfigUnsupportedOverridesNested(DNSTransportConfig item) {
      this.builder = new DNSTransportConfigBuilder(this, item);
    }
    DNSTransportConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSTransportConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class GCPLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends GCPLoadBalancerParametersFluent<GCPLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    GCPLoadBalancerParametersUnsupportedConfigOverridesNested(GCPLoadBalancerParameters item) {
      this.builder = new GCPLoadBalancerParametersBuilder(this, item);
    }
    GCPLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGCPLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeAPIServerListUnsupportedConfigOverridesNested<N> extends KubeAPIServerListFluent<KubeAPIServerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeAPIServerListUnsupportedConfigOverridesNested(KubeAPIServerList item) {
      this.builder = new KubeAPIServerListBuilder(this, item);
    }
    KubeAPIServerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeAPIServerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConfigUnsupportedConfigOverridesNested<N> extends ConfigFluent<ConfigUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConfigUnsupportedConfigOverridesNested(Config item) {
      this.builder = new ConfigBuilder(this, item);
    }
    ConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ObjectMetaUnsupportedConfigOverridesNested<N> extends ObjectMetaFluent<ObjectMetaUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ObjectMetaUnsupportedConfigOverridesNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endObjectMetaUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ClusterCSIDriverListUnsupportedConfigOverridesNested<N> extends ClusterCSIDriverListFluent<ClusterCSIDriverListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterCSIDriverListUnsupportedConfigOverridesNested(ClusterCSIDriverList item) {
      this.builder = new ClusterCSIDriverListBuilder(this, item);
    }
    ClusterCSIDriverListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class SimpleMacvlanConfigUnsupportedOverridesNested<N> extends SimpleMacvlanConfigFluent<SimpleMacvlanConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    SimpleMacvlanConfigUnsupportedOverridesNested(SimpleMacvlanConfig item) {
      this.builder = new SimpleMacvlanConfigBuilder(this, item);
    }
    SimpleMacvlanConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSimpleMacvlanConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class PersistentVolumeClaimUnsupportedConfigOverridesNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PersistentVolumeClaimUnsupportedConfigOverridesNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPersistentVolumeClaimUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class GenericKubernetesResourceUnsupportedConfigOverridesNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    GenericKubernetesResourceUnsupportedConfigOverridesNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGenericKubernetesResourceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class EgressIPConfigUnsupportedOverridesNested<N> extends EgressIPConfigFluent<EgressIPConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    EgressIPConfigUnsupportedOverridesNested(EgressIPConfig item) {
      this.builder = new EgressIPConfigBuilder(this, item);
    }
    EgressIPConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEgressIPConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class HybridOverlayConfigUnsupportedOverridesNested<N> extends HybridOverlayConfigFluent<HybridOverlayConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    HybridOverlayConfigUnsupportedOverridesNested(HybridOverlayConfig item) {
      this.builder = new HybridOverlayConfigBuilder(this, item);
    }
    HybridOverlayConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHybridOverlayConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class AWSLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends AWSLoadBalancerParametersFluent<AWSLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AWSLoadBalancerParametersUnsupportedConfigOverridesNested(AWSLoadBalancerParameters item) {
      this.builder = new AWSLoadBalancerParametersBuilder(this, item);
    }
    AWSLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CSISnapshotControllerListUnsupportedConfigOverridesNested<N> extends CSISnapshotControllerListFluent<CSISnapshotControllerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CSISnapshotControllerListUnsupportedConfigOverridesNested(CSISnapshotControllerList item) {
      this.builder = new CSISnapshotControllerListBuilder(this, item);
    }
    CSISnapshotControllerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConsoleUnsupportedConfigOverridesNested<N> extends ConsoleFluent<ConsoleUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleUnsupportedConfigOverridesNested(Console item) {
      this.builder = new ConsoleBuilder(this, item);
    }
    ConsoleBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSZoneConditionUnsupportedConfigOverridesNested<N> extends DNSZoneConditionFluent<DNSZoneConditionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSZoneConditionUnsupportedConfigOverridesNested(DNSZoneCondition item) {
      this.builder = new DNSZoneConditionBuilder(this, item);
    }
    DNSZoneConditionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSZoneConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ClusterCSIDriverUnsupportedConfigOverridesNested<N> extends ClusterCSIDriverFluent<ClusterCSIDriverUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterCSIDriverUnsupportedConfigOverridesNested(ClusterCSIDriver item) {
      this.builder = new ClusterCSIDriverBuilder(this, item);
    }
    ClusterCSIDriverBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterCSIDriverUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class QuickStartsUnsupportedConfigOverridesNested<N> extends QuickStartsFluent<QuickStartsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    QuickStartsUnsupportedConfigOverridesNested(QuickStarts item) {
      this.builder = new QuickStartsBuilder(this, item);
    }
    QuickStartsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endQuickStartsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSZoneStatusUnsupportedConfigOverridesNested<N> extends DNSZoneStatusFluent<DNSZoneStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSZoneStatusUnsupportedConfigOverridesNested(DNSZoneStatus item) {
      this.builder = new DNSZoneStatusBuilder(this, item);
    }
    DNSZoneStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSZoneStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConfigSpecUnsupportedConfigOverridesNested<N> extends ConfigSpecFluent<ConfigSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConfigSpecUnsupportedConfigOverridesNested(ConfigSpec item) {
      this.builder = new ConfigSpecBuilder(this, item);
    }
    ConfigSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConfigSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OutageEntryUnsupportedConfigOverridesNested<N> extends OutageEntryFluent<OutageEntryUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OutageEntryUnsupportedConfigOverridesNested(OutageEntry item) {
      this.builder = new OutageEntryBuilder(this, item);
    }
    OutageEntryBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOutageEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftControllerManagerListUnsupportedConfigOverridesNested<N> extends OpenShiftControllerManagerListFluent<OpenShiftControllerManagerListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftControllerManagerListUnsupportedConfigOverridesNested(OpenShiftControllerManagerList item) {
      this.builder = new OpenShiftControllerManagerListBuilder(this, item);
    }
    OpenShiftControllerManagerListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftControllerManagerListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class EtcdUnsupportedConfigOverridesNested<N> extends EtcdFluent<EtcdUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EtcdUnsupportedConfigOverridesNested(Etcd item) {
      this.builder = new EtcdBuilder(this, item);
    }
    EtcdBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IPFIXConfigUnsupportedOverridesNested<N> extends IPFIXConfigFluent<IPFIXConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    IPFIXConfigUnsupportedOverridesNested(IPFIXConfig item) {
      this.builder = new IPFIXConfigBuilder(this, item);
    }
    IPFIXConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIPFIXConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class NetworkStatusUnsupportedConfigOverridesNested<N> extends NetworkStatusFluent<NetworkStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkStatusUnsupportedConfigOverridesNested(NetworkStatus item) {
      this.builder = new NetworkStatusBuilder(this, item);
    }
    NetworkStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NodeStatusUnsupportedConfigOverridesNested<N> extends NodeStatusFluent<NodeStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NodeStatusUnsupportedConfigOverridesNested(NodeStatus item) {
      this.builder = new NodeStatusBuilder(this, item);
    }
    NodeStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodeStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckConditionFluent<PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckConditionUnsupportedConfigOverridesNested(PodNetworkConnectivityCheckCondition item) {
      this.builder = new PodNetworkConnectivityCheckConditionBuilder(this, item);
    }
    PodNetworkConnectivityCheckConditionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckConditionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class RouteAdmissionPolicyUnsupportedConfigOverridesNested<N> extends RouteAdmissionPolicyFluent<RouteAdmissionPolicyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    RouteAdmissionPolicyUnsupportedConfigOverridesNested(RouteAdmissionPolicy item) {
      this.builder = new RouteAdmissionPolicyBuilder(this, item);
    }
    RouteAdmissionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endRouteAdmissionPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class GenerationStatusUnsupportedConfigOverridesNested<N> extends GenerationStatusFluent<GenerationStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    GenerationStatusUnsupportedConfigOverridesNested(GenerationStatus item) {
      this.builder = new GenerationStatusBuilder(this, item);
    }
    GenerationStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGenerationStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<N> extends IngressControllerCaptureHTTPHeadersFluent<IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerCaptureHTTPHeadersUnsupportedConfigOverridesNested(IngressControllerCaptureHTTPHeaders item) {
      this.builder = new IngressControllerCaptureHTTPHeadersBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeadersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerCaptureHTTPHeadersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class EtcdListUnsupportedConfigOverridesNested<N> extends EtcdListFluent<EtcdListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EtcdListUnsupportedConfigOverridesNested(EtcdList item) {
      this.builder = new EtcdListBuilder(this, item);
    }
    EtcdListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class FeaturesMigrationUnsupportedConfigOverridesNested<N> extends FeaturesMigrationFluent<FeaturesMigrationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    FeaturesMigrationUnsupportedConfigOverridesNested(FeaturesMigration item) {
      this.builder = new FeaturesMigrationBuilder(this, item);
    }
    FeaturesMigrationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endFeaturesMigrationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DefaultNetworkDefinitionUnsupportedConfigOverridesNested<N> extends DefaultNetworkDefinitionFluent<DefaultNetworkDefinitionUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DefaultNetworkDefinitionUnsupportedConfigOverridesNested(DefaultNetworkDefinition item) {
      this.builder = new DefaultNetworkDefinitionBuilder(this, item);
    }
    DefaultNetworkDefinitionBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDefaultNetworkDefinitionUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class GCPKMSKeyReferenceUnsupportedConfigOverridesNested<N> extends GCPKMSKeyReferenceFluent<GCPKMSKeyReferenceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    GCPKMSKeyReferenceUnsupportedConfigOverridesNested(GCPKMSKeyReference item) {
      this.builder = new GCPKMSKeyReferenceBuilder(this, item);
    }
    GCPKMSKeyReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGCPKMSKeyReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<N> extends OpenShiftAPIServerSpecFluent<OpenShiftAPIServerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftAPIServerSpecUnsupportedConfigOverridesNested(OpenShiftAPIServerSpec item) {
      this.builder = new OpenShiftAPIServerSpecBuilder(this, item);
    }
    OpenShiftAPIServerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeSchedulerStatusUnsupportedConfigOverridesNested<N> extends KubeSchedulerStatusFluent<KubeSchedulerStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeSchedulerStatusUnsupportedConfigOverridesNested(KubeSchedulerStatus item) {
      this.builder = new KubeSchedulerStatusBuilder(this, item);
    }
    KubeSchedulerStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeSchedulerStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<N> extends SyslogLoggingDestinationParametersFluent<SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    SyslogLoggingDestinationParametersUnsupportedConfigOverridesNested(SyslogLoggingDestinationParameters item) {
      this.builder = new SyslogLoggingDestinationParametersBuilder(this, item);
    }
    SyslogLoggingDestinationParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endSyslogLoggingDestinationParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<N> extends AWSNetworkLoadBalancerParametersFluent<AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AWSNetworkLoadBalancerParametersUnsupportedConfigOverridesNested(AWSNetworkLoadBalancerParameters item) {
      this.builder = new AWSNetworkLoadBalancerParametersBuilder(this, item);
    }
    AWSNetworkLoadBalancerParametersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSNetworkLoadBalancerParametersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServiceCAListUnsupportedConfigOverridesNested<N> extends ServiceCAListFluent<ServiceCAListUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServiceCAListUnsupportedConfigOverridesNested(ServiceCAList item) {
      this.builder = new ServiceCAListBuilder(this, item);
    }
    ServiceCAListBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServiceCAListUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class EtcdStatusUnsupportedConfigOverridesNested<N> extends EtcdStatusFluent<EtcdStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    EtcdStatusUnsupportedConfigOverridesNested(EtcdStatus item) {
      this.builder = new EtcdStatusBuilder(this, item);
    }
    EtcdStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endEtcdStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StatuspageProviderUnsupportedConfigOverridesNested<N> extends StatuspageProviderFluent<StatuspageProviderUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StatuspageProviderUnsupportedConfigOverridesNested(StatuspageProvider item) {
      this.builder = new StatuspageProviderBuilder(this, item);
    }
    StatuspageProviderBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStatuspageProviderUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<N> extends KubeStorageVersionMigratorStatusFluent<KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeStorageVersionMigratorStatusUnsupportedConfigOverridesNested(KubeStorageVersionMigratorStatus item) {
      this.builder = new KubeStorageVersionMigratorStatusBuilder(this, item);
    }
    KubeStorageVersionMigratorStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeStorageVersionMigratorStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConsoleProvidersUnsupportedConfigOverridesNested<N> extends ConsoleProvidersFluent<ConsoleProvidersUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleProvidersUnsupportedConfigOverridesNested(ConsoleProviders item) {
      this.builder = new ConsoleProvidersBuilder(this, item);
    }
    ConsoleProvidersBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleProvidersUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerLoggingUnsupportedConfigOverridesNested<N> extends IngressControllerLoggingFluent<IngressControllerLoggingUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerLoggingUnsupportedConfigOverridesNested(IngressControllerLogging item) {
      this.builder = new IngressControllerLoggingBuilder(this, item);
    }
    IngressControllerLoggingBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerLoggingUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StorageStatusUnsupportedConfigOverridesNested<N> extends StorageStatusFluent<StorageStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StorageStatusUnsupportedConfigOverridesNested(StorageStatus item) {
      this.builder = new StorageStatusBuilder(this, item);
    }
    StorageStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class AuthenticationSpecUnsupportedConfigOverridesNested<N> extends AuthenticationSpecFluent<AuthenticationSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    AuthenticationSpecUnsupportedConfigOverridesNested(AuthenticationSpec item) {
      this.builder = new AuthenticationSpecBuilder(this, item);
    }
    AuthenticationSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAuthenticationSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CSISnapshotControllerUnsupportedConfigOverridesNested<N> extends CSISnapshotControllerFluent<CSISnapshotControllerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CSISnapshotControllerUnsupportedConfigOverridesNested(CSISnapshotController item) {
      this.builder = new CSISnapshotControllerBuilder(this, item);
    }
    CSISnapshotControllerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCSISnapshotControllerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<N> extends PodNetworkConnectivityCheckSpecFluent<PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PodNetworkConnectivityCheckSpecUnsupportedConfigOverridesNested(PodNetworkConnectivityCheckSpec item) {
      this.builder = new PodNetworkConnectivityCheckSpecBuilder(this, item);
    }
    PodNetworkConnectivityCheckSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPodNetworkConnectivityCheckSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested<N> extends DeveloperConsoleCatalogTypesFluent<DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogTypesUnsupportedConfigOverridesNested(DeveloperConsoleCatalogTypes item) {
      this.builder = new DeveloperConsoleCatalogTypesBuilder(this, item);
    }
    DeveloperConsoleCatalogTypesBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogTypesUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSRecordSpecUnsupportedConfigOverridesNested<N> extends DNSRecordSpecFluent<DNSRecordSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSRecordSpecUnsupportedConfigOverridesNested(DNSRecordSpec item) {
      this.builder = new DNSRecordSpecBuilder(this, item);
    }
    DNSRecordSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<N> extends DeveloperConsoleCatalogCustomizationFluent<DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DeveloperConsoleCatalogCustomizationUnsupportedConfigOverridesNested(DeveloperConsoleCatalogCustomization item) {
      this.builder = new DeveloperConsoleCatalogCustomizationBuilder(this, item);
    }
    DeveloperConsoleCatalogCustomizationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDeveloperConsoleCatalogCustomizationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class LoggingDestinationUnsupportedConfigOverridesNested<N> extends LoggingDestinationFluent<LoggingDestinationUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    LoggingDestinationUnsupportedConfigOverridesNested(LoggingDestination item) {
      this.builder = new LoggingDestinationBuilder(this, item);
    }
    LoggingDestinationBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endLoggingDestinationUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class IngressControllerTuningOptionsUnsupportedConfigOverridesNested<N> extends IngressControllerTuningOptionsFluent<IngressControllerTuningOptionsUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    IngressControllerTuningOptionsUnsupportedConfigOverridesNested(IngressControllerTuningOptions item) {
      this.builder = new IngressControllerTuningOptionsBuilder(this, item);
    }
    IngressControllerTuningOptionsBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endIngressControllerTuningOptionsUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StaticIPAMConfigUnsupportedOverridesNested<N> extends StaticIPAMConfigFluent<StaticIPAMConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    StaticIPAMConfigUnsupportedOverridesNested(StaticIPAMConfig item) {
      this.builder = new StaticIPAMConfigBuilder(this, item);
    }
    StaticIPAMConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class AWSCSIDriverConfigSpecUnsupportedOverridesNested<N> extends AWSCSIDriverConfigSpecFluent<AWSCSIDriverConfigSpecUnsupportedOverridesNested<N>> implements Nested<N>{
    AWSCSIDriverConfigSpecUnsupportedOverridesNested(AWSCSIDriverConfigSpec item) {
      this.builder = new AWSCSIDriverConfigSpecBuilder(this, item);
    }
    AWSCSIDriverConfigSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endAWSCSIDriverConfigSpecUnsupportedOverrides() {
      return and();
    }
    
  }
  public class KubeControllerManagerSpecUnsupportedConfigOverridesNested<N> extends KubeControllerManagerSpecFluent<KubeControllerManagerSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    KubeControllerManagerSpecUnsupportedConfigOverridesNested(KubeControllerManagerSpec item) {
      this.builder = new KubeControllerManagerSpecBuilder(this, item);
    }
    KubeControllerManagerSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endKubeControllerManagerSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StaticIPAMDNSUnsupportedConfigOverridesNested<N> extends StaticIPAMDNSFluent<StaticIPAMDNSUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StaticIPAMDNSUnsupportedConfigOverridesNested(StaticIPAMDNS item) {
      this.builder = new StaticIPAMDNSBuilder(this, item);
    }
    StaticIPAMDNSBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMDNSUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StorageSpecUnsupportedConfigOverridesNested<N> extends StorageSpecFluent<StorageSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StorageSpecUnsupportedConfigOverridesNested(StorageSpec item) {
      this.builder = new StorageSpecBuilder(this, item);
    }
    StorageSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStorageSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NodePlacementUnsupportedConfigOverridesNested<N> extends NodePlacementFluent<NodePlacementUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NodePlacementUnsupportedConfigOverridesNested(NodePlacement item) {
      this.builder = new NodePlacementBuilder(this, item);
    }
    NodePlacementBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNodePlacementUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NetworkSpecUnsupportedConfigOverridesNested<N> extends NetworkSpecFluent<NetworkSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    NetworkSpecUnsupportedConfigOverridesNested(NetworkSpec item) {
      this.builder = new NetworkSpecBuilder(this, item);
    }
    NetworkSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetworkSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConsoleStatusUnsupportedConfigOverridesNested<N> extends ConsoleStatusFluent<ConsoleStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleStatusUnsupportedConfigOverridesNested(ConsoleStatus item) {
      this.builder = new ConsoleStatusBuilder(this, item);
    }
    ConsoleStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ObjectReferenceUnsupportedConfigOverridesNested<N> extends ObjectReferenceFluent<ObjectReferenceUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ObjectReferenceUnsupportedConfigOverridesNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endObjectReferenceUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ServerUnsupportedConfigOverridesNested<N> extends ServerFluent<ServerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ServerUnsupportedConfigOverridesNested(Server item) {
      this.builder = new ServerBuilder(this, item);
    }
    ServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class CloudCredentialSpecUnsupportedConfigOverridesNested<N> extends CloudCredentialSpecFluent<CloudCredentialSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    CloudCredentialSpecUnsupportedConfigOverridesNested(CloudCredentialSpec item) {
      this.builder = new CloudCredentialSpecBuilder(this, item);
    }
    CloudCredentialSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endCloudCredentialSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSRecordStatusUnsupportedConfigOverridesNested<N> extends DNSRecordStatusFluent<DNSRecordStatusUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSRecordStatusUnsupportedConfigOverridesNested(DNSRecordStatus item) {
      this.builder = new DNSRecordStatusBuilder(this, item);
    }
    DNSRecordStatusBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordStatusUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ClusterNetworkEntryUnsupportedConfigOverridesNested<N> extends ClusterNetworkEntryFluent<ClusterNetworkEntryUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ClusterNetworkEntryUnsupportedConfigOverridesNested(ClusterNetworkEntry item) {
      this.builder = new ClusterNetworkEntryBuilder(this, item);
    }
    ClusterNetworkEntryBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endClusterNetworkEntryUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class HTTPCompressionPolicyUnsupportedConfigOverridesNested<N> extends HTTPCompressionPolicyFluent<HTTPCompressionPolicyUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    HTTPCompressionPolicyUnsupportedConfigOverridesNested(HTTPCompressionPolicy item) {
      this.builder = new HTTPCompressionPolicyBuilder(this, item);
    }
    HTTPCompressionPolicyBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endHTTPCompressionPolicyUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ProjectAccessUnsupportedConfigOverridesNested<N> extends ProjectAccessFluent<ProjectAccessUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ProjectAccessUnsupportedConfigOverridesNested(ProjectAccess item) {
      this.builder = new ProjectAccessBuilder(this, item);
    }
    ProjectAccessBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endProjectAccessUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class NetFlowConfigUnsupportedOverridesNested<N> extends NetFlowConfigFluent<NetFlowConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    NetFlowConfigUnsupportedOverridesNested(NetFlowConfig item) {
      this.builder = new NetFlowConfigBuilder(this, item);
    }
    NetFlowConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endNetFlowConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class GatewayConfigUnsupportedOverridesNested<N> extends GatewayConfigFluent<GatewayConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    GatewayConfigUnsupportedOverridesNested(GatewayConfig item) {
      this.builder = new GatewayConfigBuilder(this, item);
    }
    GatewayConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endGatewayConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class PolicyAuditConfigUnsupportedOverridesNested<N> extends PolicyAuditConfigFluent<PolicyAuditConfigUnsupportedOverridesNested<N>> implements Nested<N>{
    PolicyAuditConfigUnsupportedOverridesNested(PolicyAuditConfig item) {
      this.builder = new PolicyAuditConfigBuilder(this, item);
    }
    PolicyAuditConfigBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPolicyAuditConfigUnsupportedOverrides() {
      return and();
    }
    
  }
  public class PerspectiveVisibilityUnsupportedConfigOverridesNested<N> extends PerspectiveVisibilityFluent<PerspectiveVisibilityUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    PerspectiveVisibilityUnsupportedConfigOverridesNested(PerspectiveVisibility item) {
      this.builder = new PerspectiveVisibilityBuilder(this, item);
    }
    PerspectiveVisibilityBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endPerspectiveVisibilityUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class StaticIPAMAddressesUnsupportedConfigOverridesNested<N> extends StaticIPAMAddressesFluent<StaticIPAMAddressesUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    StaticIPAMAddressesUnsupportedConfigOverridesNested(StaticIPAMAddresses item) {
      this.builder = new StaticIPAMAddressesBuilder(this, item);
    }
    StaticIPAMAddressesBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endStaticIPAMAddressesUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class DNSRecordUnsupportedConfigOverridesNested<N> extends DNSRecordFluent<DNSRecordUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    DNSRecordUnsupportedConfigOverridesNested(DNSRecord item) {
      this.builder = new DNSRecordBuilder(this, item);
    }
    DNSRecordBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endDNSRecordUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class OpenShiftAPIServerUnsupportedConfigOverridesNested<N> extends OpenShiftAPIServerFluent<OpenShiftAPIServerUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    OpenShiftAPIServerUnsupportedConfigOverridesNested(OpenShiftAPIServer item) {
      this.builder = new OpenShiftAPIServerBuilder(this, item);
    }
    OpenShiftAPIServerBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endOpenShiftAPIServerUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  public class ConsoleSpecUnsupportedConfigOverridesNested<N> extends ConsoleSpecFluent<ConsoleSpecUnsupportedConfigOverridesNested<N>> implements Nested<N>{
    ConsoleSpecUnsupportedConfigOverridesNested(ConsoleSpec item) {
      this.builder = new ConsoleSpecBuilder(this, item);
    }
    ConsoleSpecBuilder builder;
    public N and() {
      return (N) IngressControllerSpecFluent.this.withUnsupportedConfigOverrides(builder.build());
    }
    public N endConsoleSpecUnsupportedConfigOverrides() {
      return and();
    }
    
  }
  
}