package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressControllerCaptureHTTPHeadersFluent<A extends IngressControllerCaptureHTTPHeadersFluent<A>> extends BaseFluent<A>{
  public IngressControllerCaptureHTTPHeadersFluent() {
  }
  public IngressControllerCaptureHTTPHeadersFluent(IngressControllerCaptureHTTPHeaders instance) {
    instance = (instance != null ? instance : new IngressControllerCaptureHTTPHeaders());

    if (instance != null) {
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<IngressControllerCaptureHTTPHeaderBuilder> request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();
  private ArrayList<IngressControllerCaptureHTTPHeaderBuilder> response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToRequest(int index,IngressControllerCaptureHTTPHeader item) {
    if (this.request == null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
    IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);
    if (index < 0 || index >= request.size()) { _visitables.get("request").add(builder); request.add(builder); } else { _visitables.get("request").add(index, builder); request.add(index, builder);}
    return (A)this;
  }
  public A setToRequest(int index,IngressControllerCaptureHTTPHeader item) {
    if (this.request == null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
    IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);
    if (index < 0 || index >= request.size()) { _visitables.get("request").add(builder); request.add(builder); } else { _visitables.get("request").set(index, builder); request.set(index, builder);}
    return (A)this;
  }
  public A addToRequest(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeader... items) {
    if (this.request == null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
    for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").add(builder);this.request.add(builder);} return (A)this;
  }
  public A addAllToRequest(Collection<IngressControllerCaptureHTTPHeader> items) {
    if (this.request == null) {this.request = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
    for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").add(builder);this.request.add(builder);} return (A)this;
  }
  public A removeFromRequest(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeader... items) {
    if (this.request == null) return (A)this;
    for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").remove(builder); this.request.remove(builder);} return (A)this;
  }
  public A removeAllFromRequest(Collection<IngressControllerCaptureHTTPHeader> items) {
    if (this.request == null) return (A)this;
    for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("request").remove(builder); this.request.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRequest(Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate) {
    if (request == null) return (A) this;
    final Iterator<IngressControllerCaptureHTTPHeaderBuilder> each = request.iterator();
    final List visitables = _visitables.get("request");
    while (each.hasNext()) {
      IngressControllerCaptureHTTPHeaderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<IngressControllerCaptureHTTPHeader> buildRequest() {
    return request != null ? build(request) : null;
  }
  public IngressControllerCaptureHTTPHeader buildRequest(int index) {
    return this.request.get(index).build();
  }
  public IngressControllerCaptureHTTPHeader buildFirstRequest() {
    return this.request.get(0).build();
  }
  public IngressControllerCaptureHTTPHeader buildLastRequest() {
    return this.request.get(request.size() - 1).build();
  }
  public IngressControllerCaptureHTTPHeader buildMatchingRequest(Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate) {
    for (IngressControllerCaptureHTTPHeaderBuilder item: request) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRequest(Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate) {
    for (IngressControllerCaptureHTTPHeaderBuilder item: request) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRequest(List<IngressControllerCaptureHTTPHeader> request) {
    if (this.request != null) { _visitables.get("request").clear();}
    if (request != null) {this.request = new ArrayList(); for (IngressControllerCaptureHTTPHeader item : request){this.addToRequest(item);}} else { this.request = null;} return (A) this;
  }
  public A withRequest(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeader... request) {
    if (this.request != null) {this.request.clear(); _visitables.remove("request"); }
    if (request != null) {for (IngressControllerCaptureHTTPHeader item :request){ this.addToRequest(item);}} return (A) this;
  }
  public boolean hasRequest() {
    return request != null && !request.isEmpty();
  }
  public A addNewRequest(Integer maxLength,String name) {
    return (A)addToRequest(new IngressControllerCaptureHTTPHeader(maxLength, name));
  }
  public RequestNested<A> addNewRequest() {
    return new RequestNested(-1, null);
  }
  public RequestNested<A> addNewRequestLike(IngressControllerCaptureHTTPHeader item) {
    return new RequestNested(-1, item);
  }
  public RequestNested<A> setNewRequestLike(int index,IngressControllerCaptureHTTPHeader item) {
    return new RequestNested(index, item);
  }
  public RequestNested<A> editRequest(int index) {
    if (request.size() <= index) throw new RuntimeException("Can't edit request. Index exceeds size.");
    return setNewRequestLike(index, buildRequest(index));
  }
  public RequestNested<A> editFirstRequest() {
    if (request.size() == 0) throw new RuntimeException("Can't edit first request. The list is empty.");
    return setNewRequestLike(0, buildRequest(0));
  }
  public RequestNested<A> editLastRequest() {
    int index = request.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last request. The list is empty.");
    return setNewRequestLike(index, buildRequest(index));
  }
  public RequestNested<A> editMatchingRequest(Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<request.size();i++) { 
    if (predicate.test(request.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching request. No match found.");
    return setNewRequestLike(index, buildRequest(index));
  }
  public A addToResponse(int index,IngressControllerCaptureHTTPHeader item) {
    if (this.response == null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
    IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);
    if (index < 0 || index >= response.size()) { _visitables.get("response").add(builder); response.add(builder); } else { _visitables.get("response").add(index, builder); response.add(index, builder);}
    return (A)this;
  }
  public A setToResponse(int index,IngressControllerCaptureHTTPHeader item) {
    if (this.response == null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
    IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);
    if (index < 0 || index >= response.size()) { _visitables.get("response").add(builder); response.add(builder); } else { _visitables.get("response").set(index, builder); response.set(index, builder);}
    return (A)this;
  }
  public A addToResponse(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeader... items) {
    if (this.response == null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
    for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").add(builder);this.response.add(builder);} return (A)this;
  }
  public A addAllToResponse(Collection<IngressControllerCaptureHTTPHeader> items) {
    if (this.response == null) {this.response = new ArrayList<IngressControllerCaptureHTTPHeaderBuilder>();}
    for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").add(builder);this.response.add(builder);} return (A)this;
  }
  public A removeFromResponse(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeader... items) {
    if (this.response == null) return (A)this;
    for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").remove(builder); this.response.remove(builder);} return (A)this;
  }
  public A removeAllFromResponse(Collection<IngressControllerCaptureHTTPHeader> items) {
    if (this.response == null) return (A)this;
    for (IngressControllerCaptureHTTPHeader item : items) {IngressControllerCaptureHTTPHeaderBuilder builder = new IngressControllerCaptureHTTPHeaderBuilder(item);_visitables.get("response").remove(builder); this.response.remove(builder);} return (A)this;
  }
  public A removeMatchingFromResponse(Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate) {
    if (response == null) return (A) this;
    final Iterator<IngressControllerCaptureHTTPHeaderBuilder> each = response.iterator();
    final List visitables = _visitables.get("response");
    while (each.hasNext()) {
      IngressControllerCaptureHTTPHeaderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<IngressControllerCaptureHTTPHeader> buildResponse() {
    return response != null ? build(response) : null;
  }
  public IngressControllerCaptureHTTPHeader buildResponse(int index) {
    return this.response.get(index).build();
  }
  public IngressControllerCaptureHTTPHeader buildFirstResponse() {
    return this.response.get(0).build();
  }
  public IngressControllerCaptureHTTPHeader buildLastResponse() {
    return this.response.get(response.size() - 1).build();
  }
  public IngressControllerCaptureHTTPHeader buildMatchingResponse(Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate) {
    for (IngressControllerCaptureHTTPHeaderBuilder item: response) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingResponse(Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate) {
    for (IngressControllerCaptureHTTPHeaderBuilder item: response) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResponse(List<IngressControllerCaptureHTTPHeader> response) {
    if (this.response != null) { _visitables.get("response").clear();}
    if (response != null) {this.response = new ArrayList(); for (IngressControllerCaptureHTTPHeader item : response){this.addToResponse(item);}} else { this.response = null;} return (A) this;
  }
  public A withResponse(io.fabric8.openshift.api.model.operator.v1.IngressControllerCaptureHTTPHeader... response) {
    if (this.response != null) {this.response.clear(); _visitables.remove("response"); }
    if (response != null) {for (IngressControllerCaptureHTTPHeader item :response){ this.addToResponse(item);}} return (A) this;
  }
  public boolean hasResponse() {
    return response != null && !response.isEmpty();
  }
  public A addNewResponse(Integer maxLength,String name) {
    return (A)addToResponse(new IngressControllerCaptureHTTPHeader(maxLength, name));
  }
  public ResponseNested<A> addNewResponse() {
    return new ResponseNested(-1, null);
  }
  public ResponseNested<A> addNewResponseLike(IngressControllerCaptureHTTPHeader item) {
    return new ResponseNested(-1, item);
  }
  public ResponseNested<A> setNewResponseLike(int index,IngressControllerCaptureHTTPHeader item) {
    return new ResponseNested(index, item);
  }
  public ResponseNested<A> editResponse(int index) {
    if (response.size() <= index) throw new RuntimeException("Can't edit response. Index exceeds size.");
    return setNewResponseLike(index, buildResponse(index));
  }
  public ResponseNested<A> editFirstResponse() {
    if (response.size() == 0) throw new RuntimeException("Can't edit first response. The list is empty.");
    return setNewResponseLike(0, buildResponse(0));
  }
  public ResponseNested<A> editLastResponse() {
    int index = response.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last response. The list is empty.");
    return setNewResponseLike(index, buildResponse(index));
  }
  public ResponseNested<A> editMatchingResponse(Predicate<IngressControllerCaptureHTTPHeaderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<response.size();i++) { 
    if (predicate.test(response.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching response. No match found.");
    return setNewResponseLike(index, buildResponse(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressControllerCaptureHTTPHeadersFluent that = (IngressControllerCaptureHTTPHeadersFluent) o;
    if (!java.util.Objects.equals(request, that.request)) return false;

    if (!java.util.Objects.equals(response, that.response)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(request,  response,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (request != null && !request.isEmpty()) { sb.append("request:"); sb.append(request + ","); }
    if (response != null && !response.isEmpty()) { sb.append("response:"); sb.append(response + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RequestNested<N> extends IngressControllerCaptureHTTPHeaderFluent<RequestNested<N>> implements Nested<N>{
    RequestNested(int index,IngressControllerCaptureHTTPHeader item) {
      this.index = index;
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeaderBuilder builder;
    int index;
    public N and() {
      return (N) IngressControllerCaptureHTTPHeadersFluent.this.setToRequest(index,builder.build());
    }
    public N endRequest() {
      return and();
    }
    
  }
  public class ResponseNested<N> extends IngressControllerCaptureHTTPHeaderFluent<ResponseNested<N>> implements Nested<N>{
    ResponseNested(int index,IngressControllerCaptureHTTPHeader item) {
      this.index = index;
      this.builder = new IngressControllerCaptureHTTPHeaderBuilder(this, item);
    }
    IngressControllerCaptureHTTPHeaderBuilder builder;
    int index;
    public N and() {
      return (N) IngressControllerCaptureHTTPHeadersFluent.this.setToResponse(index,builder.build());
    }
    public N endResponse() {
      return and();
    }
    
  }
  
}