package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IBMLoadBalancerParametersBuilder extends IBMLoadBalancerParametersFluent<IBMLoadBalancerParametersBuilder> implements VisitableBuilder<IBMLoadBalancerParameters,IBMLoadBalancerParametersBuilder>{
  public IBMLoadBalancerParametersBuilder() {
    this(false);
  }
  public IBMLoadBalancerParametersBuilder(Boolean validationEnabled) {
    this(new IBMLoadBalancerParameters(), validationEnabled);
  }
  public IBMLoadBalancerParametersBuilder(IBMLoadBalancerParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public IBMLoadBalancerParametersBuilder(IBMLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IBMLoadBalancerParameters(), validationEnabled);
  }
  public IBMLoadBalancerParametersBuilder(IBMLoadBalancerParametersFluent<?> fluent,IBMLoadBalancerParameters instance) {
    this(fluent, instance, false);
  }
  public IBMLoadBalancerParametersBuilder(IBMLoadBalancerParametersFluent<?> fluent,IBMLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IBMLoadBalancerParameters());

    if (instance != null) {
      fluent.withProtocol(instance.getProtocol());
      fluent.withProtocol(instance.getProtocol());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IBMLoadBalancerParametersBuilder(IBMLoadBalancerParameters instance) {
    this(instance,false);
  }
  public IBMLoadBalancerParametersBuilder(IBMLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IBMLoadBalancerParameters());

    if (instance != null) {
      this.withProtocol(instance.getProtocol());
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IBMLoadBalancerParametersFluent<?> fluent;
  Boolean validationEnabled;
  public IBMLoadBalancerParameters build() {
    IBMLoadBalancerParameters buildable = new IBMLoadBalancerParameters(fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}