package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GenerationStatusBuilder extends GenerationStatusFluent<GenerationStatusBuilder> implements VisitableBuilder<GenerationStatus,GenerationStatusBuilder>{
  public GenerationStatusBuilder() {
    this(false);
  }
  public GenerationStatusBuilder(Boolean validationEnabled) {
    this(new GenerationStatus(), validationEnabled);
  }
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GenerationStatus(), validationEnabled);
  }
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,GenerationStatus instance) {
    this(fluent, instance, false);
  }
  public GenerationStatusBuilder(GenerationStatusFluent<?> fluent,GenerationStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GenerationStatus());

    if (instance != null) {
      fluent.withGroup(instance.getGroup());
      fluent.withHash(instance.getHash());
      fluent.withLastGeneration(instance.getLastGeneration());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withGroup(instance.getGroup());
      fluent.withHash(instance.getHash());
      fluent.withLastGeneration(instance.getLastGeneration());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResource(instance.getResource());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GenerationStatusBuilder(GenerationStatus instance) {
    this(instance,false);
  }
  public GenerationStatusBuilder(GenerationStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GenerationStatus());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withHash(instance.getHash());
      this.withLastGeneration(instance.getLastGeneration());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withGroup(instance.getGroup());
      this.withHash(instance.getHash());
      this.withLastGeneration(instance.getLastGeneration());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResource(instance.getResource());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GenerationStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GenerationStatus build() {
    GenerationStatus buildable = new GenerationStatus(fluent.getGroup(),fluent.getHash(),fluent.getLastGeneration(),fluent.getName(),fluent.getNamespace(),fluent.getResource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}