package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayConfigBuilder extends GatewayConfigFluent<GatewayConfigBuilder> implements VisitableBuilder<GatewayConfig,GatewayConfigBuilder>{
  public GatewayConfigBuilder() {
    this(false);
  }
  public GatewayConfigBuilder(Boolean validationEnabled) {
    this(new GatewayConfig(), validationEnabled);
  }
  public GatewayConfigBuilder(GatewayConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayConfigBuilder(GatewayConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayConfig(), validationEnabled);
  }
  public GatewayConfigBuilder(GatewayConfigFluent<?> fluent,GatewayConfig instance) {
    this(fluent, instance, false);
  }
  public GatewayConfigBuilder(GatewayConfigFluent<?> fluent,GatewayConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GatewayConfig());

    if (instance != null) {
      fluent.withIpForwarding(instance.getIpForwarding());
      fluent.withRoutingViaHost(instance.getRoutingViaHost());
      fluent.withIpForwarding(instance.getIpForwarding());
      fluent.withRoutingViaHost(instance.getRoutingViaHost());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GatewayConfigBuilder(GatewayConfig instance) {
    this(instance,false);
  }
  public GatewayConfigBuilder(GatewayConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GatewayConfig());

    if (instance != null) {
      this.withIpForwarding(instance.getIpForwarding());
      this.withRoutingViaHost(instance.getRoutingViaHost());
      this.withIpForwarding(instance.getIpForwarding());
      this.withRoutingViaHost(instance.getRoutingViaHost());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GatewayConfigFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayConfig build() {
    GatewayConfig buildable = new GatewayConfig(fluent.getIpForwarding(),fluent.getRoutingViaHost());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}