package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPLoadBalancerParametersBuilder extends GCPLoadBalancerParametersFluent<GCPLoadBalancerParametersBuilder> implements VisitableBuilder<GCPLoadBalancerParameters,GCPLoadBalancerParametersBuilder>{
  public GCPLoadBalancerParametersBuilder() {
    this(false);
  }
  public GCPLoadBalancerParametersBuilder(Boolean validationEnabled) {
    this(new GCPLoadBalancerParameters(), validationEnabled);
  }
  public GCPLoadBalancerParametersBuilder(GCPLoadBalancerParametersFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPLoadBalancerParametersBuilder(GCPLoadBalancerParametersFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPLoadBalancerParameters(), validationEnabled);
  }
  public GCPLoadBalancerParametersBuilder(GCPLoadBalancerParametersFluent<?> fluent,GCPLoadBalancerParameters instance) {
    this(fluent, instance, false);
  }
  public GCPLoadBalancerParametersBuilder(GCPLoadBalancerParametersFluent<?> fluent,GCPLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GCPLoadBalancerParameters());

    if (instance != null) {
      fluent.withClientAccess(instance.getClientAccess());
      fluent.withClientAccess(instance.getClientAccess());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GCPLoadBalancerParametersBuilder(GCPLoadBalancerParameters instance) {
    this(instance,false);
  }
  public GCPLoadBalancerParametersBuilder(GCPLoadBalancerParameters instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GCPLoadBalancerParameters());

    if (instance != null) {
      this.withClientAccess(instance.getClientAccess());
      this.withClientAccess(instance.getClientAccess());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GCPLoadBalancerParametersFluent<?> fluent;
  Boolean validationEnabled;
  public GCPLoadBalancerParameters build() {
    GCPLoadBalancerParameters buildable = new GCPLoadBalancerParameters(fluent.getClientAccess());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}