package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ForwardPluginBuilder extends ForwardPluginFluent<ForwardPluginBuilder> implements VisitableBuilder<ForwardPlugin,ForwardPluginBuilder>{
  public ForwardPluginBuilder() {
    this(false);
  }
  public ForwardPluginBuilder(Boolean validationEnabled) {
    this(new ForwardPlugin(), validationEnabled);
  }
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent) {
    this(fluent, false);
  }
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ForwardPlugin(), validationEnabled);
  }
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,ForwardPlugin instance) {
    this(fluent, instance, false);
  }
  public ForwardPluginBuilder(ForwardPluginFluent<?> fluent,ForwardPlugin instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ForwardPlugin());

    if (instance != null) {
      fluent.withPolicy(instance.getPolicy());
      fluent.withProtocolStrategy(instance.getProtocolStrategy());
      fluent.withTransportConfig(instance.getTransportConfig());
      fluent.withUpstreams(instance.getUpstreams());
      fluent.withPolicy(instance.getPolicy());
      fluent.withProtocolStrategy(instance.getProtocolStrategy());
      fluent.withTransportConfig(instance.getTransportConfig());
      fluent.withUpstreams(instance.getUpstreams());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ForwardPluginBuilder(ForwardPlugin instance) {
    this(instance,false);
  }
  public ForwardPluginBuilder(ForwardPlugin instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ForwardPlugin());

    if (instance != null) {
      this.withPolicy(instance.getPolicy());
      this.withProtocolStrategy(instance.getProtocolStrategy());
      this.withTransportConfig(instance.getTransportConfig());
      this.withUpstreams(instance.getUpstreams());
      this.withPolicy(instance.getPolicy());
      this.withProtocolStrategy(instance.getProtocolStrategy());
      this.withTransportConfig(instance.getTransportConfig());
      this.withUpstreams(instance.getUpstreams());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ForwardPluginFluent<?> fluent;
  Boolean validationEnabled;
  public ForwardPlugin build() {
    ForwardPlugin buildable = new ForwardPlugin(fluent.getPolicy(),fluent.getProtocolStrategy(),fluent.buildTransportConfig(),fluent.getUpstreams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}