package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExportNetworkFlowsBuilder extends ExportNetworkFlowsFluent<ExportNetworkFlowsBuilder> implements VisitableBuilder<ExportNetworkFlows,ExportNetworkFlowsBuilder>{
  public ExportNetworkFlowsBuilder() {
    this(false);
  }
  public ExportNetworkFlowsBuilder(Boolean validationEnabled) {
    this(new ExportNetworkFlows(), validationEnabled);
  }
  public ExportNetworkFlowsBuilder(ExportNetworkFlowsFluent<?> fluent) {
    this(fluent, false);
  }
  public ExportNetworkFlowsBuilder(ExportNetworkFlowsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExportNetworkFlows(), validationEnabled);
  }
  public ExportNetworkFlowsBuilder(ExportNetworkFlowsFluent<?> fluent,ExportNetworkFlows instance) {
    this(fluent, instance, false);
  }
  public ExportNetworkFlowsBuilder(ExportNetworkFlowsFluent<?> fluent,ExportNetworkFlows instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExportNetworkFlows());

    if (instance != null) {
      fluent.withIpfix(instance.getIpfix());
      fluent.withNetFlow(instance.getNetFlow());
      fluent.withSFlow(instance.getSFlow());
      fluent.withIpfix(instance.getIpfix());
      fluent.withNetFlow(instance.getNetFlow());
      fluent.withSFlow(instance.getSFlow());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExportNetworkFlowsBuilder(ExportNetworkFlows instance) {
    this(instance,false);
  }
  public ExportNetworkFlowsBuilder(ExportNetworkFlows instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExportNetworkFlows());

    if (instance != null) {
      this.withIpfix(instance.getIpfix());
      this.withNetFlow(instance.getNetFlow());
      this.withSFlow(instance.getSFlow());
      this.withIpfix(instance.getIpfix());
      this.withNetFlow(instance.getNetFlow());
      this.withSFlow(instance.getSFlow());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExportNetworkFlowsFluent<?> fluent;
  Boolean validationEnabled;
  public ExportNetworkFlows build() {
    ExportNetworkFlows buildable = new ExportNetworkFlows(fluent.buildIpfix(),fluent.buildNetFlow(),fluent.buildSFlow());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}