package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EtcdStatusBuilder extends EtcdStatusFluent<EtcdStatusBuilder> implements VisitableBuilder<EtcdStatus,EtcdStatusBuilder>{
  public EtcdStatusBuilder() {
    this(false);
  }
  public EtcdStatusBuilder(Boolean validationEnabled) {
    this(new EtcdStatus(), validationEnabled);
  }
  public EtcdStatusBuilder(EtcdStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public EtcdStatusBuilder(EtcdStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EtcdStatus(), validationEnabled);
  }
  public EtcdStatusBuilder(EtcdStatusFluent<?> fluent,EtcdStatus instance) {
    this(fluent, instance, false);
  }
  public EtcdStatusBuilder(EtcdStatusFluent<?> fluent,EtcdStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EtcdStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      fluent.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
      fluent.withNodeStatuses(instance.getNodeStatuses());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withConditions(instance.getConditions());
      fluent.withGenerations(instance.getGenerations());
      fluent.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      fluent.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
      fluent.withNodeStatuses(instance.getNodeStatuses());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EtcdStatusBuilder(EtcdStatus instance) {
    this(instance,false);
  }
  public EtcdStatusBuilder(EtcdStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EtcdStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
      this.withNodeStatuses(instance.getNodeStatuses());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withConditions(instance.getConditions());
      this.withGenerations(instance.getGenerations());
      this.withLatestAvailableRevision(instance.getLatestAvailableRevision());
      this.withLatestAvailableRevisionReason(instance.getLatestAvailableRevisionReason());
      this.withNodeStatuses(instance.getNodeStatuses());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EtcdStatusFluent<?> fluent;
  Boolean validationEnabled;
  public EtcdStatus build() {
    EtcdStatus buildable = new EtcdStatus(fluent.buildConditions(),fluent.buildGenerations(),fluent.getLatestAvailableRevision(),fluent.getLatestAvailableRevisionReason(),fluent.buildNodeStatuses(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}