package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressIPConfigBuilder extends EgressIPConfigFluent<EgressIPConfigBuilder> implements VisitableBuilder<EgressIPConfig,EgressIPConfigBuilder>{
  public EgressIPConfigBuilder() {
    this(false);
  }
  public EgressIPConfigBuilder(Boolean validationEnabled) {
    this(new EgressIPConfig(), validationEnabled);
  }
  public EgressIPConfigBuilder(EgressIPConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressIPConfigBuilder(EgressIPConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EgressIPConfig(), validationEnabled);
  }
  public EgressIPConfigBuilder(EgressIPConfigFluent<?> fluent,EgressIPConfig instance) {
    this(fluent, instance, false);
  }
  public EgressIPConfigBuilder(EgressIPConfigFluent<?> fluent,EgressIPConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EgressIPConfig());

    if (instance != null) {
      fluent.withReachabilityTotalTimeoutSeconds(instance.getReachabilityTotalTimeoutSeconds());
      fluent.withReachabilityTotalTimeoutSeconds(instance.getReachabilityTotalTimeoutSeconds());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EgressIPConfigBuilder(EgressIPConfig instance) {
    this(instance,false);
  }
  public EgressIPConfigBuilder(EgressIPConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EgressIPConfig());

    if (instance != null) {
      this.withReachabilityTotalTimeoutSeconds(instance.getReachabilityTotalTimeoutSeconds());
      this.withReachabilityTotalTimeoutSeconds(instance.getReachabilityTotalTimeoutSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EgressIPConfigFluent<?> fluent;
  Boolean validationEnabled;
  public EgressIPConfig build() {
    EgressIPConfig buildable = new EgressIPConfig(fluent.getReachabilityTotalTimeoutSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}