package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeveloperConsoleCatalogCustomizationBuilder extends DeveloperConsoleCatalogCustomizationFluent<DeveloperConsoleCatalogCustomizationBuilder> implements VisitableBuilder<DeveloperConsoleCatalogCustomization,DeveloperConsoleCatalogCustomizationBuilder>{
  public DeveloperConsoleCatalogCustomizationBuilder() {
    this(false);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(Boolean validationEnabled) {
    this(new DeveloperConsoleCatalogCustomization(), validationEnabled);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomizationFluent<?> fluent) {
    this(fluent, false);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomizationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeveloperConsoleCatalogCustomization(), validationEnabled);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomizationFluent<?> fluent,DeveloperConsoleCatalogCustomization instance) {
    this(fluent, instance, false);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomizationFluent<?> fluent,DeveloperConsoleCatalogCustomization instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeveloperConsoleCatalogCustomization());

    if (instance != null) {
      fluent.withCategories(instance.getCategories());
      fluent.withTypes(instance.getTypes());
      fluent.withCategories(instance.getCategories());
      fluent.withTypes(instance.getTypes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomization instance) {
    this(instance,false);
  }
  public DeveloperConsoleCatalogCustomizationBuilder(DeveloperConsoleCatalogCustomization instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeveloperConsoleCatalogCustomization());

    if (instance != null) {
      this.withCategories(instance.getCategories());
      this.withTypes(instance.getTypes());
      this.withCategories(instance.getCategories());
      this.withTypes(instance.getTypes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeveloperConsoleCatalogCustomizationFluent<?> fluent;
  Boolean validationEnabled;
  public DeveloperConsoleCatalogCustomization build() {
    DeveloperConsoleCatalogCustomization buildable = new DeveloperConsoleCatalogCustomization(fluent.buildCategories(),fluent.buildTypes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}