package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeveloperConsoleCatalogCategoryBuilder extends DeveloperConsoleCatalogCategoryFluent<DeveloperConsoleCatalogCategoryBuilder> implements VisitableBuilder<DeveloperConsoleCatalogCategory,DeveloperConsoleCatalogCategoryBuilder>{
  public DeveloperConsoleCatalogCategoryBuilder() {
    this(false);
  }
  public DeveloperConsoleCatalogCategoryBuilder(Boolean validationEnabled) {
    this(new DeveloperConsoleCatalogCategory(), validationEnabled);
  }
  public DeveloperConsoleCatalogCategoryBuilder(DeveloperConsoleCatalogCategoryFluent<?> fluent) {
    this(fluent, false);
  }
  public DeveloperConsoleCatalogCategoryBuilder(DeveloperConsoleCatalogCategoryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeveloperConsoleCatalogCategory(), validationEnabled);
  }
  public DeveloperConsoleCatalogCategoryBuilder(DeveloperConsoleCatalogCategoryFluent<?> fluent,DeveloperConsoleCatalogCategory instance) {
    this(fluent, instance, false);
  }
  public DeveloperConsoleCatalogCategoryBuilder(DeveloperConsoleCatalogCategoryFluent<?> fluent,DeveloperConsoleCatalogCategory instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DeveloperConsoleCatalogCategory());

    if (instance != null) {
      fluent.withId(instance.getId());
      fluent.withLabel(instance.getLabel());
      fluent.withSubcategories(instance.getSubcategories());
      fluent.withTags(instance.getTags());
      fluent.withId(instance.getId());
      fluent.withLabel(instance.getLabel());
      fluent.withSubcategories(instance.getSubcategories());
      fluent.withTags(instance.getTags());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeveloperConsoleCatalogCategoryBuilder(DeveloperConsoleCatalogCategory instance) {
    this(instance,false);
  }
  public DeveloperConsoleCatalogCategoryBuilder(DeveloperConsoleCatalogCategory instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DeveloperConsoleCatalogCategory());

    if (instance != null) {
      this.withId(instance.getId());
      this.withLabel(instance.getLabel());
      this.withSubcategories(instance.getSubcategories());
      this.withTags(instance.getTags());
      this.withId(instance.getId());
      this.withLabel(instance.getLabel());
      this.withSubcategories(instance.getSubcategories());
      this.withTags(instance.getTags());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeveloperConsoleCatalogCategoryFluent<?> fluent;
  Boolean validationEnabled;
  public DeveloperConsoleCatalogCategory build() {
    DeveloperConsoleCatalogCategory buildable = new DeveloperConsoleCatalogCategory(fluent.getId(),fluent.getLabel(),fluent.buildSubcategories(),fluent.getTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}