package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSZoneStatusBuilder extends DNSZoneStatusFluent<DNSZoneStatusBuilder> implements VisitableBuilder<DNSZoneStatus,DNSZoneStatusBuilder>{
  public DNSZoneStatusBuilder() {
    this(false);
  }
  public DNSZoneStatusBuilder(Boolean validationEnabled) {
    this(new DNSZoneStatus(), validationEnabled);
  }
  public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSZoneStatus(), validationEnabled);
  }
  public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,DNSZoneStatus instance) {
    this(fluent, instance, false);
  }
  public DNSZoneStatusBuilder(DNSZoneStatusFluent<?> fluent,DNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSZoneStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withDnsZone(instance.getDnsZone());
      fluent.withConditions(instance.getConditions());
      fluent.withDnsZone(instance.getDnsZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSZoneStatusBuilder(DNSZoneStatus instance) {
    this(instance,false);
  }
  public DNSZoneStatusBuilder(DNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSZoneStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withDnsZone(instance.getDnsZone());
      this.withConditions(instance.getConditions());
      this.withDnsZone(instance.getDnsZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSZoneStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DNSZoneStatus build() {
    DNSZoneStatus buildable = new DNSZoneStatus(fluent.buildConditions(),fluent.getDnsZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}