package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSTransportConfigBuilder extends DNSTransportConfigFluent<DNSTransportConfigBuilder> implements VisitableBuilder<DNSTransportConfig,DNSTransportConfigBuilder>{
  public DNSTransportConfigBuilder() {
    this(false);
  }
  public DNSTransportConfigBuilder(Boolean validationEnabled) {
    this(new DNSTransportConfig(), validationEnabled);
  }
  public DNSTransportConfigBuilder(DNSTransportConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSTransportConfigBuilder(DNSTransportConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSTransportConfig(), validationEnabled);
  }
  public DNSTransportConfigBuilder(DNSTransportConfigFluent<?> fluent,DNSTransportConfig instance) {
    this(fluent, instance, false);
  }
  public DNSTransportConfigBuilder(DNSTransportConfigFluent<?> fluent,DNSTransportConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSTransportConfig());

    if (instance != null) {
      fluent.withTls(instance.getTls());
      fluent.withTransport(instance.getTransport());
      fluent.withTls(instance.getTls());
      fluent.withTransport(instance.getTransport());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSTransportConfigBuilder(DNSTransportConfig instance) {
    this(instance,false);
  }
  public DNSTransportConfigBuilder(DNSTransportConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSTransportConfig());

    if (instance != null) {
      this.withTls(instance.getTls());
      this.withTransport(instance.getTransport());
      this.withTls(instance.getTls());
      this.withTransport(instance.getTransport());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSTransportConfigFluent<?> fluent;
  Boolean validationEnabled;
  public DNSTransportConfig build() {
    DNSTransportConfig buildable = new DNSTransportConfig(fluent.buildTls(),fluent.getTransport());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}